// Copyright 2000-2024 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.Nullable;

public interface PhpPropertyHook extends PhpNamedElement, Method {
  Condition<PsiElement> IS_GET_HOOK = it -> it instanceof PhpPropertyHook && ((PhpPropertyHook)it).getHookType() == PhpPropertyHookType.GET;
  Condition<PsiElement> IS_SET_HOOK = it -> it instanceof PhpPropertyHook && ((PhpPropertyHook)it).getHookType() == PhpPropertyHookType.SET;
  Condition<PsiElement> INSTANCEOF = use -> use instanceof PhpPropertyHook;
  ArrayFactory<PhpPropertyHook> ARRAY_FACTORY = count -> count > 0 ? new PhpPropertyHook[count] : new PhpPropertyHook[0];

  enum PhpPropertyHookType {
    GET("get", "return $this->%s;"),
    SET("set", "$this->%s = $value;"),
    ;

    public final String keyWord;

    public final String defaultBody;

    PhpPropertyHookType(String keyWord, String defaultBody) {
      this.keyWord = keyWord;
      this.defaultBody = defaultBody;
    }
  }

  PhpPropertyHookType getHookType();

  boolean isShort();

  @Nullable Field getContainingField();

  @Nullable ParameterList getParameterList();
}
