// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.inspections.reference.elements;

import com.jetbrains.php.lang.psi.elements.PhpClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public interface PhpRefClass extends PhpRefElement {
  PhpRefClass @NotNull [] EMPTY_ARRAY = new PhpRefClass[0];

  void setConstructorImplicitlyUsed();

  boolean isConstructorImplicitlyUsed();

  boolean isFieldsImplicitlyUsed();

  void setFieldsImplicitlyUsed();

  boolean hasSuspiciousCallersByClass();

  void attachFieldsImplicitly();

  int getCoreMethodsReferencedFlag();

  void setCoreMethodReferenced(int coreMethodHash);

  boolean isCoreInterfacesImplemented(int coreInterfacesHash);

  void setCoreInterfacesImplemented(int coreInterfacesHash);

  boolean isUsedByConstants();

  boolean isWithDuplicates();

  boolean isMagicMethodReferenced(final int magicMethodHash);

  void setMagicMethodReferenced(final int magicMethodHash);

  boolean isAnonymous();

  boolean isInterface();

  boolean isAbstract();

  boolean isFinal();

  boolean isTrait();

  boolean isWithImplicitConstructor();

  boolean hasOnlyStaticMethodsOrConstants();

  boolean isUtility();

  boolean isTest();
  
  @Nullable
  @Override
  PhpClass getPhpElement();

  @Nullable
  PhpRefMethod getConstructor();

  void setConstructor(@NotNull PhpRefMethod refMethod);

  @Nullable
  PhpRefMethod getOwnConstructor();

  @NotNull
  Set<PhpRefClass> getSubClasses();

  @NotNull
  Set<PhpRefClass> getSuperClasses();

  @NotNull
  Set<PhpRefClass> getDuplicates();
}
