// Copyright 2000-2019 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public interface PhpExternalUsagesSearcher {
  @NotNull
  ExtensionPointName<PhpExternalUsagesSearcher> EP_NAME = ExtensionPointName.create("com.jetbrains.php.externalUsagesSearcher");
  
  void processUsages(@NotNull GlobalInspectionContext context,
                     @NotNull SearchScope scope,
                     @NotNull PsiElement element,
                     @NotNull Processor<? super PsiReference> processor);
}
