/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.google.common.net.HostAndPort;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.ssh.ChannelSshTransportException;
import com.intellij.ssh.ExecChannelConfig;
import com.intellij.ssh.SftpChannelConfig;
import com.intellij.ssh.ShellChannelConfig;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSessionChannelFactory;
import com.intellij.ssh.SshTunnelAlreadyRegisteredException;
import com.intellij.ssh.X11Forwarding;
import com.intellij.ssh.channels.ExecChannel;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.config.EnvironmentVariable;
import com.intellij.ssh.config.OpenSshConfigForwardInfo;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.channels.PatchedExecChannel;
import com.intellij.ssh.impl.sshj.channels.PatchedSftpChannel;
import com.intellij.ssh.impl.sshj.channels.PatchedShellChannel;
import com.intellij.ssh.impl.sshj.channels.SshjExecChannel;
import com.intellij.ssh.impl.sshj.channels.SshjSftpChannel;
import com.intellij.ssh.impl.sshj.channels.SshjShellChannel;
import com.intellij.ssh.impl.sshj.tunnels.LocalForwarderCollection;
import com.intellij.ssh.impl.sshj.tunnels.RemoteForwarderCollection;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\u001a\u001a\u0002H\u001b\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010\"\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020.H\u0016J \u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0017H\u0016J\u0018\u00105\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0017H\u0016J \u00106\u001a\u00020%2\u0006\u00104\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0017H\u0016J\u0018\u00107\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0017H\u0016J\u0010\u00108\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u00106\u001a\u00020%2\u0006\u00109\u001a\u00020:2\u0006\u00104\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0017H\u0016J \u00107\u001a\u00020\u00172\u0006\u00109\u001a\u00020:2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0017H\u0016J\u0018\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010;\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00070=H\u0016J\b\u0010>\u001a\u00020%H\u0016J\b\u0010?\u001a\u00020%H\u0016J\u0017\u0010@\u001a\u0004\u0018\u00010A2\u0006\u00103\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\bBJ\b\u0010C\u001a\u00020\u0007H\u0016J\"\u0010D\u001a\u0002HE\"\u0004\b\u0000\u0010E2\f\u0010F\u001a\b\u0012\u0004\u0012\u0002HE0GH\u0082\b\u00a2\u0006\u0002\u0010HR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00101\u00a8\u0006I"}, d2={"Lcom/intellij/ssh/impl/sshj/SshjSshConnection;", "Lcom/intellij/ssh/SshSessionChannelFactory;", "connectionConfig", "Lcom/intellij/ssh/config/SshConnectionConfig;", "sshjBackend", "Lnet/schmizz/sshj/SSHClient;", "userName", "", "executor", "Ljava/util/concurrent/ExecutorService;", "SshjSshConnection", "(Lcom/intellij/ssh/config/SshConnectionConfig;Lnet/schmizz/sshj/SSHClient;Ljava/lang/String;Ljava/util/concurrent/ExecutorService;)V", "getSshjBackend$intellij_platform_ssh", "()Lnet/schmizz/sshj/SSHClient;", "getUserName", "()Ljava/lang/String;", "localForwarders", "Lcom/intellij/ssh/impl/sshj/tunnels/LocalForwarderCollection;", "remoteForwarders", "Lcom/intellij/ssh/impl/sshj/tunnels/RemoteForwarderCollection;", "host", "getHost", "port", "", "getPort", "()I", "openChannel", "C", "Lcom/intellij/ssh/channels/SshChannel;", "channelCreator", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Lcom/intellij/ssh/channels/SshChannel;", "execChannel", "Lcom/intellij/ssh/channels/ExecChannel;", "channelConfig", "Lcom/intellij/ssh/ExecChannelConfig;", "i", "", "channel", "Lnet/schmizz/sshj/connection/channel/direct/Session;", "w", "sftpChannel", "Lcom/intellij/ssh/channels/SftpChannel;", "Lcom/intellij/ssh/SftpChannelConfig;", "shellChannel", "Lcom/intellij/ssh/channels/ShellChannel;", "Lcom/intellij/ssh/ShellChannelConfig;", "isConnected", "", "()Z", "addRemoteTunnel", "remotePort", "localPort", "addRemoteTunnelWithRandomRemotePort", "addLocalTunnel", "addLocalTunnelWithRandomLocalPort", "removeLocalTunnel", "localAddress", "Ljava/net/InetAddress;", "removeRemoteTunnel", "getPortForwardingList", "", "disconnect", "applyPortForwardings", "getLocalTunnel", "Lcom/google/common/net/HostAndPort;", "getLocalTunnel$intellij_platform_ssh", "toString", "i", "T", "handler", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshjSshConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjSshConnection.kt\ncom/intellij/ssh/impl/sshj/SshjSshConnection\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n*L\n1#1,264:1\n254#1,6:265\n254#1,6:271\n254#1,6:277\n174#2,18:283\n*S KotlinDebug\n*F\n+ 1 SshjSshConnection.kt\ncom/intellij/ssh/impl/sshj/SshjSshConnection\n*L\n68#1:265,6\n115#1:271,6\n126#1:277,6\n202#1:283,18\n*E\n"})
public final class SshjSshConnection
implements SshSessionChannelFactory {
    @NotNull
    private final SshConnectionConfig connectionConfig;
    @NotNull
    private final SSHClient sshjBackend;
    @NotNull
    private final String userName;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final LocalForwarderCollection localForwarders;
    @NotNull
    private final RemoteForwarderCollection remoteForwarders;

    public SshjSshConnection(@NotNull SshConnectionConfig connectionConfig, @NotNull SSHClient sshjBackend, @NotNull String userName, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)connectionConfig, (String)"connectionConfig");
        Intrinsics.checkNotNullParameter((Object)sshjBackend, (String)"sshjBackend");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.connectionConfig = connectionConfig;
        this.sshjBackend = sshjBackend;
        this.userName = userName;
        this.executor = executor;
        this.localForwarders = new LocalForwarderCollection(this.sshjBackend, this.toString());
        this.remoteForwarders = new RemoteForwarderCollection(this.sshjBackend, this.toString());
    }

    @NotNull
    public final SSHClient getSshjBackend$intellij_platform_ssh() {
        return this.sshjBackend;
    }

    @Override
    @NotNull
    public String getUserName() {
        return this.userName;
    }

    @Override
    @NotNull
    public String getHost() {
        String string = this.sshjBackend.getRemoteHostname();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRemoteHostname(...)");
        return string;
    }

    @Override
    public int getPort() {
        return this.sshjBackend.getRemotePort();
    }

    @Override
    @NotNull
    public <C extends SshChannel> C openChannel(@NotNull Function1<? super SshSessionChannelFactory, ? extends C> channelCreator) {
        Intrinsics.checkNotNullParameter(channelCreator, (String)"channelCreator");
        try {
            return (C)((SshChannel)channelCreator.invoke((Object)this));
        }
        catch (SshException sshException) {
            throw sshException;
        }
        catch (IOException iOException) {
            throw new SshException(String.valueOf(iOException.getMessage()), iOException, new Attachment[0]);
        }
        catch (IllegalStateException illegalStateException) {
            throw Intrinsics.areEqual((Object)illegalStateException.getMessage(), (Object)"Not connected") ? (Throwable)((Object)new ChannelSshTransportException(illegalStateException)) : (Throwable)illegalStateException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(String.valueOf(exception.getMessage()), exception);
        }
    }

    @Override
    @NotNull
    public ExecChannel execChannel(@NotNull ExecChannelConfig channelConfig) {
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        PatchedExecChannel patchedExecChannel = new PatchedExecChannel(this.sshjBackend);
        SshjSshConnection sshjSshConnection = this;
        boolean bl = false;
        try {
            boolean bl2 = false;
            patchedExecChannel.open();
            Unit unit = Unit.INSTANCE;
        }
        catch (OpenFailException openFailException) {
            throw new ChannelSshTransportException(openFailException);
        }
        this.i((Session)patchedExecChannel);
        if (channelConfig.isPty()) {
            patchedExecChannel.allocateDefaultPTY();
        }
        patchedExecChannel.setRedirectingStderr$intellij_platform_ssh(channelConfig.getRedirectErrorStream());
        this.w((Session)patchedExecChannel);
        if (this.connectionConfig.getForwardAgent()) {
            patchedExecChannel.sendAgentForwardingRequest();
        }
        sshjSshConnection = patchedExecChannel.exec(channelConfig.getCommand());
        Intrinsics.checkNotNull((Object)sshjSshConnection);
        return new SshjExecChannel(this, (Session.Command)sshjSshConnection, channelConfig.isPty());
    }

    private final void i(Session session) {
        for (EnvironmentVariable.Certain certain : UtilKt.certainVariables(this.connectionConfig.getEnvironmentVariables())) {
            String string = certain.component1();
            String string2 = certain.component2();
            try {
                session.setEnvVar(string, string2);
            }
            catch (ConnectionException connectionException) {
                UtilKt.getSSHJ_LOG().warn("Failed to send environment variable " + string, (Throwable)connectionException);
            }
        }
    }

    private final void w(Session session) {
        block4: {
            X11Forwarding x11Forwarding = this.connectionConfig.getX11Forwarding();
            if (x11Forwarding == null) break block4;
            X11Forwarding x11Forwarding2 = x11Forwarding;
            boolean bl = false;
            try {
                Unit unit;
                String string = x11Forwarding2.makeMitMagicCookie();
                if (string != null) {
                    String string2 = string;
                    boolean bl2 = false;
                    session.reqX11Forwarding("MIT-MAGIC-COOKIE-1", string2, x11Forwarding2.getScreen());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable) {
                UtilKt.getSSHJ_LOG().warn("Failed to set up " + x11Forwarding2 + " in " + this, throwable);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Override
    @NotNull
    public SftpChannel sftpChannel(@NotNull SftpChannelConfig channelConfig) {
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        PatchedSftpChannel patchedSftpChannel = new PatchedSftpChannel(this, channelConfig);
        SshjSshConnection sshjSshConnection = this;
        boolean bl = false;
        try {
            boolean bl2 = false;
            patchedSftpChannel.open();
            Unit unit = Unit.INSTANCE;
        }
        catch (OpenFailException openFailException) {
            throw new ChannelSshTransportException(openFailException);
        }
        sshjSshConnection = new SFTPEngine(new SessionFactory(this, patchedSftpChannel){
            final /* synthetic */ SshjSshConnection this$0;
            final /* synthetic */ PatchedSftpChannel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
            }

            public InetSocketAddress getRemoteSocketAddress() {
                InetSocketAddress inetSocketAddress = this.this$0.getSshjBackend$intellij_platform_ssh().getRemoteSocketAddress();
                Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"getRemoteSocketAddress(...)");
                return inetSocketAddress;
            }

            public Session startSession() {
                return (Session)this.$channel;
            }
        });
        SFTPClient sFTPClient = new SFTPClient(sshjSshConnection.init());
        return new SshjSftpChannel(this, (Channel)patchedSftpChannel, sFTPClient);
    }

    @Override
    @NotNull
    public ShellChannel shellChannel(@NotNull ShellChannelConfig channelConfig) {
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        PatchedShellChannel patchedShellChannel = new PatchedShellChannel(this.sshjBackend);
        SshjSshConnection sshjSshConnection = this;
        boolean bl = false;
        try {
            boolean bl2 = false;
            patchedShellChannel.open();
            Unit unit = Unit.INSTANCE;
        }
        catch (OpenFailException openFailException) {
            throw new ChannelSshTransportException(openFailException);
        }
        this.i((Session)patchedShellChannel);
        if (channelConfig.isPty()) {
            patchedShellChannel.allocatePTY("xterm-256color", 80, 24, 0, 0, MapsKt.emptyMap());
        }
        try {
            patchedShellChannel.setEnvVar("LANG", "en_US.UTF-8");
        }
        catch (ConnectionException connectionException) {
            UtilKt.getSSHJ_LOG().warn("Failed to set remote env variable LANG for " + this + ": " + connectionException);
        }
        this.w((Session)patchedShellChannel);
        if (this.connectionConfig.getForwardAgent()) {
            patchedShellChannel.sendAgentForwardingRequest();
        }
        return new SshjShellChannel(this, (Session)patchedShellChannel);
    }

    @Override
    public boolean isConnected() {
        return this.sshjBackend.isConnected();
    }

    @Override
    public void addRemoteTunnel(int remotePort, @NotNull String host, int localPort) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.remoteForwarders.create("localhost", localPort, host, remotePort);
    }

    @Override
    public int addRemoteTunnelWithRandomRemotePort(@NotNull String host, int localPort) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this.remoteForwarders.createWithRandomRemotePort("", localPort, host);
    }

    @Override
    public void addLocalTunnel(int localPort, @NotNull String host, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.localForwarders.create("localhost", localPort, host, remotePort);
    }

    @Override
    public int addLocalTunnelWithRandomLocalPort(@NotNull String host, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this.localForwarders.createForFreePort("localhost", host, remotePort);
    }

    @Override
    public void removeLocalTunnel(int port) {
        this.localForwarders.remove("localhost", port);
    }

    @Override
    public void addLocalTunnel(@NotNull InetAddress localAddress, int localPort, @NotNull String host, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.localForwarders.create(localAddress, localPort, host, remotePort);
    }

    @Override
    public int addLocalTunnelWithRandomLocalPort(@NotNull InetAddress localAddress, @NotNull String host, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this.localForwarders.createForFreePort(localAddress, host, remotePort);
    }

    @Override
    public void removeLocalTunnel(@NotNull InetAddress localAddress, int port) {
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        this.localForwarders.remove(localAddress, port);
    }

    @Override
    public void removeRemoteTunnel(int port) {
        this.remoteForwarders.remove("localhost", port);
    }

    @Override
    @NotNull
    public List<String> getPortForwardingList() {
        List<String> list = this.localForwarders.get();
        list.addAll((Collection<String>)this.remoteForwarders.get());
        return CollectionsKt.sorted((Iterable)list);
    }

    @Override
    public void disconnect() {
        UtilKt.getSSHJ_LOG().debug("Disconnecting " + this);
        KeepAlive keepAlive = this.sshjBackend.getConnection().getKeepAlive();
        try {
            Object object = new Function0[5];
            object[0] = new Function0<Unit>((Object)this.executor){

                public final void invoke() {
                    ((ExecutorService)this.receiver).shutdown();
                }
            };
            Intrinsics.checkNotNull((Object)keepAlive);
            object[1] = new Function0<Unit>((Object)keepAlive){

                public final void invoke() {
                    ((KeepAlive)this.receiver).interrupt();
                }
            };
            object[2] = new Function0<Unit>((Object)this.localForwarders){

                public final void invoke() {
                    ((LocalForwarderCollection)this.receiver).close();
                }
            };
            object[3] = new Function0<Unit>((Object)this.sshjBackend){

                public final void invoke() {
                    ((SSHClient)this.receiver).close();
                }
            };
            object[4] = () -> SshjSshConnection.i(keepAlive);
            object = CollectionsKt.listOf((Object[])object);
            boolean bl = false;
            Iterator iterator = object.iterator();
            boolean bl2 = false;
            List list = null;
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                try {
                    Function0 function0 = (Function0)e;
                    boolean bl3 = false;
                    function0.invoke();
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = (List)new SmartList();
                    }
                    list.add(throwable);
                }
            }
            CompoundRuntimeException.throwIfNotEmpty(list);
        }
        catch (Throwable throwable) {
            UtilKt.getSSHJ_LOG().info("Got an error while disconnecting " + this + ": " + throwable);
        }
    }

    @Override
    public void applyPortForwardings() {
        for (OpenSshConfigForwardInfo openSshConfigForwardInfo : this.connectionConfig.getInitialLocalTcpForwardings()) {
            try {
                this.localForwarders.create(openSshConfigForwardInfo.getBindHost(), openSshConfigForwardInfo.getBindPort(), openSshConfigForwardInfo.getHost(), openSshConfigForwardInfo.getPort());
            }
            catch (SshTunnelAlreadyRegisteredException sshTunnelAlreadyRegisteredException) {
            }
            catch (Exception exception) {
                UtilKt.getSSHJ_LOG().error("Can't apply local forwarding from config: " + openSshConfigForwardInfo, (Throwable)exception);
            }
        }
        for (OpenSshConfigForwardInfo openSshConfigForwardInfo : this.connectionConfig.getInitialRemoteTcpForwardings()) {
            try {
                this.remoteForwarders.create(openSshConfigForwardInfo.getBindHost(), openSshConfigForwardInfo.getBindPort(), openSshConfigForwardInfo.getHost(), openSshConfigForwardInfo.getPort());
            }
            catch (SshTunnelAlreadyRegisteredException sshTunnelAlreadyRegisteredException) {
            }
            catch (Exception exception) {
                UtilKt.getSSHJ_LOG().error("Can't apply remote forwarding from config: " + openSshConfigForwardInfo, (Throwable)exception);
            }
        }
    }

    @Nullable
    public final HostAndPort getLocalTunnel$intellij_platform_ssh(int remotePort) {
        return this.localForwarders.getLocalAddressForRemotePort(remotePort);
    }

    @NotNull
    public String toString() {
        return "SshjSshConnection(" + this.getUserName() + "@" + this.getHost() + ")@" + UtilKt.hexId(this);
    }

    private final <T> T i(Function0<? extends T> function0) {
        Object object;
        boolean bl = false;
        try {
            object = function0.invoke();
        }
        catch (OpenFailException openFailException) {
            throw new ChannelSshTransportException(openFailException);
        }
        return (T)object;
    }

    private static final Unit i(KeepAlive keepAlive) {
        keepAlive.join(1000L);
        return Unit.INSTANCE;
    }
}

