/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.PrependingInputStream;
import com.intellij.ssh.RunViaSudoInfo;
import com.intellij.ssh.SudoCliInteractionKt;
import com.intellij.ssh.SudoPromptFiniteStateMachineResult;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001+B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u001a\u001a\u00020\u001bJE\u0010\u001c\u001a\u00020\u001d26\u0010\u001e\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140!0 0\u001f\"\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140!0 H\u0002\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0019H\u0002J\b\u0010'\u001a\u00020\u001dH\u0002J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/ssh/SudoPromptFiniteStateMachine;", "", "outputStream", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "hasPty", "", "runViaSudoInfo", "Lcom/intellij/ssh/RunViaSudoInfo;", "passwordProvider", "Lcom/intellij/ssh/PasswordStringProvider;", "SudoPromptFiniteStateMachine", "(Ljava/io/OutputStream;Ljava/io/InputStream;ZLcom/intellij/ssh/RunViaSudoInfo;Lcom/intellij/ssh/PasswordStringProvider;)V", "getOutputStream", "()Ljava/io/OutputStream;", "sudoPromptBytes", "", "successBoundaryBytes", "state", "Lcom/intellij/ssh/SudoPromptFiniteStateMachine$State;", "prependingInputStream", "Lcom/intellij/ssh/PrependingInputStream;", "readBuffer", "readBufferSize", "", "doWork", "Lcom/intellij/ssh/SudoPromptFiniteStateMachineResult;", "i", "", "cases", "", "Lkotlin/Pair;", "Lkotlin/Function0;", "([Lkotlin/Pair;)V", "i", "array1", "array2", "maxBytes", "i", "i", "b", "", "State", "intellij.platform.ssh"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nSudoCliInteraction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SudoCliInteraction.kt\ncom/intellij/ssh/SudoPromptFiniteStateMachine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,299:1\n1#2:300\n*E\n"})
public final class SudoPromptFiniteStateMachine {
    @NotNull
    private final OutputStream outputStream;
    private final boolean hasPty;
    @NotNull
    private final PasswordStringProvider passwordProvider;
    @NotNull
    private final byte[] sudoPromptBytes;
    @NotNull
    private final byte[] successBoundaryBytes;
    @NotNull
    private State state;
    @NotNull
    private final PrependingInputStream prependingInputStream;
    @NotNull
    private final byte[] readBuffer;
    private int readBufferSize;

    public SudoPromptFiniteStateMachine(@NotNull OutputStream outputStream2, @NotNull InputStream inputStream2, boolean hasPty, @NotNull RunViaSudoInfo runViaSudoInfo, @NotNull PasswordStringProvider passwordProvider) {
        Intrinsics.checkNotNullParameter((Object)outputStream2, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)inputStream2, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)runViaSudoInfo, (String)"runViaSudoInfo");
        Intrinsics.checkNotNullParameter((Object)passwordProvider, (String)"passwordProvider");
        this.outputStream = outputStream2;
        this.hasPty = hasPty;
        this.passwordProvider = passwordProvider;
        byte[] byArray = runViaSudoInfo.getSudoPrompt().getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.sudoPromptBytes = byArray;
        byte[] byArray2 = runViaSudoInfo.getSuccessBoundary().getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        this.successBoundaryBytes = byArray2;
        this.state = State.MaybeAskPassword;
        this.prependingInputStream = new PrependingInputStream(inputStream2);
        this.readBuffer = new byte[Math.max(this.sudoPromptBytes.length, Math.max(this.successBoundaryBytes.length, SudoCliInteractionKt.access$getTRY_AGAIN$p().length))];
    }

    @NotNull
    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    @NotNull
    public final SudoPromptFiniteStateMachineResult doWork() {
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        block5: while (this.state != State.Success && this.state != State.Terminated) {
            int n;
            int n2 = n = this.readBufferSize < this.readBuffer.length ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl = false;
                String string = this.readBufferSize + " < " + this.readBuffer.length;
                throw new AssertionError((Object)string);
            }
            n = this.prependingInputStream.read(this.readBuffer, this.readBufferSize, Math.min(Math.max(1, this.prependingInputStream.available()), this.readBuffer.length - this.readBufferSize));
            if (n < 0) {
                this.state = State.Terminated;
                continue;
            }
            this.readBufferSize += n;
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.sudoPromptBytes, () -> SudoPromptFiniteStateMachine.w(this, booleanRef)), TuplesKt.to((Object)this.successBoundaryBytes, () -> SudoPromptFiniteStateMachine.i(this))};
                    this.i(pairArray);
                    continue block5;
                }
                case 2: {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SudoCliInteractionKt.access$getTRY_AGAIN$p(), () -> SudoPromptFiniteStateMachine.i(this, booleanRef)), TuplesKt.to((Object)this.successBoundaryBytes, () -> SudoPromptFiniteStateMachine.w(this))};
                    this.i(pairArray);
                    continue block5;
                }
                case 3: 
                case 4: {
                    throw new IllegalStateException("Bug. This line should not be executed.");
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        this.i();
        return new SudoPromptFiniteStateMachineResult(this.state == State.Success, this.prependingInputStream);
    }

    private final void i(Pair<byte[], ? extends Function0<? extends State>> ... pairArray) {
        boolean bl = false;
        for (Pair<byte[], ? extends Function0<? extends State>> pair : pairArray) {
            byte[] byArray = (byte[])pair.component1();
            Function0 function0 = (Function0)pair.component2();
            int n = this.i(this.readBuffer, byArray, this.readBufferSize);
            if (n == byArray.length) {
                this.readBufferSize -= byArray.length;
                System.arraycopy(this.readBuffer, byArray.length, this.readBuffer, 0, this.readBufferSize);
                this.i();
                this.state = (State)((Object)function0.invoke());
                return;
            }
            if (n != this.readBufferSize) continue;
            bl = true;
        }
        if (!bl) {
            this.state = State.Terminated;
        }
    }

    private final int i(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        int n3 = Math.min(n, Math.min(byArray.length, byArray2.length));
        for (n2 = 0; n2 < n3 && byArray[n2] == byArray2[n2]; ++n2) {
        }
        return n2;
    }

    private final void i() {
        while (true) {
            this.readBufferSize += -1;
            if (this.readBufferSize < 0) break;
            this.prependingInputStream.getPrefix().addFirst(this.readBuffer[this.readBufferSize]);
        }
        this.readBufferSize = 0;
    }

    private final void i(char c) {
        byte by = (byte)this.prependingInputStream.read();
        boolean bl = false;
        if (!(by == (byte)c)) {
            boolean bl2 = false;
            String string = "Expected byte " + c + ", got byte " + by + " ";
            throw new IllegalStateException(string.toString());
        }
    }

    private static final State w(SudoPromptFiniteStateMachine sudoPromptFiniteStateMachine, Ref.BooleanRef booleanRef) {
        State state;
        String string = sudoPromptFiniteStateMachine.passwordProvider.provide(booleanRef.element);
        if (string != null) {
            OutputStream outputStream2 = sudoPromptFiniteStateMachine.outputStream;
            String string2 = string + "\n";
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            outputStream2.write(byArray);
            sudoPromptFiniteStateMachine.outputStream.flush();
            if (sudoPromptFiniteStateMachine.hasPty) {
                sudoPromptFiniteStateMachine.i('\r');
                sudoPromptFiniteStateMachine.i('\n');
            }
            state = State.MaybeTryAgain;
        } else {
            state = State.Terminated;
        }
        return state;
    }

    private static final State i(SudoPromptFiniteStateMachine sudoPromptFiniteStateMachine) {
        if (sudoPromptFiniteStateMachine.hasPty) {
            sudoPromptFiniteStateMachine.i('\r');
        }
        sudoPromptFiniteStateMachine.i('\n');
        return State.Success;
    }

    private static final State i(SudoPromptFiniteStateMachine sudoPromptFiniteStateMachine, Ref.BooleanRef booleanRef) {
        sudoPromptFiniteStateMachine.passwordProvider.previousPasswordWasWrong();
        if (sudoPromptFiniteStateMachine.hasPty) {
            sudoPromptFiniteStateMachine.i('\r');
        }
        sudoPromptFiniteStateMachine.i('\n');
        booleanRef.element = true;
        return State.MaybeAskPassword;
    }

    private static final State w(SudoPromptFiniteStateMachine sudoPromptFiniteStateMachine) {
        if (sudoPromptFiniteStateMachine.hasPty) {
            sudoPromptFiniteStateMachine.i('\r');
        }
        sudoPromptFiniteStateMachine.i('\n');
        return State.Success;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ssh/SudoPromptFiniteStateMachine$State;", "", "SudoPromptFiniteStateMachine$State", "(Ljava/lang/String;I)V", "MaybeAskPassword", "MaybeTryAgain", "Success", "Terminated", "intellij.platform.ssh"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State MaybeAskPassword = new State();
        public static final /* enum */ State MaybeTryAgain = new State();
        public static final /* enum */ State Success = new State();
        public static final /* enum */ State Terminated = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.MaybeAskPassword, State.MaybeTryAgain, State.Success, State.Terminated};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.MaybeAskPassword.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MaybeTryAgain.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Success.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Terminated.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

