/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.cli;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class VagrantOutputParser {
    @VisibleForTesting
    public static boolean isVagrantRunning(List<String> vagrantOutputLines, @Nullable String machineName) {
        boolean currentMachineStates = false;
        boolean allAreRunning = true;
        boolean emptyLine = false;
        for (String line : vagrantOutputLines) {
            if (line.contains("Current machine states:")) {
                currentMachineStates = true;
                emptyLine = false;
                continue;
            }
            if (currentMachineStates && StringUtil.isEmpty((String)line)) {
                if (emptyLine) break;
                emptyLine = true;
                continue;
            }
            if (!currentMachineStates) continue;
            String[] tokens = line.split("\\s+");
            if ((machineName != null && machineName.equals(tokens[0]) || machineName == null && "default".equals(tokens[0])) && "running".equals(tokens[1])) {
                return true;
            }
            if (tokens.length <= 1 || "running".equals(tokens[1])) continue;
            allAreRunning = false;
        }
        return allAreRunning;
    }
}

