/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpstan;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpTextFieldWithSdkBasedBrowse;
import com.jetbrains.php.tools.quality.QualityToolConfigurationComboBox;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolsOptionsPanel;
import com.jetbrains.php.tools.quality.phpstan.PhpStanBundle;
import com.jetbrains.php.tools.quality.phpstan.PhpStanOptionsConfiguration;
import com.jetbrains.php.tools.quality.phpstan.PhpStanQualityToolType;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStanOptionsPanel
extends QualityToolsOptionsPanel {
    private JPanel myOptionsPanel;
    private JBCheckBox myFullProjectRunJBCheckBox;
    private JBTextField myMemoryLimitTextField;
    private JBIntSpinner myJBIntSpinner;
    private PhpTextFieldWithSdkBasedBrowse myConfigPathTextField;
    private PhpTextFieldWithSdkBasedBrowse myAutoloadPathTextField;
    private final QualityToolConfigurationComboBox myComboBox;

    public PhpStanOptionsPanel(Project project, QualityToolConfigurationComboBox comboBox, final Runnable validate) {
        super(project, validate, (QualityToolType)PhpStanQualityToolType.INSTANCE);
        this.myComboBox = comboBox;
        this.$$$setupUI$$$();
        PhpStanOptionsConfiguration configuration = PhpStanOptionsConfiguration.getInstance(project);
        this.myFullProjectRunJBCheckBox.setSelected(configuration.isFullProject());
        this.myMemoryLimitTextField.setText(configuration.getMemoryLimit());
        this.myJBIntSpinner.setNumber(configuration.getLevel());
        this.myConfigPathTextField.setText(configuration.getConfig());
        this.myConfigPathTextField.init(project, this.getSdkAdditionalData(project, comboBox), PhpStanBundle.message("phpstan.configuration.file", new Object[0]), true, false);
        this.myAutoloadPathTextField.setText(configuration.getAutoload());
        this.myAutoloadPathTextField.init(project, this.getSdkAdditionalData(project, comboBox), PhpStanBundle.message("phpstan.autoload.file", new Object[0]), true, false);
        this.myConfigPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                validate.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/phpstan/PhpStanOptionsPanel$1", "textChanged"));
            }
        });
    }

    private void createUIComponents() {
        this.myJBIntSpinner = new JBIntSpinner(4, 0, 8);
    }

    public JPanel getOptionsPanel() {
        return this.myOptionsPanel;
    }

    public void reset() {
        PhpStanOptionsConfiguration configuration = PhpStanOptionsConfiguration.getInstance(this.myProject);
        this.myFullProjectRunJBCheckBox.setSelected(configuration.isFullProject());
        this.myMemoryLimitTextField.setText(configuration.getMemoryLimit());
        this.myJBIntSpinner.setNumber(configuration.getLevel());
        this.myConfigPathTextField.setText(configuration.getConfig());
        this.myAutoloadPathTextField.setText(configuration.getAutoload());
    }

    public boolean isModified() {
        PhpStanOptionsConfiguration configuration = PhpStanOptionsConfiguration.getInstance(this.myProject);
        if (this.myFullProjectRunJBCheckBox.isSelected() != configuration.isFullProject()) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)this.myMemoryLimitTextField.getText(), (CharSequence)configuration.getMemoryLimit())) {
            return true;
        }
        if (this.myJBIntSpinner.getNumber() != configuration.getLevel()) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)this.myConfigPathTextField.getText(), (CharSequence)configuration.getConfig())) {
            return true;
        }
        return !StringUtil.equals((CharSequence)this.myAutoloadPathTextField.getText(), (CharSequence)configuration.getAutoload());
    }

    public void apply() {
        PhpStanOptionsConfiguration configuration = PhpStanOptionsConfiguration.getInstance(this.myProject);
        configuration.setFullProject(this.myFullProjectRunJBCheckBox.isSelected());
        configuration.setMemoryLimit(this.myMemoryLimitTextField.getText());
        configuration.setLevel(this.myJBIntSpinner.getNumber());
        configuration.setConfig(this.myConfigPathTextField.getText());
        configuration.setAutoload(this.myAutoloadPathTextField.getText());
    }

    @Nullable
    protected String validatePath() {
        PhpInterpreter interpreter = this.getSelectedInterpreter(this.myProject, this.myComboBox);
        if (interpreter != null && interpreter.isRemote()) {
            return null;
        }
        URL url = VfsUtilCore.convertToURL((String)VfsUtilCore.pathToUrl((String)this.myConfigPathTextField.getText()));
        if (url == null || VfsUtil.findFileByURL((URL)url) == null) {
            return PhpStanBundle.message("config.file.doesnt.exist", new Object[0]);
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        PhpTextFieldWithSdkBasedBrowse phpTextFieldWithSdkBasedBrowse;
        PhpTextFieldWithSdkBasedBrowse phpTextFieldWithSdkBasedBrowse2;
        JBTextField jBTextField;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(5, 5, 0, 0), -1, -1, false, false));
        jPanel2.setAlignmentY(0.5f);
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFullProjectRunJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpStanBundle", PhpStanOptionsPanel.class).getString("phpstan.checkbox.full.project.run"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 4, 9, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 1, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpStanBundle", PhpStanOptionsPanel.class).getString("phpstan.label.options"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myMemoryLimitTextField = jBTextField = new JBTextField();
        jPanel3.add((Component)jBTextField, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpStanBundle", PhpStanOptionsPanel.class).getString("label.level"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBIntSpinner jBIntSpinner = this.myJBIntSpinner;
        jPanel4.add((Component)jBIntSpinner, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpStanBundle", PhpStanOptionsPanel.class).getString("label.configuration.file"));
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfigPathTextField = phpTextFieldWithSdkBasedBrowse2 = new PhpTextFieldWithSdkBasedBrowse();
        jPanel5.add((Component)phpTextFieldWithSdkBasedBrowse2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpStanBundle", PhpStanOptionsPanel.class).getString("label.autoload.file"));
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoloadPathTextField = phpTextFieldWithSdkBasedBrowse = new PhpTextFieldWithSdkBasedBrowse();
        jPanel6.add((Component)phpTextFieldWithSdkBasedBrowse, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myOptionsPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

