/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.tools.quality;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.run.deploymentAware.PhpRemoteToolCreateDialog;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolByInterpreterDialog<P extends QualityToolConfiguration, S extends P>
extends PhpRemoteToolCreateDialog<P, S, PhpInterpreterComboBox> {
    private final String myToolName;
    private final QualityToolType<P> myQualityToolType;

    public QualityToolByInterpreterDialog(@Nullable Project project, @NotNull List<P> settings, @NotNull String toolName, @NotNull Class<S> type, @NotNull QualityToolType<P> qualityToolType) {
        if (settings == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(0);
        }
        if (toolName == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(1);
        }
        if (type == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(2);
        }
        if (qualityToolType == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(3);
        }
        super(project, settings, type);
        this.myToolName = toolName;
        this.myQualityToolType = qualityToolType;
        this.setTitle(PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.new.settings.dialog.title", this.myToolName));
        this.init();
    }

    protected void initComboBox() {
        this.myComboBox = new PhpInterpreterComboBox(this.myProject, data -> true);
        ArrayList items = new ArrayList(ContainerUtil.concat((List)((PhpInterpreterComboBox)this.myComboBox).getItems(), this.getDummyInterpreters()));
        ((PhpInterpreterComboBox)this.myComboBox).setModel(items, null);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myComboBox);
    }

    private List<PhpInterpreter> getDummyInterpreters() {
        QualityToolConfiguration local;
        ArrayList<PhpInterpreter> interpreters = new ArrayList<PhpInterpreter>();
        QualityToolConfigurationManager projectManager = this.myQualityToolType.getConfigurationManager(this.myProject);
        QualityToolConfiguration defaultInterpreterConfiguration = projectManager.getOrCreateByDefaultInterpreterConfiguration();
        if (defaultInterpreterConfiguration != null && !ContainerUtil.exists((Iterable)this.mySettings, it -> it.isCreatedAsDefaultInterpreterConfiguration())) {
            interpreters.add(new MyDummyPhpInterpreter(defaultInterpreterConfiguration));
        }
        if ((local = projectManager.getLocalSettings()) != null && !ContainerUtil.exists((Iterable)this.mySettings, it -> it.isLocal())) {
            interpreters.add(new MyDummyPhpInterpreter(local));
        }
        return interpreters;
    }

    public static QualityToolConfiguration getLocalOrDefaultInterpreterConfiguration(String name, Project project, QualityToolType<?> qualityToolType) {
        QualityToolConfigurationManager projectManager = qualityToolType.getConfigurationManager(project);
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        if (PhpBundle.message((String)"label.system.php", (Object[])new Object[0]).equals(name)) {
            return projectManager.getLocalSettings();
        }
        if (PhpBundle.message((String)"quality.tools.label.by.default.project.interpreter", (Object[])new Object[0]).equals(name)) {
            return projectManager.getOrCreateByDefaultInterpreterConfiguration();
        }
        return null;
    }

    @NlsContexts.Label
    protected String getLabelText() {
        return PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.dialog.label", new Object[0]);
    }

    @Nullable
    public String getSelectedInterpreterName() {
        return ((PhpInterpreterComboBox)this.myComboBox).getSelectedItemName();
    }

    @Nullable
    protected String getInterpreterId(@NotNull S configuration) {
        if (configuration == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(4);
        }
        return configuration.getInterpreterId();
    }

    protected boolean canProcessSetting(@NotNull P settings, Class<S> type) {
        if (settings == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(5);
        }
        return type.isInstance(settings);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)this.myProject);
        String selectedInterpreterId = manager.findInterpreterId(((PhpInterpreterComboBox)this.myComboBox).getSelectedItemName());
        for (QualityToolConfiguration configuration : this.mySettings) {
            if (!StringUtil.equals((CharSequence)selectedInterpreterId, (CharSequence)this.getInterpreterId(configuration))) continue;
            String message = PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.settings.already.exist", this.myToolName);
            return new ValidationInfo(message, (JComponent)this.myComboBox);
        }
        return super.doValidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualityToolType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/tools/quality/QualityToolByInterpreterDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getInterpreterId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessSetting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyDummyPhpInterpreter
    extends PhpInterpreter {
        MyDummyPhpInterpreter(QualityToolConfiguration configuration) {
            String name = configuration.isLocal() ? PhpBundle.message((String)"label.system.php", (Object[])new Object[0]) : PhpBundle.message((String)"quality.tools.label.by.default.project.interpreter", (Object[])new Object[0]);
            this.setName(name);
            this.setId(configuration.getInterpreterId());
        }
    }
}

