/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.phpunit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.testFramework.PhpTestFrameworkBySdkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationIml;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="phpunit_by_interpreter")
public class PhpUnitByInterpreterSettings
extends PhpUnitSettings
implements PhpSdkDependentConfiguration {
    @NlsSafe
    private String myInterpreterId;
    private String myInterpreterName;

    @Attribute(value="interpreter_id")
    @Nullable
    public String getInterpreterId() {
        return this.myInterpreterId;
    }

    public void setInterpreterId(@NotNull String interpreterId) {
        if (interpreterId == null) {
            PhpUnitByInterpreterSettings.$$$reportNull$$$0(0);
        }
        this.myInterpreterId = interpreterId;
    }

    @Attribute(value="interpreter_name")
    @Nullable
    public String getInterpreterName() {
        return this.myInterpreterName;
    }

    public void setInterpreterName(String interpreterName) {
        this.myInterpreterName = interpreterName;
    }

    @NlsSafe
    @Nullable
    public String getInterpreterName(@Nullable Project project) {
        return PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterName(this.getInterpreterId(project));
    }

    public String getInterpreterId(@Nullable Project project) {
        if (StringUtil.isEmpty((String)this.myInterpreterId)) {
            this.myInterpreterId = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterId(this.myInterpreterName);
        }
        return this.myInterpreterId;
    }

    @NotNull
    @Nls
    public String getPresentableName(@Nullable Project project) {
        if (Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            String localExecutablePath = PhpTestFrameworkBySdkConfiguration.getLocalExecutablePath((String)this.getImmediateExecutablePath(), (String)this.getInterpreterId(project), (Project)project);
            String string = PhpTestFrameworkConfigurationIml.getBaseDirRelativePath((Project)project, (String)localExecutablePath);
            if (string == null) {
                PhpUnitByInterpreterSettings.$$$reportNull$$$0(1);
            }
            return string;
        }
        String name = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterName(this.getInterpreterId(project));
        String string = name == null ? PhpRemoteSdkBundle.message("label.undefined.interpreter", new Object[0]) : PhpBundle.message((String)"label.interpreter", (Object[])new Object[]{name});
        if (string == null) {
            PhpUnitByInterpreterSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDescription(@Nullable Project project) {
        String string = PhpTestFrameworkBySdkConfiguration.getTestFrameworkDescription((Project)project, (String)this.getInterpreterId(project));
        if (string == null) {
            PhpUnitByInterpreterSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Transient
    public boolean isProjectLevel() {
        return PhpInterpretersManagerImpl.getInstance(null).findInterpreterById(this.getInterpreterId(null)) == null;
    }

    @NotNull
    @Nls
    public String getId(@Nullable Project project) {
        String string = PhpRemoteSdkBundle.message("interpreter", new Object[0]) + "-" + this.myInterpreterId;
        if (string == null) {
            PhpUnitByInterpreterSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isLocal() {
        return false;
    }

    @Nullable
    public PhpUnitSettings copyWithSettingsSource(@Nullable Project project) {
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)project);
        PhpInterpreter interpreter = manager.findInterpreterById(this.getInterpreterId(project));
        if (interpreter == null) {
            return null;
        }
        PhpInterpreter projectLevel = interpreter.clone();
        projectLevel.setId(PhpInterpreter.getNextId());
        projectLevel.setIsProjectLevel(true);
        projectLevel.setName(manager.getUniqueName(interpreter.getName() + " (project level)"));
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance((Project)project).getPhpInfo(interpreter.getName());
        if (info != null) {
            PhpInterpretersPhpInfoCacheImpl.getInstance((Project)project).setPhpInfo(projectLevel.getName(), info);
        }
        manager.addInterpreter(projectLevel);
        PhpUnitByInterpreterSettings phpunitCopy = this.copy();
        phpunitCopy.setInterpreterId(projectLevel.getId());
        return phpunitCopy;
    }

    @NotNull
    public PhpUnitByInterpreterSettings copy() {
        PhpUnitByInterpreterSettings settings = new PhpUnitByInterpreterSettings();
        settings.myInterpreterName = this.myInterpreterName;
        settings.myInterpreterId = this.myInterpreterId;
        this.copyTo(settings);
        PhpUnitByInterpreterSettings phpUnitByInterpreterSettings = settings;
        if (phpUnitByInterpreterSettings == null) {
            PhpUnitByInterpreterSettings.$$$reportNull$$$0(5);
        }
        return phpUnitByInterpreterSettings;
    }

    protected String serialize(@Nullable String path) {
        return path;
    }

    protected String deserialize(@Nullable String path) {
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/phpunit/PhpUnitByInterpreterSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/phpunit/PhpUnitByInterpreterSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

