/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.phpunit;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.config.PhpInterpreterBasedConfig;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpRemoteInterpreterConfigurationForm;
import com.jetbrains.php.remote.phpunit.PhpUnitByInterpreterSettings;
import com.jetbrains.php.run.deploymentAware.phpunit.PhpUnitContextConfigurationForm;
import com.jetbrains.php.run.deploymentAware.phpunit.PhpUnitRemoteConfigurableForm;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBaseConfigurableForm;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBySdkConfig;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PhpUnitByInterpreterConfigurableForm
extends PhpUnitRemoteConfigurableForm<PhpUnitByInterpreterSettings, PhpRemoteInterpreterContextForm<PhpUnitByInterpreterSettings>> {
    private static final Logger LOG = Logger.getInstance(PhpUnitByInterpreterConfigurableForm.class);
    @Nullable
    private final PhpSdkAdditionalData myRemoteSdkAdditionalData;

    PhpUnitByInterpreterConfigurableForm(@NotNull Project project, @NotNull PhpUnitByInterpreterSettings settings) {
        if (project == null) {
            PhpUnitByInterpreterConfigurableForm.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PhpUnitByInterpreterConfigurableForm.$$$reportNull$$$0(1);
        }
        super(project, (PhpUnitSettings)settings);
        String interpreterId = settings.getInterpreterId(project);
        this.myRemoteSdkAdditionalData = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterDataById(interpreterId);
    }

    protected void addBrowseFolderListener(@NotNull Project project, final @NotNull TextFieldWithBrowseButton textField, final @NotNull List<PhpTestFrameworkBaseConfigurableForm.PhpFilePathUpdateListener> listeners) {
        if (project == null) {
            PhpUnitByInterpreterConfigurableForm.$$$reportNull$$$0(2);
        }
        if (textField == null) {
            PhpUnitByInterpreterConfigurableForm.$$$reportNull$$$0(3);
        }
        if (listeners == null) {
            PhpUnitByInterpreterConfigurableForm.$$$reportNull$$$0(4);
        }
        if (!(this.myRemoteSdkAdditionalData instanceof PhpRemoteSdkAdditionalData)) {
            LOG.warn(PhpRemoteSdkBundle.message("phpunit.by.interpreter.failed.to.browse", ((PhpUnitByInterpreterSettings)this.mySettings).getInterpreterName(project)));
            return;
        }
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        assert (manager != null) : PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage();
        String title = PhpRemoteSdkBundle.message("phpunit.by.interpreter.settings.remote.path.title", new Object[0]);
        try {
            final ActionListener action = manager.createRemoteBrowserAction(project, this.myRemoteSdkAdditionalData, title, textField.getTextField(), false);
            textField.getButton().setEnabled(true);
            textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String text = textField.getText();
                    action.actionPerformed(event);
                    String newPath = textField.getText();
                    if (!StringUtil.equals((CharSequence)text, (CharSequence)newPath)) {
                        for (PhpTestFrameworkBaseConfigurableForm.PhpFilePathUpdateListener listener : listeners) {
                            listener.onFileChosen(newPath);
                        }
                    }
                }
            });
        }
        catch (PhpInvalidSdkTypeException e) {
            textField.getButton().setVisible(false);
        }
    }

    @NotNull
    protected PhpRemoteInterpreterContextForm<PhpUnitByInterpreterSettings> createContextForm(@NotNull Project project, @NotNull PhpUnitByInterpreterSettings config, @NotNull JPanel parent) {
        if (project == null) {
            PhpUnitByInterpreterConfigurableForm.$$$reportNull$$$0(5);
        }
        if (config == null) {
            PhpUnitByInterpreterConfigurableForm.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            PhpUnitByInterpreterConfigurableForm.$$$reportNull$$$0(7);
        }
        return new PhpRemoteInterpreterContextForm<PhpUnitByInterpreterSettings>(this.myProject, config);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/phpunit/PhpUnitByInterpreterConfigurableForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addBrowseFolderListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createContextForm";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpRemoteInterpreterContextForm<S extends PhpSdkDependentConfiguration>
    extends PhpRemoteInterpreterConfigurationForm
    implements PhpUnitContextConfigurationForm {
        public PhpRemoteInterpreterContextForm(@NotNull Project project, @NotNull S config) {
            if (project == null) {
                PhpRemoteInterpreterContextForm.$$$reportNull$$$0(0);
            }
            if (config == null) {
                PhpRemoteInterpreterContextForm.$$$reportNull$$$0(1);
            }
            super(project, (PhpInterpreterBasedConfig)new PhpTestFrameworkBySdkConfig(project, config));
            this.setInterpreterEditable(false);
            String interpreterId = config.getInterpreterId();
            String interpreterName = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterName(interpreterId);
            this.myInterpreterComboBox.getComboBox().setEnabled(false);
            this.myInterpreterComboBox.reset(interpreterName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "config";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/remote/phpunit/PhpUnitByInterpreterConfigurableForm$PhpRemoteInterpreterContextForm";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

