/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.debug;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.debug.common.PhpDebugStrategy;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import com.jetbrains.php.util.pathmapper.PhpRemotePathMapper;
import com.jetbrains.plugins.remotesdk.SshCredentialsType;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteSshDebugStrategy
extends PhpDebugStrategy {
    private final Project myProject;
    private PhpPathMapper myMapper;
    private final PhpRemoteSdkAdditionalData mySshConnectionData;

    public PhpRemoteSshDebugStrategy(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data, @NotNull List<PathMappingSettings.PathMapping> mappings) {
        if (project == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(1);
        }
        if (mappings == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySshConnectionData = data;
        this.myMapper = PhpPathMapper.create(mappings);
    }

    @Nullable
    public PhpPathMapper getPathMapper() {
        return this.myMapper;
    }

    public void onCannotFindLocalPath(final @NotNull XCompositeNode node, final @NotNull String remoteFilePath, final Runnable reloader) {
        if (node == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(3);
        }
        if (remoteFilePath == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(4);
        }
        this.mySshConnectionData.switchOnConnectionType(CredentialsCase.create((CredentialsType)VagrantCredentialsType.getInstance(), credentials -> node.setErrorMessage(PhpRemoteSdkBundle.message("remote.interpreter.vagrant.cannot.find.path.mapping", remoteFilePath), null)), CredentialsCase.create((CredentialsType)WebDeploymentCredentialsType.getInstance(), credentials -> {
            String deployment = this.mySshConnectionData.getRemoteConnectionPresentableName();
            node.setErrorMessage(PhpRemoteSdkBundle.message("remote.interpreter.deployment.cannot.find.path.mapping", remoteFilePath, deployment) + "\n", (XDebuggerTreeNodeHyperlink)new PhpEditDeploymentMappingsHyperlink(this.myProject, this.mySshConnectionData, reloader));
        }), new CredentialsCase<RemoteCredentialsHolder>(){

            public CredentialsType<RemoteCredentialsHolder> getType() {
                return SshCredentialsType.getInstance();
            }

            public void process(RemoteCredentialsHolder credentials) {
                node.setErrorMessage(PhpRemoteSdkBundle.message("remote.interpreter.ssh.cannot.find.path.mapping", remoteFilePath) + "\n", (XDebuggerTreeNodeHyperlink)new PhpEditDeploymentMappingsHyperlink(PhpRemoteSshDebugStrategy.this.myProject, PhpRemoteSshDebugStrategy.this.mySshConnectionData, reloader));
            }
        });
    }

    public void onCannotFindLocalFile(@NotNull XCompositeNode node, @NotNull String remoteFilePath, @NotNull String localPath, Runnable reloader) {
        if (node == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(5);
        }
        if (remoteFilePath == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(6);
        }
        if (localPath == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(7);
        }
        node.setErrorMessage(PhpBundle.message((String)"debug.process.cannot.find.local.file", (Object[])new Object[]{remoteFilePath, localPath}) + "\n", null);
    }

    public void onScriptOutsideProject(@NotNull XCompositeNode node, @NotNull String remoteFilePath, @NotNull VirtualFile localFile, @NotNull Runnable reloader) {
        if (node == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(8);
        }
        if (remoteFilePath == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(9);
        }
        if (localFile == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(10);
        }
        if (reloader == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(11);
        }
        node.setMessage(PhpBundle.message((String)"debug.process.script.outside.project", (Object[])new Object[]{remoteFilePath}), UIUtil.getBalloonWarningIcon(), SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloader";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/debug/PhpRemoteSshDebugStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onCannotFindLocalPath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onCannotFindLocalFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "onScriptOutsideProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    class PhpEditDeploymentMappingsHyperlink
    extends XDebuggerTreeNodeHyperlink {
        private final Project myProject;
        private final PhpSdkAdditionalData mySdkAdditionalData;
        private final Runnable myReloader;

        PhpEditDeploymentMappingsHyperlink(@NotNull Project project, PhpSdkAdditionalData data, Runnable reloader) {
            if (project == null) {
                PhpEditDeploymentMappingsHyperlink.$$$reportNull$$$0(0);
            }
            if (data == null) {
                PhpEditDeploymentMappingsHyperlink.$$$reportNull$$$0(1);
            }
            super(PhpRemoteSdkBundle.message("remote.interpreter.deployment.debug.edit.path.mappings", new Object[0]));
            this.myProject = project;
            this.mySdkAdditionalData = data;
            this.myReloader = reloader;
        }

        @NotNull
        public SimpleTextAttributes getTextAttributes() {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.LINK_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                PhpEditDeploymentMappingsHyperlink.$$$reportNull$$$0(2);
            }
            return simpleTextAttributes;
        }

        public void onClick(MouseEvent event) {
            DeploymentConfigurable configurable = new DeploymentConfigurable(this.myProject);
            boolean ok = PhpUiUtil.editConfigurable((Project)this.myProject, (Configurable)configurable);
            if (ok) {
                PhpRemoteInterpreterManager remoteInterpreterManager = PhpRemoteInterpreterManager.getInstance();
                if (remoteInterpreterManager != null) {
                    PathMappingSettings newMappings = remoteInterpreterManager.createPathMappings(this.myProject, this.mySdkAdditionalData);
                    PhpRemoteSshDebugStrategy.this.myMapper = new PhpRemotePathMapper(newMappings.getPathMappings());
                }
                this.myReloader.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/remote/debug/PhpRemoteSshDebugStrategy$PhpEditDeploymentMappingsHyperlink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/remote/debug/PhpRemoteSshDebugStrategy$PhpEditDeploymentMappingsHyperlink";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

