/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.DeferredRemoteProcess;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.PhpRemoteSshHelpersManager;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;

public class PhpRemoteSshProcessRunner
extends PhpRemoteProcessRunner {
    private static final PhpRemoteSshProcessRunner ourInstance = new PhpRemoteSshProcessRunner();

    @NotNull
    public static PhpRemoteProcessRunner getInstance() {
        PhpRemoteSshProcessRunner phpRemoteSshProcessRunner = ourInstance;
        if (phpRemoteSshProcessRunner == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(0);
        }
        return phpRemoteSshProcessRunner;
    }

    @Override
    @NotNull
    public ProcessOutput getProcessOutput(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, @NotNull String title, @Nullable JComponent parent) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(1);
        }
        if (sdkData == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(3);
        }
        if (title == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(4);
        }
        PhpRemoteSshProcessRunner.updateHelpersAndValidate(project, sdkData);
        ProcessOutput processOutput = RemoteSdkUtil.getProcessOutput((Project)project, (RemoteCredentials)sdkData.getRemoteCredentials(project, false), (GeneralCommandLine)commandLine);
        if (processOutput == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(5);
        }
        return processOutput;
    }

    @Override
    @NotNull
    public Process getRemoteProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(6);
        }
        if (sdkData == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(7);
        }
        if (commandLine == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(8);
        }
        if (additionalMappings == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(9);
        }
        PhpRemoteSshProcessRunner.updateHelpersAndValidate(project, sdkData);
        Process process = PhpRemoteSshProcessRunner.startRemoteProcess(project, sdkData, commandLine, false);
        if (process == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(10);
        }
        return process;
    }

    @Override
    @NotNull
    public Process getRemoteBackgroundProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(11);
        }
        if (sdkData == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(12);
        }
        if (commandLine == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(13);
        }
        if (additionalMappings == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(14);
        }
        Process process = PhpRemoteSshProcessRunner.startRemoteProcess(project, sdkData, commandLine, true);
        if (process == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(15);
        }
        return process;
    }

    @Override
    @NotNull
    public Process startRemoteProcessWithoutHelpers(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, boolean withPty) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(16);
        }
        if (sdkData == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(17);
        }
        if (commandLine == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(18);
        }
        Process process = PhpRemoteSshProcessRunner.startRemoteProcess(project, sdkData, commandLine, true);
        if (process == null) {
            PhpRemoteSshProcessRunner.$$$reportNull$$$0(19);
        }
        return process;
    }

    private static Process startRemoteProcess(Project project, PhpRemoteSdkAdditionalData sdkData, GeneralCommandLine commandLine, boolean background) throws InterruptedException, ExecutionException {
        RemoteCredentials credentials = sdkData.getRemoteCredentials(project, false);
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials, (Project)project);
        if (background) {
            RemoteSdkSessionUtil.checkConnectionInBackground((ConnectionBuilder)connectionBuilder);
        } else {
            RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)project);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return new DeferredRemoteProcess(Promises.runAsync(() -> PhpRemoteSshProcessRunner.createRemoteProcess(commandLine, background, connectionBuilder)));
        }
        return PhpRemoteSshProcessRunner.createRemoteProcess(commandLine, background, connectionBuilder);
    }

    private static SshExecProcess createRemoteProcess(GeneralCommandLine commandLine, boolean background, ConnectionBuilder connectionBuilder) {
        return RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(background).start(60);
    }

    private static void updateHelpersAndValidate(Project project, PhpRemoteSdkAdditionalData sdkData) throws ExecutionException, InterruptedException {
        String error = sdkData.validate(project, null);
        if (StringUtil.isNotEmpty((String)error)) {
            throw new ExecutionException(error);
        }
        new PhpRemoteSshHelpersManager(sdkData).update(project, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 9, 11, 12, 13, 14, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/PhpRemoteSshProcessRunner";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteSshProcessRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteProcess";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBackgroundProcess";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "startRemoteProcessWithoutHelpers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcess";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteBackgroundProcess";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcessWithoutHelpers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 11, 12, 13, 14, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }
}

