/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpNameStyle {
    public static final PhpNameStyle DEFAULT = new PhpNameStyle();
    public static final PhpNameStyle CAPITALIZE = DEFAULT.withCapitalization(Capitalization.CAPITALIZE);
    public static final PhpNameStyle DECAPITALIZE = DEFAULT.withCapitalization(Capitalization.DECAPITALIZE);
    public static final PhpNameStyle UPPERCASE = DEFAULT.withCapitalization(Capitalization.UPPERCASE);
    private final Capitalization myCapitalization;
    private final Pluralization myPluralization;
    private final Style myStyle;

    private PhpNameStyle() {
        this(Capitalization.IGNORE, Pluralization.IGNORE, Style.MIXED);
    }

    private PhpNameStyle(@NotNull Capitalization capitalization, @NotNull Pluralization pluralization, @NotNull Style style) {
        if (capitalization == null) {
            PhpNameStyle.$$$reportNull$$$0(0);
        }
        if (pluralization == null) {
            PhpNameStyle.$$$reportNull$$$0(1);
        }
        if (style == null) {
            PhpNameStyle.$$$reportNull$$$0(2);
        }
        this.myCapitalization = capitalization;
        this.myPluralization = pluralization;
        this.myStyle = style;
    }

    @NotNull
    public PhpNameStyle withCapitalization(@NotNull Capitalization capitalization) {
        if (capitalization == null) {
            PhpNameStyle.$$$reportNull$$$0(3);
        }
        return new PhpNameStyle(capitalization, this.myPluralization, this.myStyle);
    }

    @NotNull
    public PhpNameStyle withPluralization(@NotNull Pluralization pluralization) {
        if (pluralization == null) {
            PhpNameStyle.$$$reportNull$$$0(4);
        }
        return new PhpNameStyle(this.myCapitalization, pluralization, this.myStyle);
    }

    @NotNull
    public PhpNameStyle withStyle(@NotNull Style style) {
        if (style == null) {
            PhpNameStyle.$$$reportNull$$$0(5);
        }
        return new PhpNameStyle(this.myCapitalization, this.myPluralization, style);
    }

    @NotNull
    public List<String> generateNames(@NotNull List<String> nameParts) {
        if (nameParts == null) {
            PhpNameStyle.$$$reportNull$$$0(6);
        }
        Function<String, String> capitalizer = this.getCapitalizer();
        Function<String, String> pluralizer = this.getPluralizer();
        SmartList generatedNames = new SmartList();
        for (int i = 0; i < nameParts.size(); ++i) {
            String generatedName;
            String firstNamePart = nameParts.get(i);
            if (firstNamePart.charAt(0) == '_' || !Character.isLetter(firstNamePart.charAt(0))) continue;
            switch (this.myStyle.ordinal()) {
                case 1: {
                    generatedName = ((StreamEx)StreamEx.of(nameParts).skip((long)i)).without((Object)"_").map(StringUtil::capitalize).joining();
                    generatedName = capitalizer.andThen(pluralizer).apply(generatedName);
                    break;
                }
                case 2: {
                    generatedName = ((StreamEx)StreamEx.of(nameParts).skip((long)i)).without((Object)"_").map(capitalizer).joining((CharSequence)"_");
                    generatedName = pluralizer.apply(generatedName);
                    break;
                }
                default: {
                    generatedName = ((StreamEx)StreamEx.of(nameParts).skip((long)i)).joining();
                    generatedName = capitalizer.andThen(pluralizer).apply(generatedName);
                }
            }
            if (!StringUtil.isNotEmpty((String)generatedName)) continue;
            generatedNames.add(generatedName);
        }
        SmartList smartList = generatedNames;
        if (smartList == null) {
            PhpNameStyle.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    @NotNull
    private Function<String, String> getCapitalizer() {
        Function<String, String> function = switch (this.myCapitalization.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> StringUtil::capitalize;
            case 2 -> StringUtil::decapitalize;
            case 3 -> StringUtil::toUpperCase;
            case 0 -> Function.identity();
        };
        if (function == null) {
            PhpNameStyle.$$$reportNull$$$0(8);
        }
        return function;
    }

    @NotNull
    private Function<String, String> getPluralizer() {
        Function<String, String> function = switch (this.myPluralization.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> StringUtil::pluralize;
            case 2 -> StringUtil::unpluralize;
            case 0 -> Function.identity();
        };
        if (function == null) {
            PhpNameStyle.$$$reportNull$$$0(9);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capitalization";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluralization";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpNameStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpNameStyle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapitalizer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluralizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withCapitalization";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withPluralization";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withStyle";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateNames";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static enum Capitalization {
        IGNORE,
        CAPITALIZE,
        DECAPITALIZE,
        UPPERCASE;

    }

    public static enum Pluralization {
        IGNORE,
        PLURALIZE,
        UNPLURALIZE;

    }

    public static enum Style {
        MIXED,
        CAMEL_CASE,
        SNAKE_CASE;

    }
}

