/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PhpTypeSignatureKey implements PhpTypeKey
{
    VARIABLE('V'),
    ARRAY_ELEMENT('E'),
    PARAMETER('A'),
    DOC_OF_SUPER_MEMBER('\u0401'),
    SUPER_MEMBER('\u042d'),
    FUNCTION('F'),
    CONSTANT('D'),
    CLASS('C'),
    CLASS_CONSTANT('K'),
    FIELD('P'),
    PARENT('Q'),
    POLYMORPHIC_CLASS('S'),
    METHOD('M'),
    SELF_CLASS('\u0424'),
    SELF_CLASS_IN_TRAIT('\u0442');

    private final char myKey;

    private PhpTypeSignatureKey(char key) {
        this.myKey = key;
    }

    @Override
    public boolean is(char key) {
        return this.myKey == key;
    }

    @Override
    @NotNull
    public String sign(@Nullable CharSequence name) {
        String string = "#" + this.myKey + String.valueOf(name);
        if (string == null) {
            PhpTypeSignatureKey.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String signIfUnsigned(@NotNull String name) {
        if (name == null) {
            PhpTypeSignatureKey.$$$reportNull$$$0(1);
        }
        String string = StringUtil.startsWith((CharSequence)name, (CharSequence)"#") ? name : this.sign(name);
        if (string == null) {
            PhpTypeSignatureKey.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String unsign(String fqn) {
        if (this.isSigned(fqn)) {
            return fqn.substring(2);
        }
        return fqn;
    }

    @NotNull
    public static String getSignature(Function function) {
        if (function instanceof Method) {
            String string = METHOD.sign(CLASS.sign(function.getFQN()));
            if (string == null) {
                PhpTypeSignatureKey.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = FUNCTION.sign(function.getFQN());
        if (string == null) {
            PhpTypeSignatureKey.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isSigned(@Nullable String name) {
        return name != null && name.length() > 1 && name.charAt(0) == '#' && name.charAt(1) == this.myKey;
    }

    @ApiStatus.Internal
    public char getKey() {
        return this.myKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeSignatureKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sign";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeSignatureKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "signIfUnsigned";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "signIfUnsigned";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

