/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.classes;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.Attributes;
import com.jetbrains.php.lang.parser.parsing.StatementList;
import com.jetbrains.php.lang.parser.parsing.TypeDeclaration;
import com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import com.jetbrains.php.lang.parser.parsing.functions.ParameterList;
import java.util.List;

public final class ClassField {
    private static final TokenSet START_OF_HOOK_BODY = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chLBRACE, PhpTokenTypes.opSEMICOLON, PhpTokenTypes.opHASH_ARRAY});
    private static final ParserPart PARSER_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            IElementType result;
            if (!builder.compare(PhpTokenTypes.VARIABLE)) {
                return PhpElementTypes.EMPTY_INPUT;
            }
            PsiBuilder.Marker field = builder.mark();
            builder.match(PhpTokenTypes.VARIABLE);
            if (builder.compareAndEat(PhpTokenTypes.opASGN) && (result = Expression.parse(builder)) == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("initializer", new Object[0])));
            }
            ClassField.tryToParseHooks(builder);
            field.done((IElementType)PhpStubElementTypes.CLASS_FIELD);
            return PhpStubElementTypes.CLASS_FIELD;
        }
    };

    private static void remapPropertyHookKw(PhpPsiBuilder builder) {
        while (builder.compare(PhpTokenTypes.IDENTIFIER)) {
            String text = builder.getTokenText();
            if (text == null) {
                return;
            }
            if (text.equalsIgnoreCase("set")) {
                builder.remapCurrentToken(PhpTokenTypes.kwSET);
            } else if (text.equalsIgnoreCase("get")) {
                builder.remapCurrentToken(PhpTokenTypes.kwGET);
            } else {
                builder.match(PhpTokenTypes.tsPROPERTY_HOOKS_KEYWORDS);
            }
            builder.advanceLexer();
        }
    }

    public static boolean tryToParseHooks(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.chLBRACE)) {
            return false;
        }
        PsiBuilder.Marker hooks = builder.mark();
        builder.advanceLexer();
        boolean parsedHook = false;
        while (builder.compare(PhpTokenTypes.opBIT_AND) || builder.compare(PhpTokenTypes.IDENTIFIER) || builder.compare(PhpTokenTypes.ATTRIBUTE_START) || builder.compare(PhpTokenTypes.tsVARIABLE_MODIFIERS) || ClassMemberModifiers.mayBeReadonlyKeyword(builder)) {
            PsiBuilder.Marker hook = builder.mark();
            Attributes.parseAttributesList(builder);
            ClassMemberModifiers.parseVariableModifiers(builder);
            builder.compareAndEat(PhpTokenTypes.opBIT_AND);
            ClassField.remapPropertyHookKw(builder);
            parsedHook = true;
            ClassField.parsePropertyHookParameterListIfNeeded(builder);
            if (builder.compare(PhpTokenTypes.chLBRACE)) {
                StatementList.parseFast(builder);
            } else if (builder.compareAndEat(PhpTokenTypes.opHASH_ARRAY)) {
                IElementType expression = Expression.parse(builder);
                if (expression == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("expression1", new Object[0])));
                }
                builder.match(PhpTokenTypes.opSEMICOLON);
            } else {
                builder.match(START_OF_HOOK_BODY);
            }
            hook.done((IElementType)PhpStubElementTypes.PROPERTY_HOOK);
        }
        if (!parsedHook) {
            builder.error(PhpParserErrors.expected(PhpTokenTypes.tsPROPERTY_HOOKS_KEYWORDS));
        }
        if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
            builder.error(PhpParserErrors.unexpected(PhpTokenTypes.IDENTIFIER));
        }
        builder.match(PhpTokenTypes.chRBRACE);
        hooks.done(PhpElementTypes.PROPERTY_HOOKS);
        return true;
    }

    public static IElementType parse(PhpPsiBuilder builder) {
        IElementType result;
        PsiBuilder.Marker classFields = builder.mark();
        Attributes.parseAttributesList(builder);
        if (ClassMemberModifiers.parseVariableModifiers(builder) == PhpElementTypes.EMPTY_INPUT) {
            classFields.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        IElementType typeResult = TypeDeclaration.parseType(builder, PhpElementTypes.FIELD_TYPE);
        if (typeResult != PhpElementTypes.EMPTY_INPUT) {
            Attributes.parseAttributesList(builder);
        }
        if ((result = PARSER_PART.parse(builder)) == PhpElementTypes.EMPTY_INPUT) {
            if (typeResult != PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("variable1", new Object[0])));
            } else {
                classFields.rollbackTo();
                return PhpElementTypes.EMPTY_INPUT;
            }
        }
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, result, PARSER_PART, false);
        ClassField.parseSemicolonAfterFieldDeclarationIfNeeded(builder);
        classFields.done(PhpElementTypes.CLASS_FIELDS);
        return PhpElementTypes.CLASS_FIELDS;
    }

    private static void parsePropertyHookParameterListIfNeeded(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.chLPAREN)) {
            ParameterList.parse(builder, false);
            builder.match(PhpTokenTypes.chRPAREN);
        }
    }

    private static void parseSemicolonAfterFieldDeclarationIfNeeded(PhpPsiBuilder builder) {
        List<? extends SyntaxTreeBuilder.Production> productions = builder.getProductions();
        if (productions.size() < 2 || productions.get(productions.size() - 2).getTokenType() != PhpElementTypes.PROPERTY_HOOKS) {
            builder.match(PhpTokenTypes.opSEMICOLON);
        }
    }
}

