/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.editor;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.DefaultLineWrapPositionStrategy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpLineWrapPositionStrategy
extends DefaultLineWrapPositionStrategy {
    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        if (document == null) {
            PhpLineWrapPositionStrategy.$$$reportNull$$$0(0);
        }
        int minWrapPosition = startOffset;
        if (!isSoftWrap) {
            if (project == null) {
                return -1;
            }
            minWrapPosition = Math.max(startOffset, PhpLineWrapPositionStrategy.getMinWrapPosition(document, project, maxPreferredOffset));
        }
        return super.calculateWrapPosition(document, project, minWrapPosition, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, isSoftWrap);
    }

    private static int getMinWrapPosition(@NotNull Document document, @NotNull Project project, int offset) {
        PsiElement currElement;
        Object parent;
        PsiFile psiFile;
        PsiDocumentManager manager;
        if (document == null) {
            PhpLineWrapPositionStrategy.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PhpLineWrapPositionStrategy.$$$reportNull$$$0(2);
        }
        if ((manager = PsiDocumentManager.getInstance((Project)project)).isUncommited(document)) {
            manager.commitDocument(document);
        }
        if ((psiFile = manager.getPsiFile(document)) != null && (parent = BasicPhpPsiUtil.getParentByCondition(currElement = psiFile.findElementAt(offset), (Condition<? super PsiElement>)((Condition)element -> {
            if (element != null) {
                ASTNode node = element.getNode();
                return node != null && node.getElementType() == PhpElementTypes.STRING;
            }
            return false;
        }))) != null) {
            return parent.getTextRange().getEndOffset();
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/editor/PhpLineWrapPositionStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateWrapPosition";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinWrapPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

