/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpElementWithModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClassHierarchyUtils {
    private static final NextElementsAppender<PhpClass> SUPER_CLASS_APPENDER_NOT_AMBIGUITY = (element, phpClasses) -> ContainerUtil.addIfNotNull((Collection)phpClasses, (Object)element.getSuperClass());
    private static final NextElementsAppender<PhpClass> SUPER_CLASS_APPENDER_AMBIGUITY = (element, phpClasses) -> phpClasses.addAll(element.getSuperClasses());
    private static final NextElementsAppender<PhpClass> SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY = (element, phpClasses) -> {
        PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
        for (String interfaceName : element.getInterfaceNames()) {
            Collection<PhpClass> interfacesByFQN = phpIndex.getInterfacesByFQN(interfaceName);
            if (interfacesByFQN.size() != 1) continue;
            phpClasses.add(interfacesByFQN.iterator().next());
        }
        phpClasses.addAll(element.getTypeAwareImplicitEnumInterfaces());
    };
    private static final NextElementsAppender<PhpClass> SUPER_INTERFACE_APPENDER_AMBIGUITY = (element, phpClasses) -> {
        PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
        for (String interfaceName : element.getInterfaceNames()) {
            phpClasses.addAll(phpIndex.getInterfacesByFQN(interfaceName));
        }
        phpClasses.addAll(element.getTypeAwareImplicitEnumInterfaces());
    };
    private static final NextElementsAppender<PhpClass> MIXINS_APPENDER = (element, phpClasses) -> ContainerUtil.addAll((Collection)phpClasses, (Object[])element.getMixins());
    private static final NextElementsAppender<PhpClass> SUPER_TRAIT_APPENDER_NOT_AMBIGUITY = (element, phpClasses) -> {
        PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
        for (String name : element.getTraitNames()) {
            Collection<PhpClass> classes = phpIndex.getTraitsByFQN(name);
            if (classes.size() != 1) continue;
            phpClasses.add(classes.iterator().next());
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_TRAIT_APPENDER_AMBIGUITY = (element, phpClasses) -> {
        String[] names;
        PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
        for (String name : names = element.getTraitNames()) {
            phpClasses.addAll(phpIndex.getTraitsByFQN(name));
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_APPENDER_NOT_AMBIGUITY = new CompositeNextElementsAppender<PhpClass>(SUPER_TRAIT_APPENDER_NOT_AMBIGUITY, SUPER_CLASS_APPENDER_NOT_AMBIGUITY, SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY);
    private static final NextElementsAppender<PhpClass> SUPER_APPENDER_AMBIGUITY = new CompositeNextElementsAppender<PhpClass>(SUPER_TRAIT_APPENDER_AMBIGUITY, SUPER_CLASS_APPENDER_AMBIGUITY, SUPER_INTERFACE_APPENDER_AMBIGUITY);
    private static final NextElementsAppender<PhpClass> SUPER_APPENDER_NOT_AMBIGUITY_WITH_MIXINS = new CompositeNextElementsAppender<PhpClass>(SUPER_TRAIT_APPENDER_NOT_AMBIGUITY, SUPER_CLASS_APPENDER_NOT_AMBIGUITY, SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY, MIXINS_APPENDER);
    private static final NextElementsAppender<PhpClass> SUPER_APPENDER_AMBIGUITY_WITHOUT_TRAITS = new CompositeNextElementsAppender<PhpClass>(SUPER_CLASS_APPENDER_AMBIGUITY, SUPER_INTERFACE_APPENDER_AMBIGUITY, MIXINS_APPENDER);
    @ApiStatus.Internal
    public static final NextElementsAppender<PhpClass> SUPER_APPENDER_AMBIGUITY_WITH_MIXINS = new CompositeNextElementsAppender<PhpClass>(SUPER_TRAIT_APPENDER_AMBIGUITY, SUPER_APPENDER_AMBIGUITY_WITHOUT_TRAITS);
    @ApiStatus.Internal
    public static final HierarchyClassMemberProcessor FALSE_PROCESSOR = (superMember, subClass, baseClass) -> false;

    public static boolean subclassesOfBaseContainsFQN(Project project, @NotNull String fqn, @NotNull String baseFQN, Key<CachedValue<Collection<String>>> key) {
        if (fqn == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(0);
        }
        if (baseFQN == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(1);
        }
        return fqn.equalsIgnoreCase(baseFQN) || ((Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, key, () -> {
            PhpIndex instance = PhpIndex.getInstance(project);
            HashSet res = new HashSet();
            instance.processAllSubclasses(baseFQN, (Processor<? super PhpClass>)((Processor)c -> {
                res.add(c.getFQN());
                return true;
            }));
            return CachedValueProvider.Result.createSingleDependency(res, (Object)PsiModificationTracker.MODIFICATION_COUNT);
        }, false)).contains(fqn);
    }

    private PhpClassHierarchyUtils() {
    }

    private static <T extends PhpClass> void process(@NotNull T initialElement, boolean processSelf, @NotNull Processor<? super T> processor, @NotNull NextElementsAppender<T> appender) {
        if (initialElement == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(3);
        }
        if (appender == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(4);
        }
        PhpClassHierarchyUtils.process(initialElement, processSelf, processor, appender, new HashSet());
    }

    private static <T extends PhpClass> void process(@NotNull T initialElement, boolean processSelf, @NotNull Processor<? super T> processor, @NotNull NextElementsAppender<T> appender, Collection<T> processed) {
        if (initialElement == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(6);
        }
        if (appender == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(7);
        }
        HashSet<String> processedFQNs = new HashSet<String>();
        ArrayDeque<T> processorPool = new ArrayDeque<T>();
        if (processSelf) {
            processorPool.add(initialElement);
        } else {
            appender.appendNextElements(initialElement, processorPool);
        }
        while (!processorPool.isEmpty()) {
            ProgressManager.checkCanceled();
            PhpClass first = (PhpClass)processorPool.pollFirst();
            processedFQNs.add(first.getFQN());
            if (!processed.add(first)) continue;
            if (processor.process((Object)first)) {
                appender.appendNextElements(first, processorPool);
                continue;
            }
            for (PhpClass remainingClassWithSameFQN : processorPool) {
                ProgressManager.checkCanceled();
                if (!processedFQNs.contains(remainingClassWithSameFQN.getFQN())) continue;
                processor.process((Object)remainingClassWithSameFQN);
            }
            return;
        }
    }

    public static void processSuperClasses(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(9);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_CLASS_APPENDER_AMBIGUITY : SUPER_CLASS_APPENDER_NOT_AMBIGUITY);
    }

    public static void processSuperTraits(@NotNull PhpClass clazz, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(11);
        }
        PhpClassHierarchyUtils.process(clazz, false, processor, SUPER_TRAIT_APPENDER_AMBIGUITY);
    }

    public static void processSuperInterfaces(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(13);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_INTERFACE_APPENDER_AMBIGUITY : SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY);
    }

    public static void processSupers(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(15);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_APPENDER_AMBIGUITY_WITH_MIXINS : SUPER_APPENDER_NOT_AMBIGUITY_WITH_MIXINS);
    }

    public static void processSuperWithoutMixins(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(17);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_APPENDER_AMBIGUITY : SUPER_APPENDER_NOT_AMBIGUITY, new HashSet());
    }

    @ApiStatus.Internal
    public static void processSuperWithoutMixins(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor, Collection<PhpClass> processed) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(19);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_APPENDER_AMBIGUITY : SUPER_APPENDER_NOT_AMBIGUITY, processed);
    }

    public static boolean isSuperClass(@NotNull PhpClass superClass, @NotNull PhpClass subClass, boolean allowAmbiguity) {
        if (superClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(20);
        }
        if (subClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(21);
        }
        return PhpClassHierarchyUtils.isSuperClass(superClass, subClass, allowAmbiguity, true);
    }

    public static boolean isSuperClass(@Nullable PhpClass superClass, @Nullable PhpClass subClass, boolean allowAmbiguity, boolean strict) {
        if (superClass == null || subClass == null) {
            return false;
        }
        Ref isSuperClassRef = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperClasses(subClass, !strict, allowAmbiguity, (Processor<? super PhpClass>)((Processor)curClass -> {
            if (PhpClassHierarchyUtils.classesEqual(curClass, superClass)) {
                isSuperClassRef.set((Object)true);
            }
            return (Boolean)isSuperClassRef.get() == false;
        }));
        return (Boolean)isSuperClassRef.get();
    }

    public static void processMethods(PhpClass phpClass, PhpClass initialClass, @NotNull HierarchyMethodProcessor methodProcessor, boolean processOwnMembersOnly, boolean processMixins) {
        if (methodProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(22);
        }
        PhpClassHierarchyUtils.processMembersInternal(phpClass, new HashSet(), null, initialClass, methodProcessor, Method.INSTANCEOF, processOwnMembersOnly, processMixins, new HashSet<String>());
    }

    public static void processMethodsWithGenericMixins(PhpClass phpClass, PhpClass initialClass, @NotNull HierarchyMethodProcessor methodProcessor, boolean processOwnMembersOnly, boolean processMixins, String genericInstantiationType) {
        if (methodProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(23);
        }
        PhpClassHierarchyUtils.processMembersInternalWithGenericMixins(phpClass, new HashSet(), null, initialClass, methodProcessor, Method.INSTANCEOF, processOwnMembersOnly, processMixins, new HashSet<String>(), genericInstantiationType);
    }

    public static void processFields(PhpClass phpClass, PhpClass initialClass, @NotNull HierarchyFieldProcessor fieldProcessor, boolean processOwnMembersOnly, boolean processMixins) {
        if (fieldProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(24);
        }
        PhpClassHierarchyUtils.processMembersInternal(phpClass, new HashSet(), null, initialClass, fieldProcessor, Field.INSTANCEOF, processOwnMembersOnly, processMixins, new HashSet<String>());
    }

    public static void processFieldsWithGenericMixins(PhpClass phpClass, PhpClass initialClass, @NotNull HierarchyFieldProcessor fieldProcessor, boolean processOwnMembersOnly, boolean processMixins, String genericInstantiationType) {
        if (fieldProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(25);
        }
        PhpClassHierarchyUtils.processMembersInternalWithGenericMixins(phpClass, new HashSet(), null, initialClass, fieldProcessor, Field.INSTANCEOF, processOwnMembersOnly, processMixins, new HashSet<String>(), genericInstantiationType);
    }

    private static <T extends PhpClassMember> boolean processMembersInternal(@Nullable PhpClass phpClass, @NotNull Set<? super PhpClass> visited, @Nullable Map<String, PhpTraitUseRule> conflictResolution, PhpClass initialClass, @NotNull TypedHierarchyMemberProcessor<T> processor, Condition<PsiElement> condition, boolean processOwnMembersOnly, boolean processMixins, Set<String> nonDocVisitedMembersNames) {
        if (visited == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(27);
        }
        return PhpClassHierarchyUtils.processMembersInternalWithGenericMixins(phpClass, visited, conflictResolution, initialClass, processor, condition, processOwnMembersOnly, processMixins, nonDocVisitedMembersNames, null);
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends PhpClassMember> boolean processMembersInternalWithGenericMixins(@Nullable PhpClass phpClass, @NotNull Set<? super PhpClass> visited, @Nullable Map<String, PhpTraitUseRule> conflictResolution, PhpClass initialClass, @NotNull TypedHierarchyMemberProcessor<T> processor, Condition<PsiElement> condition, boolean processOwnMembersOnly, boolean processMixins, Set<String> nonDocVisitedMembersNames, String genericInstantiationType) {
        if (visited == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(28);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(29);
        }
        if (phpClass == null || !visited.add(phpClass)) {
            return true;
        }
        ProgressManager.checkCanceled();
        boolean processMethods = condition == Method.INSTANCEOF;
        HashSet<String> currentNonDocVisitedMembersNames = new HashSet<String>();
        PhpClassMember[] members = processMethods ? phpClass.getOwnMethods() : phpClass.getOwnFields(true);
        for (PhpClassMember phpClassMember : members) {
            PhpTraitUseRule rule;
            if (!processMethods) {
                if (phpClassMember instanceof PhpDocProperty) {
                    if (nonDocVisitedMembersNames.contains(phpClassMember.getName())) {
                        continue;
                    }
                } else {
                    currentNonDocVisitedMembersNames.add(phpClassMember.getName());
                }
            }
            PhpTraitUseRule phpTraitUseRule = rule = conflictResolution != null ? conflictResolution.get(phpClassMember.getFQN()) : null;
            if (rule != null && rule.getAlias() == null && processMethods || !(processMethods ? !((HierarchyMethodProcessor)processor).process((Method)phpClassMember, phpClass, initialClass) : !((HierarchyFieldProcessor)processor).process((Field)phpClassMember, phpClass, initialClass))) continue;
            return false;
        }
        if (!processMethods) {
            nonDocVisitedMembersNames = ContainerUtil.union(currentNonDocVisitedMembersNames, (Set)nonDocVisitedMembersNames);
        }
        if (!processOwnMembersOnly && phpClass.hasTraitUses()) {
            Iterator<PhpClass> rules = phpClass.traitUseRules().toList();
            Map<String, PhpTraitUseRule> newConflictResolution = PhpClassHierarchyUtils.getTraitUseRulesConflictResolutions((Collection<PhpTraitUseRule>)((Object)rules));
            if (processMethods) {
                Iterator iterator = rules.iterator();
                while (iterator.hasNext()) {
                    Method member;
                    PhpTraitUseRule phpTraitUseRule = (PhpTraitUseRule)iterator.next();
                    if (phpTraitUseRule.isInsteadOf() || (member = phpTraitUseRule.getMethod()) == null || !member.isValid() || ((HierarchyMethodProcessor)processor).process(member, phpClass, initialClass)) continue;
                    return false;
                }
            }
            for (PhpClass trait : phpClass.getTraits()) {
                if (PhpClassHierarchyUtils.processMembersInternal(trait, visited, newConflictResolution, initialClass, processor, condition, processOwnMembersOnly, processMixins, nonDocVisitedMembersNames)) continue;
                return false;
            }
        }
        if (!processOwnMembersOnly) {
            for (PhpClass superClass : phpClass.getSuperClasses()) {
                if (PhpClassHierarchyUtils.processMembersInternal(superClass, visited, null, initialClass, processor, condition, processOwnMembersOnly, processMixins, nonDocVisitedMembersNames)) continue;
                return false;
            }
            for (PhpClass phpInterface : phpClass.getDirectImplementedInterfaces()) {
                if (PhpClassHierarchyUtils.processMembersInternal(phpInterface, visited, null, initialClass, processor, condition, processOwnMembersOnly, processMixins, nonDocVisitedMembersNames)) continue;
                return false;
            }
            if (phpClass.isEnum()) {
                for (PhpClass phpInterface : phpClass.getTypeAwareImplicitEnumInterfaces()) {
                    if (PhpClassHierarchyUtils.processMembersInternal(phpInterface, visited, null, initialClass, processor, condition, processOwnMembersOnly, processMixins, nonDocVisitedMembersNames)) continue;
                    return false;
                }
            }
            if (processMixins) {
                if (genericInstantiationType != null && phpClass.hasGenericMixins()) {
                    void var16_28;
                    PhpClass[] mixins;
                    PhpClass[] phpClassArray = mixins = phpClass.getMixinsIncludingGeneric(genericInstantiationType);
                    int n = phpClassArray.length;
                    boolean bl = false;
                    while (var16_28 < n) {
                        PhpClass mixin = phpClassArray[var16_28];
                        if (!PhpClassHierarchyUtils.processMembersInternal(mixin, visited, null, initialClass, processor, condition, processOwnMembersOnly, processMixins, nonDocVisitedMembersNames)) {
                            return false;
                        }
                        ++var16_28;
                    }
                    return true;
                }
                for (PhpElementWithModifier phpElementWithModifier : phpClass.getMixins()) {
                    if (PhpClassHierarchyUtils.processMembersInternal((PhpClass)phpElementWithModifier, visited, null, initialClass, processor, condition, processOwnMembersOnly, processMixins, nonDocVisitedMembersNames)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public static Map<String, PhpTraitUseRule> getTraitUseRulesConflictResolutions(Collection<PhpTraitUseRule> rules) {
        HashMap<String, PhpTraitUseRule> newConflictResolution = new HashMap<String, PhpTraitUseRule>();
        for (PhpTraitUseRule rule : rules) {
            for (String overridesFqn : rule.getOverriddenMethodFqns()) {
                newConflictResolution.put(overridesFqn, rule);
            }
        }
        HashMap<String, PhpTraitUseRule> hashMap = newConflictResolution;
        if (hashMap == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(30);
        }
        return hashMap;
    }

    public static boolean processOverridingFields(@NotNull Field field, TypedHierarchyMemberProcessor<? super Field> memberProcessor) {
        if (field == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(31);
        }
        PhpIndex phpIndex = PhpIndex.getInstance(field.getProject());
        PhpClass me = field.getContainingClass();
        if (me != null) {
            String fieldName = field.getName();
            Ref res = new Ref((Object)true);
            boolean isConstant = field.isConstant();
            phpIndex.processAllSubclasses(me.getFQN(), (Processor<? super PhpClass>)((Processor)myChild -> {
                Field overriddenField = myChild.findOwnFieldByName(fieldName, isConstant);
                if (overriddenField != null && !memberProcessor.process(overriddenField, (PhpClass)myChild, me)) {
                    res.set((Object)false);
                    return false;
                }
                return true;
            }));
            return (Boolean)res.get();
        }
        return false;
    }

    public static boolean processOverridingMethods(@NotNull Method method, TypedHierarchyMemberProcessor<? super Method> memberProcessor) {
        if (method == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(32);
        }
        return PhpClassHierarchyUtils.processOverridingMethods(method, method.getContainingClass(), memberProcessor);
    }

    public static boolean processOverridingMethods(@NotNull Method method, @Nullable PhpClass containingClass, TypedHierarchyMemberProcessor<? super Method> memberProcessor) {
        if (method == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(33);
        }
        PhpIndex phpIndex = PhpIndex.getInstance(method.getProject());
        if (!PhpClassHierarchyUtils.methodCanHaveOverride(method)) {
            return true;
        }
        String methodName = method.getName();
        if (containingClass != null && containingClass.isValid()) {
            ArrayList<PhpClass> allSubclasses = new ArrayList<PhpClass>();
            return PhpClassHierarchyUtils.processSubclasses(memberProcessor, phpIndex, methodName, containingClass, allSubclasses) && PhpClassHierarchyUtils.processTraitUsages(memberProcessor, phpIndex, methodName, containingClass, allSubclasses) && !containingClass.isTrait() && PhpClassHierarchyUtils.collectUsedTraits(allSubclasses, (Processor<PhpClass>)((Processor)trait -> trait == containingClass || PhpClassHierarchyUtils.processOverridingMethod(memberProcessor, methodName, containingClass, trait)));
        }
        return true;
    }

    private static boolean processTraitUsages(TypedHierarchyMemberProcessor<? super Method> memberProcessor, PhpIndex phpIndex, String methodName, PhpClass me, Collection<PhpClass> allSubclasses) {
        for (PhpClass c : phpIndex.getTraitUsages(me)) {
            allSubclasses.add(c);
            if (PhpClassHierarchyUtils.processOverridingMethod(memberProcessor, methodName, me, c)) continue;
            return false;
        }
        return true;
    }

    public static void processMethodInSubclasses(TypedHierarchyMemberProcessor<? super Method> memberProcessor, PhpIndex phpIndex, String methodName, PhpClass me) {
        PhpClassHierarchyUtils.processSubclasses(memberProcessor, phpIndex, methodName, me, null);
    }

    private static boolean processSubclasses(TypedHierarchyMemberProcessor<? super Method> memberProcessor, PhpIndex phpIndex, String methodName, PhpClass me, @Nullable Collection<PhpClass> allSubclasses) {
        Ref res = new Ref((Object)true);
        phpIndex.processAllSubclasses(me.getFQN(), (Processor<? super PhpClass>)((Processor)c -> {
            if (allSubclasses != null) {
                allSubclasses.add((PhpClass)c);
            }
            if (!PhpClassHierarchyUtils.processOverridingMethod(memberProcessor, methodName, me, c)) {
                res.set((Object)false);
                return false;
            }
            return true;
        }));
        return (Boolean)res.get();
    }

    private static boolean processOverridingMethod(TypedHierarchyMemberProcessor<? super Method> memberProcessor, String methodName, PhpClass me, PhpClass myChild) {
        Method overriddenMethod = myChild.findOwnMethodByName(methodName);
        return overriddenMethod == null || memberProcessor.process(overriddenMethod, myChild, me);
    }

    public static boolean processOverridingMembers(PhpClassMember member, HierarchyClassMemberProcessor memberProcessor) {
        if (member instanceof Method) {
            return PhpClassHierarchyUtils.processOverridingMethods((Method)member, (method, subClass, baseClass) -> memberProcessor.process(method, subClass, baseClass));
        }
        return PhpClassHierarchyUtils.processOverridingFields((Field)member, (field, subClass, baseClass) -> memberProcessor.process(field, subClass, baseClass));
    }

    private static boolean collectUsedTraits(@NotNull Collection<PhpClass> classes, Processor<PhpClass> traitProcessor) {
        if (classes == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(34);
        }
        HashSet<PhpClass> result = new HashSet<PhpClass>();
        Deque traitsToProcess = classes.stream().flatMap(e -> Arrays.stream(e.getTraits())).collect(Collectors.toCollection(ArrayDeque::new));
        while (!traitsToProcess.isEmpty()) {
            PhpClass trait = (PhpClass)traitsToProcess.pollFirst();
            if (trait == null || !result.add(trait)) continue;
            if (!traitProcessor.process((Object)trait)) {
                return false;
            }
            for (PhpClass innerTrait : trait.getTraits()) {
                traitsToProcess.addLast(innerTrait);
            }
        }
        return true;
    }

    public static boolean methodCanHaveOverride(@NotNull Method element) {
        PhpClass containingClass;
        if (element == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(35);
        }
        return (containingClass = element.getContainingClass()) != null && !containingClass.isFinal() && !element.getAccess().isPrivate() && !element.isFinal();
    }

    public static boolean hasSuperMethod(@NotNull Method method) {
        if (method == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(36);
        }
        Ref hasSuperMethod = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperMethods(method, (member, subclass, superClass) -> {
            hasSuperMethod.set((Object)true);
            return false;
        });
        return (Boolean)hasSuperMethod.get();
    }

    private static <T extends PhpClassMember> boolean processSuperMembersInternal(@NotNull T member, @NotNull MemberFounder<T> memberFounder, @NotNull TypedHierarchyMemberProcessor<T> memberProcessor) {
        if (member == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(37);
        }
        if (memberFounder == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(38);
        }
        if (memberProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(39);
        }
        HashSet<PhpClass> processed = new HashSet<PhpClass>();
        HashSet<PhpClassMember> processedMember = new HashSet<PhpClassMember>();
        ArrayDeque<PhpClassMember> members = new ArrayDeque<PhpClassMember>();
        members.add(member);
        while (!members.isEmpty()) {
            PhpClass me = ((PhpClassMember)members.poll()).getContainingClass();
            if (me == null) {
                return false;
            }
            List<PhpClass> parents = PhpClassHierarchyUtils.getImmediateParents(me);
            if (me.isTrait()) {
                for (PhpClass usage : PhpClassHierarchyUtils.collectClassesWithTraitUsage(me)) {
                    parents.addAll(usage.getSuperClasses());
                    Collections.addAll(parents, usage.getImplementedInterfaces());
                }
            }
            HashSet overriddenClassesFqns = new HashSet();
            if (member instanceof Method) {
                String methodName = member.getName();
                me.traitUseRules().filter(PhpTraitUseRule::isInsteadOf).flatMap(e -> e.getOverriddenMethodFqns()).filter(fqn -> fqn.substring(fqn.lastIndexOf(46) + 1).equalsIgnoreCase(methodName)).map(fqn -> fqn.substring(0, fqn.lastIndexOf(46))).forEach(overriddenClassesFqns::add);
            }
            boolean res = true;
            for (PhpClass mySuper : parents) {
                if (mySuper.isTrait() && overriddenClassesFqns.contains(mySuper.getFQN())) continue;
                for (PhpClassMember foundMember : memberFounder.findMember(mySuper, member, processed)) {
                    PhpModifier modifier;
                    if (foundMember == null || !processedMember.add(foundMember) || (modifier = foundMember.getModifier()).isPrivate() && (!(foundMember instanceof Method) || !PhpClassHierarchyUtils.isAbstractTraitClass((Method)foundMember, modifier) && ((Method)foundMember).getMethodType(true) != Method.MethodType.CONSTRUCTOR)) continue;
                    members.add(foundMember);
                    res = memberProcessor.process(foundMember, me, mySuper) && res;
                }
            }
            if (res) continue;
            return false;
        }
        return true;
    }

    private static boolean isAbstractTraitClass(Method foundMember, PhpModifier modifier) {
        PhpClass aClass = foundMember.getContainingClass();
        return modifier.isAbstract() && aClass != null && aClass.isTrait();
    }

    public static boolean processSuperMethods(@NotNull Method member, @NotNull HierarchyMethodProcessor memberProcessor) {
        if (member == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(40);
        }
        if (memberProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(41);
        }
        return PhpClassHierarchyUtils.processSuperMembersInternal(member, (superClass, method, visitedClasses) -> superClass.findMethodsByName(member.getName(), visitedClasses), memberProcessor);
    }

    public static boolean processSuperFields(@NotNull Field member, @NotNull HierarchyFieldProcessor memberProcessor) {
        if (member == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(42);
        }
        if (memberProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(43);
        }
        return PhpClassHierarchyUtils.processSuperMembersInternal(member, (superClass, field, visitedClasses) -> Collections.singleton(superClass.findFieldByName(member.getName(), member.isConstant())), memberProcessor);
    }

    public static boolean processSuperMembers(@NotNull PhpClassMember member, @NotNull HierarchyClassMemberProcessor memberProcessor) {
        if (member == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(44);
        }
        if (memberProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(45);
        }
        if (member instanceof Method) {
            return PhpClassHierarchyUtils.processSuperMethods((Method)member, (member1, subClass, baseClass) -> memberProcessor.process(member1, subClass, baseClass));
        }
        return PhpClassHierarchyUtils.processSuperFields((Field)member, (member1, subClass, baseClass) -> memberProcessor.process(member1, subClass, baseClass));
    }

    @NotNull
    private static Collection<PhpClass> collectClassesWithTraitUsage(@NotNull PhpClass trait) {
        if (trait == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(46);
        }
        PhpIndex index = PhpIndex.getInstance(trait.getProject());
        ArrayDeque<PhpClass> usages = new ArrayDeque<PhpClass>(index.getTraitUsages(trait));
        HashSet<PhpClass> result = new HashSet<PhpClass>();
        while (!usages.isEmpty()) {
            PhpClass classWithTraitUsage = (PhpClass)usages.pollFirst();
            if (classWithTraitUsage == null || !result.add(classWithTraitUsage) || !classWithTraitUsage.isTrait()) continue;
            usages.addAll(index.getTraitUsages(classWithTraitUsage));
        }
        HashSet<PhpClass> hashSet = result;
        if (hashSet == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(47);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<PhpClass> getSuperClasses(@NotNull PhpClass aClass) {
        if (aClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(48);
        }
        String superName = aClass.getSuperFQN();
        PhpIndex phpIndex = PhpIndex.getInstance(aClass.getProject());
        Collection<PhpClass> classes = aClass.isInterface() ? phpIndex.getInterfacesByFQN(superName) : phpIndex.getClassesByFQN(superName);
        List list = ContainerUtil.filter(classes, c -> c != aClass);
        if (list == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(49);
        }
        return list;
    }

    public static List<PhpClass> getImmediateParents(PhpClass me) {
        ArrayList<PhpClass> parents = new ArrayList<PhpClass>(PhpClassHierarchyUtils.getSuperClasses(me));
        ContainerUtil.addAll(parents, (Object[])me.getImplementedInterfaces());
        ContainerUtil.addAll(parents, (Object[])me.getTraits());
        return parents;
    }

    public static Collection<PhpClass> getDirectSubclasses(@NotNull PhpClass psiClass) {
        if (psiClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(50);
        }
        if (psiClass.isFinal()) {
            return Collections.emptyList();
        }
        PhpIndex phpIndex = PhpIndex.getInstance(psiClass.getProject());
        return phpIndex.getDirectSubclasses(psiClass.getFQN());
    }

    @Deprecated
    public static Collection<PhpClass> getAllSubclasses(@NotNull PhpClass psiClass) {
        if (psiClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(51);
        }
        if (psiClass.isFinal()) {
            return Collections.emptyList();
        }
        PhpIndex phpIndex = PhpIndex.getInstance(psiClass.getProject());
        return phpIndex.getAllSubclasses(psiClass.getFQN());
    }

    public static boolean anySubclassExists(@NotNull PhpClass psiClass, Predicate<PhpClass> predicate) {
        if (psiClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(52);
        }
        return !psiClass.isFinal() && PhpClassHierarchyUtils.anySubclassExists(psiClass.getProject(), psiClass.getFQN(), predicate);
    }

    public static boolean subclassExists(@NotNull PhpClass psiClass) {
        if (psiClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(53);
        }
        return PhpClassHierarchyUtils.anySubclassExists(psiClass, aClass -> true);
    }

    public static boolean anySubclassExists(@NotNull Project project, @NotNull String fqn, Predicate<PhpClass> predicate) {
        if (project == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(54);
        }
        if (fqn == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(55);
        }
        PhpIndex phpIndex = PhpIndex.getInstance(project);
        Ref res = new Ref((Object)false);
        phpIndex.processAllSubclasses(fqn, (Processor<? super PhpClass>)((Processor)r -> {
            if (predicate.test((PhpClass)r)) {
                res.set((Object)true);
                return false;
            }
            return true;
        }));
        return (Boolean)res.get();
    }

    @Nullable
    public static PhpClass getObject(@NotNull Project project) {
        Iterator<PhpClass> iterator;
        if (project == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(56);
        }
        return (iterator = PhpIndex.getInstance(project).getClassesByFQN("\\___PHPSTORM_HELPERS\\object").iterator()).hasNext() ? iterator.next() : null;
    }

    public static boolean isMyTrait(@NotNull PhpClass me, @NotNull PhpClass trait, @Nullable Collection<? super PhpClass> visited) {
        if (me == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(57);
        }
        if (trait == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(58);
        }
        if (!trait.isTrait()) {
            return false;
        }
        if (visited == null) {
            visited = new HashSet<PhpClass>();
        }
        for (PhpClass candidate : me.getTraits()) {
            if (!visited.add(candidate) || !PhpClassHierarchyUtils.classesEqual(trait, candidate) && !PhpClassHierarchyUtils.isMyTrait(candidate, trait, visited)) continue;
            return true;
        }
        return false;
    }

    public static boolean classesEqual(@Nullable PhpClass one, @Nullable PhpClass another) {
        if (one != null && another != null) {
            if (one == another) {
                return true;
            }
            if (one instanceof PhpClassAlias || another instanceof PhpClassAlias) {
                if (one instanceof PhpClassAlias) {
                    one = ((PhpClassAlias)one).getOriginal();
                }
                if (another instanceof PhpClassAlias) {
                    another = ((PhpClassAlias)another).getOriginal();
                }
                return PhpClassHierarchyUtils.classesEqual(one, another);
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)one.getFQN(), (CharSequence)another.getFQN())) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 30, 47, 49 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFQN";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialElement";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodProcessor";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldProcessor";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 30: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpClassHierarchyUtils";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 32: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberFounder";
                break;
            }
            case 39: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberProcessor";
                break;
            }
            case 46: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpClassHierarchyUtils";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitUseRulesConflictResolutions";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassesWithTraitUsage";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "subclassesOfBaseContainsFQN";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClasses";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processSuperTraits";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processSuperInterfaces";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processSupers";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processSuperWithoutMixins";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSuperClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processMethods";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithGenericMixins";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processFields";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processFieldsWithGenericMixins";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processMembersInternal";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processMembersInternalWithGenericMixins";
                break;
            }
            case 30: 
            case 47: 
            case 49: {
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processOverridingFields";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processOverridingMethods";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectUsedTraits";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "methodCanHaveOverride";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasSuperMethod";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processSuperMembersInternal";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processSuperMethods";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processSuperFields";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processSuperMembers";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "collectClassesWithTraitUsage";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClasses";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getDirectSubclasses";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getAllSubclasses";
                break;
            }
            case 52: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "anySubclassExists";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "subclassExists";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getObject";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isMyTrait";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 30, 47, 49 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface NextElementsAppender<T> {
        public void appendNextElements(@NotNull T var1, @NotNull Collection<? super T> var2);
    }

    public static interface TypedHierarchyMemberProcessor<T extends PhpClassMember> {
        public boolean process(T var1, PhpClass var2, PhpClass var3);
    }

    @FunctionalInterface
    public static interface HierarchyMethodProcessor
    extends TypedHierarchyMemberProcessor<Method> {
    }

    @FunctionalInterface
    public static interface HierarchyFieldProcessor
    extends TypedHierarchyMemberProcessor<Field> {
    }

    @FunctionalInterface
    public static interface HierarchyClassMemberProcessor
    extends HierarchyMemberProcessor {
        public boolean process(PhpClassMember var1, PhpClass var2, PhpClass var3);
    }

    static interface MemberFounder<T extends PhpClassMember> {
        public Collection<T> findMember(PhpClass var1, T var2, HashSet<PhpClass> var3);
    }

    private static final class CompositeNextElementsAppender<T>
    implements NextElementsAppender<T> {
        private final NextElementsAppender<T>[] myAppenders;

        private CompositeNextElementsAppender(NextElementsAppender<T> ... appenders) {
            this.myAppenders = appenders;
        }

        @Override
        public void appendNextElements(@NotNull T element, @NotNull Collection<? super T> collection) {
            if (element == null) {
                CompositeNextElementsAppender.$$$reportNull$$$0(0);
            }
            if (collection == null) {
                CompositeNextElementsAppender.$$$reportNull$$$0(1);
            }
            for (NextElementsAppender<? super T> nextElementsAppender : this.myAppenders) {
                nextElementsAppender.appendNextElements((T)element, collection);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "collection";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/PhpClassHierarchyUtils$CompositeNextElementsAppender";
            objectArray[2] = "appendNextElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface HierarchyMemberProcessor {
    }
}

