/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OptionalChooserComponent;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.WebCoreBundle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleScopeSelectionView {
    private static final String KEY_SHOW_WEB_MODULE_ONLY = ModuleScopeSelectionView.class.getName() + "#SHOW_WEB_MODULE_ONLY";
    private final JComponent myComponent;
    private final OptionalChooserComponent<Module> myMultiModulesChooser;
    private final Module myAssociateWithProjectModule;
    private final JCheckBox myAssociateWithProjectCheckBox;

    public ModuleScopeSelectionView(@NotNull Project project, @Nullable VirtualFile requestor, boolean allowAssociationWithProject, boolean withHeaderLabel) {
        if (project == null) {
            ModuleScopeSelectionView.i(0);
        }
        List<Module> list = ModuleScopeSelectionView.w(project);
        if (allowAssociationWithProject && list.size() == 1 && ModuleScopeSelectionView.i(list.get(0))) {
            this.myAssociateWithProjectModule = list.get(0);
            this.myAssociateWithProjectCheckBox = ModuleScopeSelectionView.i();
            this.myComponent = this.myAssociateWithProjectCheckBox;
            this.myMultiModulesChooser = null;
            return;
        }
        this.myAssociateWithProjectModule = null;
        this.myAssociateWithProjectCheckBox = null;
        Module module = ModuleScopeSelectionView.i(project, requestor, list);
        Pair<OptionalChooserComponent<Module>, JComponent> pair = ModuleScopeSelectionView.i(list, module, withHeaderLabel);
        this.myMultiModulesChooser = (OptionalChooserComponent)pair.getFirst();
        this.myComponent = (JComponent)pair.getSecond();
    }

    @NotNull
    private static List<Module> w(@NotNull Project project) {
        if (project == null) {
            ModuleScopeSelectionView.i(1);
        }
        List list = (List)ReadAction.compute(() -> Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).sorted(Comparator.comparing(Module::getName)).collect(Collectors.toList()));
        if (list == null) {
            ModuleScopeSelectionView.i(2);
        }
        return list;
    }

    @Nullable
    private static Module i(@NotNull Project project, @Nullable VirtualFile virtualFile, @NotNull List<Module> list) {
        if (project == null) {
            ModuleScopeSelectionView.i(3);
        }
        if (list == null) {
            ModuleScopeSelectionView.i(4);
        }
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile(virtualFile);
        return module != null && list.contains(module) ? module : null;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            ModuleScopeSelectionView.i(5);
        }
        return jComponent;
    }

    public boolean isAssociateWithProjectView() {
        return this.myAssociateWithProjectCheckBox != null;
    }

    public boolean isAssociateWithProjectRequested() {
        return this.myAssociateWithProjectCheckBox != null && this.myAssociateWithProjectCheckBox.isSelected();
    }

    @NotNull
    public List<Module> getSelectedModules() {
        if (this.myAssociateWithProjectCheckBox != null) {
            List<Module> list = this.myAssociateWithProjectCheckBox.isSelected() ? Collections.singletonList(this.myAssociateWithProjectModule) : Collections.emptyList();
            if (list == null) {
                ModuleScopeSelectionView.i(6);
            }
            return list;
        }
        return ModuleScopeSelectionView.i(this.myMultiModulesChooser);
    }

    @NotNull
    private static List<Module> i(@NotNull OptionalChooserComponent<Module> optionalChooserComponent) {
        if (optionalChooserComponent == null) {
            ModuleScopeSelectionView.i(7);
        }
        List list = ContainerUtil.mapNotNull((Collection)optionalChooserComponent.getCurrentModel(), pair -> (Boolean)pair.getSecond() != false ? (Module)pair.getFirst() : null);
        if (list == null) {
            ModuleScopeSelectionView.i(8);
        }
        return list;
    }

    public void setSelectedModules(@NotNull Set<Module> selectedModules) {
        if (selectedModules == null) {
            ModuleScopeSelectionView.i(9);
        }
        if (this.myAssociateWithProjectModule != null) {
            this.myAssociateWithProjectCheckBox.setSelected(selectedModules.contains(this.myAssociateWithProjectModule));
        } else {
            ModuleScopeSelectionView.i(this.myMultiModulesChooser, selectedModules);
        }
    }

    private static void i(@NotNull OptionalChooserComponent<Module> optionalChooserComponent, @NotNull Set<Module> set) {
        if (optionalChooserComponent == null) {
            ModuleScopeSelectionView.i(10);
        }
        if (set == null) {
            ModuleScopeSelectionView.i(11);
        }
        List list = ContainerUtil.mapNotNull((Collection)optionalChooserComponent.getCurrentModel(), pair -> Pair.create((Object)((Module)pair.first), (Object)set.contains(pair.first)));
        optionalChooserComponent.setInitialList(list);
        optionalChooserComponent.reset();
    }

    private static void i(@NotNull OptionalChooserComponent<Module> optionalChooserComponent, @NotNull List<Module> list) {
        if (optionalChooserComponent == null) {
            ModuleScopeSelectionView.i(12);
        }
        if (list == null) {
            ModuleScopeSelectionView.i(13);
        }
        HashSet<Module> hashSet = new HashSet<Module>(ModuleScopeSelectionView.i(optionalChooserComponent));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (Module module : list) {
            arrayList.add(Pair.create((Object)module, (Object)hashSet.contains(module)));
        }
        optionalChooserComponent.setInitialList(arrayList);
        optionalChooserComponent.reset();
    }

    @NotNull
    private static JCheckBox i() {
        JCheckBox jCheckBox = new JCheckBox(WebCoreBundle.message((String)"checkbox.for.the.whole.project", (Object[])new Object[0]));
        jCheckBox.setSelected(true);
        JCheckBox jCheckBox2 = jCheckBox;
        if (jCheckBox2 == null) {
            ModuleScopeSelectionView.i(14);
        }
        return jCheckBox2;
    }

    @NotNull
    private static Pair<OptionalChooserComponent<Module>, JComponent> i(@NotNull List<Module> list, @Nullable Module module2, boolean bl) {
        if (list == null) {
            ModuleScopeSelectionView.i(15);
        }
        OptionalChooserComponent<Module> optionalChooserComponent = new OptionalChooserComponent<Module>(Collections.emptyList()){

            protected JCheckBox createCheckBox(Module value, boolean checked) {
                JBCheckBox jBCheckBox = new JBCheckBox(value.getName(), checked);
                ModuleType moduleType = ModuleType.get((Module)value);
                jBCheckBox.setTextIcon(moduleType.getIcon());
                return jBCheckBox;
            }
        };
        CheckBoxList checkBoxList = optionalChooserComponent.getList();
        checkBoxList.setSelectionMode(2);
        checkBoxList.setVisibleRowCount(Math.min(6, list.size()));
        ListSpeedSearch.installOn((JList)checkBoxList, jCheckBox -> jCheckBox.getText());
        optionalChooserComponent.getEmptyText().setText(WebCoreBundle.message((String)"empty.text.no.modules.found", (Object[])new Object[0]));
        ArrayList<Component> arrayList = new ArrayList<Component>();
        if (bl) {
            arrayList.add(new JLabel(WebCoreBundle.message((String)"label.select.modules", (Object[])new Object[0])));
            arrayList.add(Box.createVerticalStrut(JBUIScale.scale((int)4)));
        }
        arrayList.add(optionalChooserComponent.getContentPane());
        boolean bl2 = false;
        List<Module> list2 = ContainerUtil.filter(list, module -> ModuleScopeSelectionView.i(module));
        if (list2.size() < list.size() && !list2.isEmpty()) {
            final PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            bl2 = propertiesComponent.getBoolean(KEY_SHOW_WEB_MODULE_ONLY);
            if (bl2 && module2 != null) {
                bl2 = ModuleScopeSelectionView.i(module2);
            }
            final JCheckBox jCheckBox2 = new JCheckBox(WebCoreBundle.message((String)"checkbox.show.web.modules.only", (Object[])new Object[0]), bl2);
            arrayList.add(Box.createVerticalStrut(JBUIScale.scale((int)4)));
            arrayList.add(jCheckBox2);
            jCheckBox2.addActionListener(new ActionListener(){
                final /* synthetic */ OptionalChooserComponent val$chooser;
                final /* synthetic */ List val$webModules;
                final /* synthetic */ List val$allModules;
                {
                    this.val$chooser = optionalChooserComponent;
                    this.val$webModules = list;
                    this.val$allModules = list2;
                }

                @Override
                public void actionPerformed(ActionEvent e2) {
                    boolean bl = jCheckBox2.isSelected();
                    propertiesComponent.setValue(KEY_SHOW_WEB_MODULE_ONLY, bl);
                    ModuleScopeSelectionView.i((OptionalChooserComponent<Module>)this.val$chooser, bl ? this.val$webModules : this.val$allModules);
                }
            });
        }
        ModuleScopeSelectionView.i(optionalChooserComponent, bl2 ? list2 : list);
        if (module2 != null) {
            ModuleScopeSelectionView.i(optionalChooserComponent, Collections.singleton(module2));
        } else if (bl2) {
            ModuleScopeSelectionView.i(optionalChooserComponent, new HashSet<Module>(list2));
        }
        Pair pair = Pair.create((Object)optionalChooserComponent, (Object)SwingHelper.newLeftAlignedVerticalPanel(arrayList));
        if (pair == null) {
            ModuleScopeSelectionView.i(16);
        }
        return pair;
    }

    private static boolean i(@NotNull Module module) {
        if (module == null) {
            ModuleScopeSelectionView.i(17);
        }
        return ModuleTypeWithWebFeatures.isAvailable((Module)module);
    }

    @NotNull
    public List<VirtualFile> getLibraryScope() {
        if (this.isAssociateWithProjectView()) {
            List<Object> list = this.isAssociateWithProjectRequested() ? Collections.singletonList(null) : Collections.emptyList();
            if (list == null) {
                ModuleScopeSelectionView.i(18);
            }
            return list;
        }
        List list = (List)ReadAction.compute(() -> {
            HashSet hashSet = new HashSet();
            for (Module module : this.getSelectedModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                VirtualFile[] virtualFileArray = moduleRootManager.getContentRoots();
                Collections.addAll(hashSet, virtualFileArray);
            }
            return new ArrayList(hashSet);
        });
        if (list == null) {
            ModuleScopeSelectionView.i(19);
        }
        return list;
    }

    private static /* synthetic */ void i(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 3;
            case 2, 5, 6, 8, 14, 16, 18, 19 -> 2;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModules";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedModules";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModules";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMultiModules";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleWebModuleComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultiModulesComponent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryScope";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllModules";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRequestingModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedMultiModules";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedModules";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedMultiModules";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setMultiModules";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createMultiModulesComponent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 8, 14, 16, 18, 19 -> new IllegalStateException(string);
        };
    }
}

