/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshException;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.osHandlers.AttachOSHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshAttachHost
extends EnvironmentAwareHost {
    private static final Logger LOG = Logger.getInstance(SshAttachHost.class);
    @NlsSafe
    @NotNull
    private final String myPresentationName;
    @NotNull
    private final RemoteCredentialsHolder myCredentials;

    public SshAttachHost(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            SshAttachHost.i(0);
        }
        this.myCredentials = new RemoteCredentialsHolder();
        this.myCredentials.copyFrom(credentials);
        this.myPresentationName = this.myCredentials.getHost() + "@" + this.myCredentials.getPort();
    }

    @NotNull
    public RemoteCredentials getCredentials() {
        RemoteCredentialsHolder remoteCredentialsHolder = this.myCredentials;
        if (remoteCredentialsHolder == null) {
            SshAttachHost.i(1);
        }
        return remoteCredentialsHolder;
    }

    private String i(@NotNull GeneralCommandLine generalCommandLine) throws ExecutionException {
        ProcessOutput processOutput;
        int n10;
        if (generalCommandLine == null) {
            SshAttachHost.i(2);
        }
        if ((n10 = (processOutput = this.getProcessOutput(generalCommandLine)).getExitCode()) != 0) {
            LOG.warn("Non-zero exit code from " + String.valueOf(generalCommandLine) + ": " + String.valueOf(processOutput));
            throw new ExecutionException(SshBundle.message((String)"dialog.message.non.zero.exit.code", (Object[])new Object[]{generalCommandLine.getCommandLineString()}));
        }
        LOG.debug("Process output: ", new Object[]{generalCommandLine, "; ", processOutput});
        return processOutput.getStdout();
    }

    @NotNull
    public final List<ProcessInfo> getProcessList() throws ExecutionException {
        List list;
        boolean bl;
        LOG.debug("Loading process list for ", new Object[]{this});
        AttachOSHandler.OSType oSType = this.getOsHandler().getOSType();
        boolean bl2 = oSType == AttachOSHandler.OSType.MACOSX;
        boolean bl3 = bl = !bl2 && oSType == AttachOSHandler.OSType.LINUX;
        if (bl2 || bl) {
            String string = this.i(new GeneralCommandLine(ProcessListUtil.COMM_LIST_COMMAND));
            String string2 = this.i(new GeneralCommandLine(ProcessListUtil.COMMAND_LIST_COMMAND));
            String string3 = this.i(new GeneralCommandLine(ProcessListUtil.PROCESS_OWNER_COMMAND));
            String string4 = StringUtil.nullize((String)this.i(new GeneralCommandLine(new String[]{"whoami"})).trim());
            list = bl2 ? ProcessListUtil.parseMacOutput((String)string, (String)string2, (String)string3, (String)string4) : ProcessListUtil.parseLinuxOutputMacStyle((String)string, (String)string2, (String)string3, (String)string4);
        } else {
            throw new ExecutionException(SshBundle.message((String)"dialog.message.error.unable.to.list.processes.for", (Object[])new Object[]{oSType}));
        }
        if (list == null) {
            throw new ExecutionException(SshBundle.message((String)"dialog.message.error.while.parsing.process.list", (Object[])new Object[0]));
        }
        LOG.debug("Loaded processlist from: ", new Object[]{this, " as ", list});
        List list2 = list;
        if (list2 == null) {
            SshAttachHost.i(3);
        }
        return list2;
    }

    @NotNull
    public BaseProcessHandler getProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            SshAttachHost.i(4);
        }
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)this.getCredentials(), null);
        try {
            SshExecProcess sshExecProcess = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withChangeDir(false).withAllocatePty(false).start();
            return new CapturingSshProcessHandler((SshProcess)sshExecProcess, null, commandLine.getCommandLineString());
        }
        catch (SshException sshException) {
            throw new ExecutionException(SshBundle.message((String)"dialog.message.failed.to.create.ssh.process", (Object[])new Object[0]), (Throwable)sshException);
        }
    }

    @Nullable
    public InputStream getFileContent(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            SshAttachHost.i(5);
        }
        try {
            SftpChannel sftpChannel = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)this.getCredentials()).openSftpChannel();
            RemoteFileObject remoteFileObject = sftpChannel.file(filePath);
            if (!remoteFileObject.exists()) {
                throw new IOException("No such file on ssh host: " + filePath);
            }
            return remoteFileObject.inputStream();
        }
        catch (SshException sshException) {
            throw new IOException("error while getting remote file content", sshException);
        }
    }

    public boolean canReadFile(@NotNull String filePath) {
        if (filePath == null) {
            SshAttachHost.i(6);
        }
        return false;
    }

    @NlsSafe
    @NotNull
    public String getFileSystemHostId() {
        String string = this.myPresentationName;
        if (string == null) {
            SshAttachHost.i(7);
        }
        return string;
    }

    public boolean isSameHost(@NotNull Object credentialsObject) {
        if (credentialsObject == null) {
            SshAttachHost.i(8);
        }
        if (!(credentialsObject instanceof RemoteCredentials)) {
            return false;
        }
        RemoteCredentials remoteCredentials = (RemoteCredentials)credentialsObject;
        return Objects.equals(this.myCredentials.getHost(), remoteCredentials.getHost());
    }

    @NotNull
    String getHost() {
        String string = this.myCredentials.getHost();
        if (string == null) {
            SshAttachHost.i(9);
        }
        return string;
    }

    int getPort() {
        return this.myCredentials.getPort();
    }

    public int hashCode() {
        return Objects.hash(this.myCredentials.getHost(), this.myCredentials.getPort(), this.myCredentials.getUserName(), this.myCredentials.getPassword());
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
            return false;
        }
        return this.isSameHost(((SshAttachHost)((Object)o2)).getCredentials());
    }

    public String toString() {
        return "SshAttachHost{myPresentationName='" + this.myPresentationName + "', myCredentials=" + String.valueOf(this.myCredentials) + ", myOsHandler=" + String.valueOf(this.getOsHandler()) + "} ";
    }

    private static /* synthetic */ void i(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 3;
            case 1, 3, 7, 9 -> 2;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/attach/SshAttachHost";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsObject";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/attach/SshAttachHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystemHostId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execAndCheckExitCode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProcessHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canReadFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSameHost";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7, 9 -> new IllegalStateException(string);
        };
    }
}

