/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.documentSymbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"symbolInformationToDocumentSymbol", "Lorg/eclipse/lsp4j/DocumentSymbol;", "info", "Lorg/eclipse/lsp4j/SymbolInformation;", "asDocumentSymbolTree", "", "infos", "i", "", "a", "Lorg/eclipse/lsp4j/Position;", "b", "w", "", "outer", "Lorg/eclipse/lsp4j/Range;", "inner", "i", "intellij.platform.lsp.impl"})
public final class ConvertersKt {
    @NotNull
    public static final DocumentSymbol symbolInformationToDocumentSymbol(@NotNull SymbolInformation info) {
        DocumentSymbol documentSymbol;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Range range = info.getLocation().getRange();
        DocumentSymbol documentSymbol2 = documentSymbol = new DocumentSymbol();
        boolean bl = false;
        documentSymbol2.setName(info.getName());
        documentSymbol2.setKind(info.getKind());
        documentSymbol2.setRange(range);
        documentSymbol2.setSelectionRange(range);
        documentSymbol2.setDetail("");
        documentSymbol2.setTags(info.getTags());
        documentSymbol2.setDeprecated(info.getDeprecated());
        documentSymbol2.setChildren((List)new ArrayList());
        return documentSymbol;
    }

    @NotNull
    public static final List<DocumentSymbol> asDocumentSymbolTree(@NotNull List<? extends SymbolInformation> infos) {
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        List list = CollectionsKt.sortedWith((Iterable)CollectionsKt.toMutableList((Collection)infos), (arg_0, arg_1) -> ConvertersKt.i(ConvertersKt::i, arg_0, arg_1));
        List list2 = new ArrayList();
        ArrayDeque arrayDeque = new ArrayDeque();
        block0: for (SymbolInformation symbolInformation : list) {
            DocumentSymbol documentSymbol = ConvertersKt.symbolInformationToDocumentSymbol(symbolInformation);
            while (true) {
                if (arrayDeque.isEmpty()) {
                    arrayDeque.addLast((Object)documentSymbol);
                    list2.add(documentSymbol);
                    continue block0;
                }
                DocumentSymbol documentSymbol2 = (DocumentSymbol)arrayDeque.last();
                Range range = documentSymbol2.getRange();
                Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
                Range range2 = documentSymbol.getRange();
                Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getRange(...)");
                if (ConvertersKt.w(range, range2)) {
                    Range range3 = documentSymbol2.getRange();
                    Intrinsics.checkNotNullExpressionValue((Object)range3, (String)"getRange(...)");
                    Range range4 = documentSymbol.getRange();
                    Intrinsics.checkNotNullExpressionValue((Object)range4, (String)"getRange(...)");
                    if (!ConvertersKt.i(range3, range4)) {
                        documentSymbol2.getChildren().add(documentSymbol);
                        arrayDeque.addLast((Object)documentSymbol);
                        continue block0;
                    }
                }
                arrayDeque.removeLast();
            }
        }
        return list2;
    }

    private static final int i(Position position, Position position2) {
        int n10 = position.getLine() - position2.getLine();
        return n10 != 0 ? n10 : position.getCharacter() - position2.getCharacter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean w(Range range, Range range2) {
        Position position = range.getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        Position position2 = range2.getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getStart(...)");
        if (ConvertersKt.i(position, position2) > 0) return false;
        Position position3 = range.getEnd();
        Intrinsics.checkNotNullExpressionValue((Object)position3, (String)"getEnd(...)");
        Position position4 = range2.getEnd();
        Intrinsics.checkNotNullExpressionValue((Object)position4, (String)"getEnd(...)");
        if (ConvertersKt.i(position3, position4) < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean i(Range range, Range range2) {
        Position position = range.getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        Position position2 = range2.getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getStart(...)");
        if (ConvertersKt.i(position, position2) != 0) return false;
        Position position3 = range.getEnd();
        Intrinsics.checkNotNullExpressionValue((Object)position3, (String)"getEnd(...)");
        Position position4 = range2.getEnd();
        Intrinsics.checkNotNullExpressionValue((Object)position4, (String)"getEnd(...)");
        if (ConvertersKt.i(position3, position4) != 0) return false;
        return true;
    }

    private static final int i(SymbolInformation symbolInformation, SymbolInformation symbolInformation2) {
        int n10;
        Position position = symbolInformation.getLocation().getRange().getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        Position position2 = symbolInformation2.getLocation().getRange().getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getStart(...)");
        int n11 = ConvertersKt.i(position, position2);
        if (n11 != 0) {
            n10 = n11;
        } else {
            Position position3 = symbolInformation2.getLocation().getRange().getEnd();
            Intrinsics.checkNotNullExpressionValue((Object)position3, (String)"getEnd(...)");
            Position position4 = symbolInformation.getLocation().getRange().getEnd();
            Intrinsics.checkNotNullExpressionValue((Object)position4, (String)"getEnd(...)");
            n10 = ConvertersKt.i(position3, position4);
        }
        return n10;
    }

    private static final int i(Function2 function2, Object object, Object object2) {
        return ((Number)function2.invoke(object, object2)).intValue();
    }
}

