/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl;

import com.intellij.openapi.graph.base.Command;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphIdentifiable;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class GraphBackupRealizersCommand
implements Command {
    @NotNull
    private final HashMap<GraphIdentifiable.Node.Identity, NodeRealizer> myUndoNodeRealizers;
    @NotNull
    private final HashMap<GraphIdentifiable.Edge.Identity, EdgeRealizer> myUndoEdgeRealizers;
    @NotNull
    private final HashMap<GraphIdentifiable.Node.Identity, NodeRealizer> myRedoNodeRealizers;
    @NotNull
    private final HashMap<GraphIdentifiable.Edge.Identity, EdgeRealizer> myRedoEdgeRealizers;
    @NotNull
    private final GraphBuilder<?, ?> myBuilder;
    @Nullable
    private final NodeCursor myNodeCursor;
    @Nullable
    private final EdgeCursor myEdgeCursor;
    private final boolean myDoAdjustSelectionState;
    @NotNull
    private final Consumer<? super Runnable> myOnUndo;
    @NotNull
    private final Consumer<? super Runnable> myOnRedo;

    GraphBackupRealizersCommand(@NotNull GraphBuilder<?, ?> builder, @Nullable NodeCursor nodeCursor, @Nullable EdgeCursor edgeCursor, boolean doAdjustSelectionState, @NotNull Consumer<? super Runnable> onUndo, @NotNull Consumer<? super Runnable> onRedo) {
        if (builder == null) {
            GraphBackupRealizersCommand.i(0);
        }
        if (onUndo == null) {
            GraphBackupRealizersCommand.i(1);
        }
        if (onRedo == null) {
            GraphBackupRealizersCommand.i(2);
        }
        this.myBuilder = builder;
        this.myDoAdjustSelectionState = doAdjustSelectionState;
        this.myNodeCursor = nodeCursor;
        this.myEdgeCursor = edgeCursor;
        this.myOnUndo = onUndo;
        this.myOnRedo = onRedo;
        int n10 = nodeCursor == null ? 0 : nodeCursor.size();
        int n11 = edgeCursor == null ? 0 : edgeCursor.size();
        this.myUndoNodeRealizers = new HashMap(2 * n10);
        this.myUndoEdgeRealizers = new HashMap(2 * n11);
        this.myRedoNodeRealizers = new HashMap(2 * n10);
        this.myRedoEdgeRealizers = new HashMap(2 * n11);
    }

    public void recordUndoRealizers() {
        this.myBuilder.getActionExecutor().suppressRunnableReadLockAssertion(() -> this.myBuilder.getActionExecutor().runReadAction(() -> this.i(this.myUndoNodeRealizers, this.myUndoEdgeRealizers)));
    }

    public void recordRedoRealizers() {
        this.i(this.myRedoNodeRealizers, this.myRedoEdgeRealizers);
    }

    private void i(@NotNull Map<GraphIdentifiable.Node.Identity, NodeRealizer> map, @NotNull Map<GraphIdentifiable.Edge.Identity, EdgeRealizer> map2) {
        Node node;
        if (map == null) {
            GraphBackupRealizersCommand.i(3);
        }
        if (map2 == null) {
            GraphBackupRealizersCommand.i(4);
        }
        this.myBuilder.getActionExecutor().assertReadAccess();
        Graph2D graph2D = this.myBuilder.getGraph();
        if (this.myNodeCursor != null) {
            this.myNodeCursor.toFirst();
            this.myNodeCursor.toFirst();
            while (this.myNodeCursor.ok()) {
                node = this.myNodeCursor.node();
                map.put(this.myBuilder.getNodeIdentity(node), graph2D.getRealizer(node).createCopy());
                this.myNodeCursor.next();
            }
        }
        if (this.myEdgeCursor != null) {
            this.myEdgeCursor.toFirst();
            while (this.myEdgeCursor.ok()) {
                node = this.myEdgeCursor.edge();
                map2.put(this.myBuilder.getEdgeIdentity((Edge)node), graph2D.getRealizer((Edge)node).createCopy());
                this.myEdgeCursor.next();
            }
        }
    }

    public void undo() {
        this.myOnUndo.accept(() -> {
            this.w(this.myUndoNodeRealizers);
            this.i(this.myUndoEdgeRealizers);
        });
    }

    public void redo() {
        this.myOnRedo.accept(() -> {
            this.w(this.myRedoNodeRealizers);
            this.i(this.myRedoEdgeRealizers);
        });
    }

    @NotNull
    public Map<GraphIdentifiable.Node.Identity, NodeRealizer> getUndoNodeIdToRealizers() {
        HashMap<GraphIdentifiable.Node.Identity, NodeRealizer> hashMap = this.myUndoNodeRealizers;
        if (hashMap == null) {
            GraphBackupRealizersCommand.i(5);
        }
        return hashMap;
    }

    @NotNull
    public Map<GraphIdentifiable.Edge.Identity, EdgeRealizer> getUndoEdgeIdToRealizers() {
        HashMap<GraphIdentifiable.Edge.Identity, EdgeRealizer> hashMap = this.myUndoEdgeRealizers;
        if (hashMap == null) {
            GraphBackupRealizersCommand.i(6);
        }
        return hashMap;
    }

    @NotNull
    public Map<GraphIdentifiable.Node.Identity, NodeRealizer> getRedoNodeIdToRealizers() {
        HashMap<GraphIdentifiable.Node.Identity, NodeRealizer> hashMap = this.myRedoNodeRealizers;
        if (hashMap == null) {
            GraphBackupRealizersCommand.i(7);
        }
        return hashMap;
    }

    @NotNull
    public Map<GraphIdentifiable.Edge.Identity, EdgeRealizer> getRedoEdgeIdToRealizers() {
        HashMap<GraphIdentifiable.Edge.Identity, EdgeRealizer> hashMap = this.myRedoEdgeRealizers;
        if (hashMap == null) {
            GraphBackupRealizersCommand.i(8);
        }
        return hashMap;
    }

    public @Unmodifiable @NotNull Map<Node, NodeRealizer> getUndoNodeToRealizers(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphBackupRealizersCommand.i(9);
        }
        return GraphBackupRealizersCommand.i(builder, this.getUndoNodeIdToRealizers());
    }

    public @Unmodifiable @NotNull Map<Edge, EdgeRealizer> getUndoEdgeToRealizers(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphBackupRealizersCommand.i(10);
        }
        return GraphBackupRealizersCommand.w(builder, this.getUndoEdgeIdToRealizers());
    }

    public @Unmodifiable @NotNull Map<Node, NodeRealizer> getRedoNodeToRealizers(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphBackupRealizersCommand.i(11);
        }
        return GraphBackupRealizersCommand.i(builder, this.getRedoNodeIdToRealizers());
    }

    public @Unmodifiable @NotNull Map<Edge, EdgeRealizer> getRedoEdgeToRealizers(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphBackupRealizersCommand.i(12);
        }
        return GraphBackupRealizersCommand.w(builder, this.getRedoEdgeIdToRealizers());
    }

    private static @Unmodifiable @NotNull Map<Node, NodeRealizer> i(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull Map<GraphIdentifiable.Node.Identity, NodeRealizer> map) {
        if (graphBuilder == null) {
            GraphBackupRealizersCommand.i(13);
        }
        if (map == null) {
            GraphBackupRealizersCommand.i(14);
        }
        Map map2 = GraphIdentifiable.Node.findNodesByIds(graphBuilder, map.keySet());
        Map map3 = ContainerUtil.map2Map(map2.entrySet(), entry -> Pair.create((Object)((Node)entry.getValue()), (Object)((NodeRealizer)map.get(entry.getKey()))));
        if (map3 == null) {
            GraphBackupRealizersCommand.i(15);
        }
        return map3;
    }

    private static @Unmodifiable @NotNull Map<Edge, EdgeRealizer> w(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull Map<GraphIdentifiable.Edge.Identity, EdgeRealizer> map) {
        if (graphBuilder == null) {
            GraphBackupRealizersCommand.i(16);
        }
        if (map == null) {
            GraphBackupRealizersCommand.i(17);
        }
        Map map2 = GraphIdentifiable.Edge.findEdgesByIds(graphBuilder, map.keySet());
        Map map3 = ContainerUtil.map2Map(map2.entrySet(), entry -> Pair.create((Object)((Edge)entry.getValue()), (Object)((EdgeRealizer)map.get(entry.getKey()))));
        if (map3 == null) {
            GraphBackupRealizersCommand.i(18);
        }
        return map3;
    }

    private void w(@NotNull Map<GraphIdentifiable.Node.Identity, NodeRealizer> map) {
        if (map == null) {
            GraphBackupRealizersCommand.i(19);
        }
        Map map2 = GraphIdentifiable.Node.findNodesByIds(this.myBuilder, map.keySet());
        map.forEach((identity, nodeRealizer) -> {
            Node node = (Node)map2.get(identity);
            if (node == null) {
                return;
            }
            NodeRealizer nodeRealizer2 = this.myBuilder.getGraph().getRealizer(node);
            if (this.myDoAdjustSelectionState) {
                nodeRealizer.setSelected(nodeRealizer2.isSelected());
            }
            this.myBuilder.setNodeRealizer(node, nodeRealizer);
        });
    }

    private void i(@NotNull Map<GraphIdentifiable.Edge.Identity, EdgeRealizer> map) {
        if (map == null) {
            GraphBackupRealizersCommand.i(20);
        }
        Map map2 = GraphIdentifiable.Edge.findEdgesByIds(this.myBuilder, map.keySet());
        map.forEach((identity, edgeRealizer) -> {
            Edge edge = (Edge)map2.get(identity);
            if (edge == null) {
                return;
            }
            EdgeRealizer edgeRealizer2 = this.myBuilder.getGraph().getRealizer(edge);
            if (this.myDoAdjustSelectionState) {
                edgeRealizer.setSelected(edgeRealizer2.isSelected());
            }
            this.myBuilder.setEdgeRealizer(edge, edgeRealizer);
        });
    }

    private static /* synthetic */ void i(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 3;
            case 5, 6, 7, 8, 15, 18 -> 2;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUndo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onRedo";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeRealizers";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeRealizers";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/GraphBackupRealizersCommand";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToRealizers";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/GraphBackupRealizersCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoNodeIdToRealizers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoEdgeIdToRealizers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedoNodeIdToRealizers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedoEdgeIdToRealizers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeNodeToRealizerMap";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeEdgeToRealizerMap";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recordRealizersTo";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUndoNodeToRealizers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUndoEdgeToRealizers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRedoNodeToRealizers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRedoEdgeToRealizers";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeNodeToRealizerMap";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeEdgeToRealizerMap";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "swapNodeRealizers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "swapEdgeRealizers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 15, 18 -> new IllegalStateException(string);
        };
    }
}

