/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.jetbrains.annotations.NonNls;

public class MergedFileParser {
    private final StringBuffer myOriginal = new StringBuffer();
    private final StringBuffer myLocal = new StringBuffer();
    private final StringBuffer myLast = new StringBuffer();
    private final String mySource;
    @NonNls
    private static final String ORIGINAL_PREFIX = ">>>> ORIGINAL";
    @NonNls
    private static final String YOURS_PREFIX = "==== YOURS";
    @NonNls
    private static final String THEIRS_PREFIX = "==== THEIRS";

    public MergedFileParser(String dataWithMarkers) throws IOException {
        this.mySource = dataWithMarkers;
        this.process();
    }

    public String getOriginal() {
        return this.myOriginal.toString();
    }

    public String getLocal() {
        return this.myLocal.toString();
    }

    public String getLast() {
        return this.myLast.toString();
    }

    private void process() throws IOException {
        StringReader stringReader = new StringReader(this.mySource);
        try (LineNumberReader lineNumberReader = new LineNumberReader(stringReader);){
            String line;
            StringBuffer current = null;
            while ((line = lineNumberReader.readLine()) != null) {
                if (line.startsWith(ORIGINAL_PREFIX)) {
                    current = this.myOriginal;
                    continue;
                }
                if (line.startsWith(YOURS_PREFIX)) {
                    current = this.myLocal;
                    continue;
                }
                if (line.startsWith(THEIRS_PREFIX)) {
                    current = this.myLast;
                    continue;
                }
                if (line.startsWith("<<<<") && current != null) {
                    current = null;
                    continue;
                }
                if (current != null) {
                    current.append(line + "\n");
                    continue;
                }
                this.myOriginal.append(line + "\n");
                this.myLocal.append(line + "\n");
                this.myLast.append(line + "\n");
            }
        }
    }
}

