/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinLanguage;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

@NotNullByDefault
public final class GherkinChangeUtil {
    private GherkinChangeUtil() {
    }

    public static GherkinStep createStep(String text, GherkinFile gherkinFile, Project project) {
        String localeLanguage = gherkinFile.getLocaleLanguage();
        GherkinKeywordProvider provider = JsonGherkinKeywordProvider.getKeywordProvider((PsiElement)gherkinFile);
        GherkinKeywordTable table = provider.getKeywordsTable(localeLanguage);
        String featureWord = table.getFeaturesSectionKeywords().iterator().next();
        String scenarioWord = table.getScenarioKeywords().iterator().next();
        String dummyFileText = String.format("#language: %s\n%s: Dummy\n  %s: Dummy\n    ", localeLanguage, featureWord, scenarioWord) + text;
        GherkinFile dummyFile = GherkinChangeUtil.createDummyFile(project, dummyFileText);
        GherkinFeature feature = (GherkinFeature)PsiTreeUtil.getChildOfType((PsiElement)dummyFile, GherkinFeature.class);
        if (feature == null) {
            throw new IllegalStateException("feature must not be null");
        }
        GherkinScenario scenario = (GherkinScenario)PsiTreeUtil.getChildOfType((PsiElement)feature, GherkinScenario.class);
        if (scenario == null) {
            throw new IllegalStateException("scenario must not be null");
        }
        GherkinStep step = (GherkinStep)PsiTreeUtil.getChildOfType((PsiElement)scenario, GherkinStep.class);
        if (step == null) {
            throw new IllegalStateException("step must not be null");
        }
        return step;
    }

    private static GherkinFile createDummyFile(Project project, String text) {
        String fileName = "dummy." + GherkinFileType.INSTANCE.getDefaultExtension();
        return (GherkinFile)PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, (Language)GherkinLanguage.INSTANCE, (CharSequence)text);
    }
}

