/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinHighlighter;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinLexer;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

public class GherkinSyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    private final GherkinKeywordProvider myKeywordProvider;

    public GherkinSyntaxHighlighter(GherkinKeywordProvider keywordProvider) {
        this.myKeywordProvider = keywordProvider;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new GherkinLexer(this.myKeywordProvider);
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = GherkinSyntaxHighlighter.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            GherkinSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    static {
        Arrays.stream(GherkinTokenTypes.KEYWORDS.getTypes()).forEach(p -> ATTRIBUTES.put((IElementType)p, GherkinHighlighter.KEYWORD));
        ATTRIBUTES.put(GherkinTokenTypes.COMMENT, GherkinHighlighter.COMMENT);
        ATTRIBUTES.put(GherkinTokenTypes.TEXT, GherkinHighlighter.TEXT);
        ATTRIBUTES.put(GherkinTokenTypes.TAG, GherkinHighlighter.TAG);
        ATTRIBUTES.put(GherkinTokenTypes.PYSTRING, GherkinHighlighter.PYSTRING);
        ATTRIBUTES.put(GherkinTokenTypes.PYSTRING_TEXT, GherkinHighlighter.PYSTRING);
        ATTRIBUTES.put(GherkinTokenTypes.TABLE_CELL, GherkinHighlighter.TABLE_CELL);
        ATTRIBUTES.put(GherkinTokenTypes.PIPE, GherkinHighlighter.PIPE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinSyntaxHighlighter", "getTokenHighlights"));
    }
}

