/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.PlainGherkinKeywordProvider;

public final class GherkinKeywordList {
    private static final Collection<String> GHERKIN_LANGUAGE_META_ATTRIBUTES = Arrays.asList("name", "native", "encoding");
    private final Map<String, String> myKeyword2BaseNameTable;
    private final Set<String> mySpaceAfterKeywords;
    private final GherkinKeywordTable myKeywordsTable;

    public GherkinKeywordList() {
        this.myKeyword2BaseNameTable = new HashMap<String, String>();
        this.mySpaceAfterKeywords = new HashSet<String>();
        this.myKeywordsTable = new GherkinKeywordTable();
    }

    public GherkinKeywordList(@NotNull Map<String, Object> map) {
        if (map == null) {
            GherkinKeywordList.$$$reportNull$$$0(0);
        }
        this.myKeyword2BaseNameTable = new HashMap<String, String>();
        this.mySpaceAfterKeywords = new HashSet<String>();
        this.myKeywordsTable = new GherkinKeywordTable();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            String key = e.getKey();
            if (GHERKIN_LANGUAGE_META_ATTRIBUTES.contains(key)) continue;
            List values = (List)e.getValue();
            String[] translatedKeywords = ArrayUtil.toStringArray((Collection)values);
            String keyword = GherkinKeywordList.capitalizeAndFixSpace(key);
            IElementType type = GherkinKeywordList.getTokenTypeByBaseKeyword(keyword);
            for (String translatedKeyword : translatedKeywords) {
                if (translatedKeyword.endsWith(" ")) {
                    translatedKeyword = translatedKeyword.substring(0, translatedKeyword.length() - 1);
                    this.mySpaceAfterKeywords.add(translatedKeyword);
                }
                this.myKeyword2BaseNameTable.put(translatedKeyword, keyword);
                this.myKeywordsTable.put(type, translatedKeyword);
            }
        }
    }

    @NotNull
    private static String capitalizeAndFixSpace(@NotNull String s) {
        if (s == null) {
            GherkinKeywordList.$$$reportNull$$$0(1);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
            }
            if (Character.isUpperCase(c) && i > 0) {
                result.append(' ');
            }
            result.append(c);
        }
        String string = result.toString();
        if (string == null) {
            GherkinKeywordList.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Collection<String> getAllKeywords() {
        return this.myKeyword2BaseNameTable.keySet();
    }

    public GherkinKeywordTable getKeywordsTable() {
        return this.myKeywordsTable;
    }

    public boolean isSpaceAfterKeyword(String keyword) {
        return this.mySpaceAfterKeywords.contains(keyword);
    }

    public IElementType getTokenType(String keyword) {
        return GherkinKeywordList.getTokenTypeByBaseKeyword(this.getBaseKeyword(keyword));
    }

    private static IElementType getTokenTypeByBaseKeyword(String baseKeyword) {
        return PlainGherkinKeywordProvider.DEFAULT_KEYWORDS.get(baseKeyword);
    }

    public String getBaseKeyword(String keyword) {
        return this.myKeyword2BaseNameTable.get(keyword);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/GherkinKeywordList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/GherkinKeywordList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeAndFixSpace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeAndFixSpace";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

