/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public class RemoveTableColumnFix
implements LocalQuickFix {
    private final int myColumnIndex;

    public RemoveTableColumnFix(int columnIndex) {
        this.myColumnIndex = columnIndex;
    }

    @NotNull
    public String getName() {
        String string = CucumberBundle.message("intention.name.remove.unused.column", new Object[0]);
        if (string == null) {
            RemoveTableColumnFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return "RemoveTableColumnFix";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        GherkinTable table;
        if (project == null) {
            RemoveTableColumnFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            RemoveTableColumnFix.$$$reportNull$$$0(2);
        }
        if ((table = (GherkinTable)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor.getPsiElement()), GherkinTable.class)) == null) {
            return;
        }
        GherkinTableRow headerRow = table.getHeaderRow();
        if (headerRow != null) {
            headerRow.deleteCell(this.myColumnIndex);
        }
        for (GherkinTableRow row : table.getDataRows()) {
            row.deleteCell(this.myColumnIndex);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/RemoveTableColumnFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/RemoveTableColumnFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

