/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.codeinsight;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

@NotNullByDefault
public final class CucumberEnterHandler
implements EnterHandlerDelegate {
    public static final String PYSTRING_QUOTES = "\"\"\"";

    public EnterHandlerDelegate.Result preprocessEnter(PsiFile file, Editor editor, Ref<Integer> caretOffset, Ref<Integer> caretAdvance, DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        if (!(file instanceof GherkinFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffsetValue = (Integer)caretOffset.get();
        if (caretOffsetValue < 3) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        String docText = document.getText();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement probableQuotes = file.findElementAt(caretOffsetValue - 1);
        if (probableQuotes != null && probableQuotes.getNode().getElementType() == GherkinTokenTypes.PYSTRING) {
            PsiElement probablePyStringText;
            PsiElement psiElement = probablePyStringText = document.getTextLength() == PYSTRING_QUOTES.length() ? null : file.findElementAt(caretOffsetValue - 1 - PYSTRING_QUOTES.length());
            if (probablePyStringText == null || probablePyStringText.getNode().getElementType() != GherkinTokenTypes.PYSTRING_TEXT) {
                int line = document.getLineNumber(caretOffsetValue);
                int lineStart = document.getLineStartOffset(line);
                int textStart = CharArrayUtil.shiftForward((CharSequence)docText, (int)lineStart, (String)" \t");
                String space = docText.subSequence(lineStart, textStart).toString();
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)("\n" + space + "\n" + space + PYSTRING_QUOTES));
                editor.getCaretModel().moveCaretRelatively(-3, -1, false, false, true);
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }
}

