/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.jetbrains.php.injection.PhpInjectionUtil;
import com.jetbrains.php.joomla.injection.JDatabaseQueryInjector;
import com.jetbrains.php.joomla.injection.builder.JDatabaseQuery;
import com.jetbrains.php.joomla.injection.builder.JDbQueryAnalyzer;
import com.jetbrains.php.joomla.injection.builder.methodHandler.ColumnsMethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.DeleteMethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.FromMethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.GroupMethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.InsertMethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.MethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.OrderMethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.SelectMethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.SetMethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.UpdateMethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.ValuesMethodHandler;
import com.jetbrains.php.joomla.injection.builder.methodHandler.WhereColumnHandler;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JoomlaInjectionInternalFragmentSubstProvider {
    private static final Collection<MethodHandler> databaseMethodHandlers = Arrays.asList(new ColumnsMethodHandler(), new DeleteMethodHandler(), new FromMethodHandler(), new GroupMethodHandler(), new InsertMethodHandler(), new OrderMethodHandler(), new SelectMethodHandler(), new SetMethodHandler(), new UpdateMethodHandler(), new ValuesMethodHandler(), new WhereColumnHandler());

    @Nullable
    public static Collection<PhpInjectionUtil.PhpInjectionInfo> getInternalFragmentsSubstitutions(@NotNull PhpInjectionUtil.PhpInjectionInfo injectionInfo, @NotNull Language language) {
        Project project;
        JoomlaDataService service;
        if (injectionInfo == null) {
            JoomlaInjectionInternalFragmentSubstProvider.$$$reportNull$$$0(0);
        }
        if (language == null) {
            JoomlaInjectionInternalFragmentSubstProvider.$$$reportNull$$$0(1);
        }
        if (!(service = JoomlaDataService.getInstance(project = injectionInfo.getHost().getProject())).isEnabled()) {
            return null;
        }
        int originalStartOffset = injectionInfo.getRange().getStartOffset();
        if (language.getDisplayName().contains("SQL")) {
            String text = injectionInfo.getRange().substring(injectionInfo.getHost().getText());
            int prefixIndex = text.indexOf("#__");
            MethodReference methodReference = JoomlaInjectionInternalFragmentSubstProvider.getQueryBuilderReference((PsiElement)injectionInfo.getHost());
            if (prefixIndex == -1 && methodReference == null) {
                return null;
            }
            String queryBuilderPrefix = "";
            String queryBuilderSuffix = "";
            if (methodReference != null) {
                JDatabaseQuery query = JDbQueryAnalyzer.INSTANCE.doQuery(methodReference);
                queryBuilderPrefix = JoomlaInjectionInternalFragmentSubstProvider.generateWrappingString(methodReference, handler -> handler.getPrefix(query));
                queryBuilderSuffix = JoomlaInjectionInternalFragmentSubstProvider.generateWrappingString(methodReference, handler -> handler.getSuffix(query));
            }
            SmartList toReturn = new SmartList();
            int chunkStartOffset = 0;
            String externalPrefix = injectionInfo.getPrefix();
            while (prefixIndex >= 0) {
                toReturn.add(new PhpInjectionUtil.PhpInjectionInfo(queryBuilderPrefix + externalPrefix, JoomlaDataService.getDbPrefix(project), injectionInfo.getHost(), new TextRange(chunkStartOffset, prefixIndex).shiftRight(originalStartOffset)));
                queryBuilderPrefix = "";
                externalPrefix = "";
                chunkStartOffset = prefixIndex + "#__".length();
                prefixIndex = text.indexOf("#__", chunkStartOffset);
            }
            String concatenatedSuffix = injectionInfo.getSuffix() + queryBuilderSuffix;
            toReturn.add(new PhpInjectionUtil.PhpInjectionInfo(queryBuilderPrefix, concatenatedSuffix, injectionInfo.getHost(), TextRange.create((int)(chunkStartOffset + originalStartOffset), (int)injectionInfo.getRange().getEndOffset())));
            return toReturn;
        }
        return null;
    }

    private static MethodReference getQueryBuilderReference(PsiElement psi) {
        String name;
        MethodReference memberReference;
        MethodReference methodReference = JDatabaseQueryInjector.getJDatabaseQueryUsage(psi);
        if (methodReference == null && (memberReference = JDatabaseQueryInjector.getJDatabaseDriverUsage(psi)) != null && (name = memberReference.getName()) != null && StringUtil.findIgnoreCase((String)name, (String[])new String[]{"quote", "quoteName", "qn"})) {
            methodReference = JDatabaseQueryInjector.getJDatabaseQueryUsage((PsiElement)memberReference);
        }
        return methodReference;
    }

    private static String generateWrappingString(@NotNull MethodReference methodReference, Function<MethodHandler, String> handlerConsumer) {
        String methodName;
        if (methodReference == null) {
            JoomlaInjectionInternalFragmentSubstProvider.$$$reportNull$$$0(2);
        }
        if ((methodName = methodReference.getName()) == null) {
            return "";
        }
        for (MethodHandler databaseMethodHandler : databaseMethodHandlers) {
            if (!databaseMethodHandler.getMethodName().equalsIgnoreCase(methodName)) continue;
            return handlerConsumer.apply(databaseMethodHandler);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/joomla/injection/JoomlaInjectionInternalFragmentSubstProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInternalFragmentsSubstitutions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateWrappingString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

