/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.generation;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.JoomlaExtensionType;
import com.jetbrains.php.joomla.generation.JoomlaProjectGeneratorSettings;
import com.jetbrains.php.joomla.generation.JoomlaProjectPeer;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import icons.JoomlaIcons;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JoomlaGithubProjectGenerator
extends WebProjectTemplate<JoomlaProjectGeneratorSettings> {
    public static final String LEFT_SQUARE_BRACKET = "\\[";
    private static final Logger LOG = Logger.getInstance(JoomlaGithubProjectGenerator.class);
    private static final String RIGHT_SQUARE_BRACKET = "]";

    private static void showErrorMessage(@NotNull String message) {
        if (message == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(0);
        }
        Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Joomla! integration", (String)JoomlaBundle.message("joomla.plugin.extension.generator", new Object[0])), JoomlaBundle.message("joomla.plugin.extension.generator", new Object[0]), JoomlaBundle.message("joomla.plugin.error.creating.joomla.extension.0", message), NotificationType.ERROR));
    }

    private static void replaceInCode(@NotNull Project project, @NonNls String directoryName, @NotNull ProjectFileIndex index, @NotNull VirtualFile moduleFolder, @NotNull String prefix) {
        if (project == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(1);
        }
        if (index == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(2);
        }
        if (moduleFolder == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(4);
        }
        index.iterateContent(fileOrDir -> {
            Document document;
            if (!fileOrDir.isDirectory() && fileOrDir.getPath().startsWith(moduleFolder.getPath()) && (document = FileDocumentManager.getInstance().getDocument(fileOrDir)) != null) {
                String documentText = document.getText();
                documentText = documentText.replaceAll(StringUtil.toLowerCase((String)prefix), directoryName);
                documentText = documentText.replaceAll(StringUtil.toUpperCase((String)prefix), StringUtil.toUpperCase((String)directoryName));
                char firstChar = directoryName.charAt(0);
                char upperCase = Character.toUpperCase(firstChar);
                documentText = documentText.replaceAll(prefix, upperCase + directoryName.substring(1));
                FileTemplateManager manager = FileTemplateManager.getInstance((Project)project);
                Properties properties = manager.getDefaultProperties();
                documentText = JoomlaGithubProjectGenerator.convertProperty(documentText, properties, "DATE");
                documentText = JoomlaGithubProjectGenerator.convertProperty(documentText, properties, "PROJECT_NAME");
                documentText = JoomlaGithubProjectGenerator.convertProperty(documentText, properties, "AUTHOR", "USER");
                documentText = JoomlaGithubProjectGenerator.setTag(documentText, "AUTHOR_EMAIL", "your@email.com");
                documentText = JoomlaGithubProjectGenerator.setTag(documentText, "AUTHOR_URL", "http://your.url.com");
                documentText = JoomlaGithubProjectGenerator.setTag(documentText, "COPYRIGHT", "A copyright");
                String finalText = documentText = JoomlaGithubProjectGenerator.setTag(documentText, "PACKAGE_NAME", project.getName());
                ApplicationManager.getApplication().runWriteAction(() -> {
                    document.setText((CharSequence)finalText);
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                });
            }
            return true;
        });
    }

    private static String setTag(String documentText, String email, String replacement) {
        return documentText.replaceAll(LEFT_SQUARE_BRACKET + email + RIGHT_SQUARE_BRACKET, replacement);
    }

    private static String convertProperty(String documentText, Properties properties, String arg) {
        return documentText.replaceAll(LEFT_SQUARE_BRACKET + arg + RIGHT_SQUARE_BRACKET, properties.getProperty(arg));
    }

    private static String convertProperty(String documentText, Properties properties, String arg, String property) {
        return documentText.replaceAll(LEFT_SQUARE_BRACKET + arg + RIGHT_SQUARE_BRACKET, properties.getProperty(property));
    }

    public static void performFilesRename(String directoryName, @NotNull File virtualToIoFile, @NotNull String prefix) throws IOException {
        if (virtualToIoFile == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(6);
        }
        JoomlaGithubProjectGenerator.renameAllInDirectory(directoryName, virtualToIoFile, prefix);
    }

    private static void renameAllInDirectory(String directoryName, @NotNull File directory, @NotNull String prefix) throws IOException {
        File[] children;
        if (directory == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(8);
        }
        if ((children = directory.listFiles()) != null) {
            for (File iterator : children) {
                if (iterator.isDirectory()) {
                    JoomlaGithubProjectGenerator.renameAllInDirectory(directoryName, iterator, prefix);
                }
                JoomlaGithubProjectGenerator.renameFile(directoryName, iterator, prefix);
            }
        }
    }

    private static void renameFile(String directoryName, File iterator, @NotNull String prefix) throws IOException {
        if (prefix == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(9);
        }
        String lowerCasePrefix = StringUtil.toLowerCase((String)prefix);
        String uppercasePrefix = StringUtil.toUpperCase((String)prefix);
        String fileName = iterator.getName();
        if (fileName.contains(lowerCasePrefix)) {
            FileUtil.rename((File)iterator, (String)fileName.replaceAll(lowerCasePrefix, directoryName));
        }
        if (fileName.contains(uppercasePrefix)) {
            FileUtil.rename((File)iterator, (String)fileName.replaceAll(uppercasePrefix, StringUtil.toUpperCase((String)directoryName)));
        }
        if (fileName.contains(prefix)) {
            char firstChar = directoryName.charAt(0);
            char upperCase = Character.toUpperCase(firstChar);
            FileUtil.rename((File)iterator, (String)fileName.replaceAll(prefix, upperCase + directoryName.substring(1)));
        }
    }

    @NotNull
    public String getGithubUserName() {
        return "joomla-extensions";
    }

    @NotNull
    public String getGithubRepositoryName() {
        return "boilerplate";
    }

    public String getId() {
        return "Joomla";
    }

    @Nls
    @NotNull
    public String getName() {
        String string = JoomlaBundle.message("joomla.plugin.extension.generator", new Object[0]);
        if (string == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return JoomlaBundle.message("project.generator.for.joomla.extensions.br", new Object[0]);
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull JoomlaProjectGeneratorSettings settings, @NotNull Module module) {
        if (project == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(11);
        }
        if (baseDir == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(12);
        }
        if (settings == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(13);
        }
        if (module == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(14);
        }
        JoomlaDataService dataService = JoomlaDataService.getInstance(project);
        dataService.setState(settings.getJoomlaState());
        if (!settings.getJoomlaState().getJoomlaExtensionType().equals((Object)JoomlaExtensionType.EMPTY_PROJECT)) {
            this.generateProjectFromGithubBoilerplates(project, baseDir, settings);
        }
    }

    private void generateProjectFromGithubBoilerplates(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull JoomlaProjectGeneratorSettings settings) {
        if (project == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(15);
        }
        if (baseDir == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(16);
        }
        if (settings == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(17);
        }
        File zipArchiveFile = null;
        File tempDirectory = null;
        try {
            zipArchiveFile = GithubDownloadUtil.findCacheFile((String)this.getGithubUserName(), (String)this.getGithubRepositoryName(), (String)("joomla-" + this.getGithubRepositoryName() + ".zip"));
            String url = GithubProjectGeneratorPeer.getGithubZipballUrl((String)this.getGithubUserName(), (String)this.getGithubRepositoryName(), (String)"2019.3");
            GithubDownloadUtil.downloadContentToFileWithProgressSynchronously((Project)project, (String)url, (String)this.getName(), (File)zipArchiveFile, (String)this.getGithubUserName(), (String)this.getGithubRepositoryName(), (boolean)false);
            String directoryName = baseDir.getName();
            LOG.info("Content of " + url + " has been successfully downloaded to " + zipArchiveFile.getAbsolutePath() + ", size " + zipArchiveFile.length() + " bytes");
            File baseDirVirtualFile = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
            tempDirectory = FileUtil.createTempDirectory((String)"joomla", (String)"tmp");
            ZipUtil.unzipWithProgressSynchronously((Project)project, (String)this.getName(), (File)zipArchiveFile, (File)tempDirectory, null, (boolean)true);
            String prefix = JoomlaGithubProjectGenerator.tryReadPrefixFromFile(tempDirectory);
            File[] boilerPlateFolderFiles = tempDirectory.listFiles(e -> e.getName().equals(JoomlaGithubProjectGenerator.getExtensionsBoilerplateFolder()));
            List<File> children = null;
            if (boilerPlateFolderFiles != null && boilerPlateFolderFiles.length > 0) {
                children = JoomlaGithubProjectGenerator.getExtensionFiles(boilerPlateFolderFiles[0], settings.getJoomlaState().getJoomlaExtensionType());
                File[] licenses = tempDirectory.listFiles(e -> e.getName().equals("LICENSE"));
                if (children != null && licenses != null && licenses.length > 0) {
                    children.add(licenses[0]);
                }
            }
            if (children == null || children.isEmpty()) {
                throw new GeneratorException(JoomlaBundle.message("dialog.message.boilerplates.are.downloaded", new Object[0]));
            }
            for (File it : children) {
                if (it.getName().equals(settings.getJoomlaState().getJoomlaExtensionType().getFolderName()) && it.isDirectory()) {
                    FileUtil.copyDirContent((File)it, (File)baseDirVirtualFile);
                    continue;
                }
                FileUtil.copyFileOrDir((File)it, (File)new File(baseDirVirtualFile, it.getName()));
            }
            FileUtil.delete((File)tempDirectory);
            JoomlaGithubProjectGenerator.performFilesRename(directoryName, baseDirVirtualFile, prefix);
            FileBasedIndex.getInstance().requestReindex(baseDir);
            ApplicationManager.getApplication().runWriteAction(() -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                VirtualFileManager.getInstance().refreshWithoutFileWatcher(false);
            });
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
            JoomlaGithubProjectGenerator.replaceInCode(project, directoryName, index, baseDir, prefix);
        }
        catch (Exception e2) {
            Messages.showErrorDialog((Project)project, (String)JoomlaBundle.message("joomla.error.creating.joomla.plugin.0", e2.getMessage()), (String)JoomlaBundle.message("joomla.create.joomla.plugin", new Object[0]));
            if (zipArchiveFile != null) {
                FileUtil.delete((File)zipArchiveFile);
            }
            if (tempDirectory != null) {
                FileUtil.delete(tempDirectory);
            }
            LOG.warn((Throwable)e2);
            JoomlaGithubProjectGenerator.showErrorMessage(e2.getMessage());
        }
    }

    @NotNull
    private static String getExtensionsBoilerplateFolder() {
        return "src";
    }

    private static List<File> getExtensionFiles(File boilerplateFolder, JoomlaExtensionType type) {
        ArrayList<File> children = null;
        File[] filesToCopy = boilerplateFolder.listFiles(e -> e.isDirectory() && e.getName().equals(type.getFolderName()));
        if (filesToCopy != null) {
            if (type == JoomlaExtensionType.PLUGIN && filesToCopy.length == 1) {
                filesToCopy = filesToCopy[0].listFiles(e -> e.getName().equals("system"));
            }
            if ((filesToCopy = filesToCopy[0].listFiles()) != null) {
                children = new ArrayList<File>(Arrays.asList(filesToCopy));
            }
        }
        return children;
    }

    private static String tryReadPrefixFromFile(File tempDirectory) throws IOException {
        Optional<File> prefixFile;
        String prefix = "Foo";
        File[] listFiles = tempDirectory.listFiles();
        if (listFiles != null && (prefixFile = Arrays.stream(listFiles).filter(e -> e.getName().equals(".prefix")).findFirst()).isPresent()) {
            File file = prefixFile.get();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                prefix = bufferedReader.readLine();
            }
        }
        return prefix;
    }

    @NotNull
    public ProjectGeneratorPeer<JoomlaProjectGeneratorSettings> createPeer() {
        return new JoomlaProjectPeer();
    }

    public Icon getIcon() {
        return JoomlaIcons.Joomla;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFolder";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualToIoFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/joomla/generation/JoomlaGithubProjectGenerator";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/joomla/generation/JoomlaGithubProjectGenerator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceInCode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performFilesRename";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renameAllInDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateProjectFromGithubBoilerplates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

