/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.php.performanceTesting;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.FutureResult;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.php.lang.PhpFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRefactoringTestCommand
extends AbstractCommand {
    protected ActionCallback profilerStopper;
    protected Random random;
    private static final int SECONDS_TO_WAIT_ANALYSE = 60;
    private static final Logger LOG = Logger.getInstance(AbstractRefactoringTestCommand.class);
    public static final HighlightSeverity MIN_SEVERITY = HighlightSeverity.WARNING;

    public AbstractRefactoringTestCommand(@NotNull String text, int line) {
        if (text == null) {
            AbstractRefactoringTestCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.profilerStopper = new ActionCallbackProfilerStopper();
    }

    protected List<VirtualFile> getPhpFiles(@NotNull PlaybackContext context) {
        if (context == null) {
            AbstractRefactoringTestCommand.$$$reportNull$$$0(1);
        }
        return (List)ReadAction.compute(() -> new ArrayList(FileTypeIndex.getFiles((FileType)PhpFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)context.getProject()))));
    }

    protected Editor getEditor(Project project, VirtualFile file) {
        FutureResult openFileEditorFuture = new FutureResult();
        ApplicationManager.getApplication().invokeLater(() -> {
            FileEditorManager.getInstance((Project)project).openFile(file, true);
            openFileEditorFuture.set((Object)FileEditorManager.getInstance((Project)project).getSelectedTextEditor());
        });
        try {
            return (Editor)openFileEditorFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected int countProjectErrors(Editor editor, Project project) {
        return (Integer)ReadAction.compute(() -> DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)MIN_SEVERITY, (Project)project).size());
    }

    protected static void rollBackChanges(@NotNull Project project, @NotNull PsiFile psiFile) {
        if (project == null) {
            AbstractRefactoringTestCommand.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            AbstractRefactoringTestCommand.$$$reportNull$$$0(3);
        }
        List editors = (List)WriteAction.computeAndWait(() -> FileEditorManager.getInstance((Project)project).getEditorList(psiFile.getVirtualFile()));
        boolean defaultNeverAskUser = UndoManagerImpl.ourNeverAskUser;
        UndoManagerImpl.ourNeverAskUser = true;
        for (FileEditor editor : editors) {
            if (!Objects.equals(editor.getFile(), psiFile.getVirtualFile())) continue;
            ApplicationManager.getApplication().invokeAndWait(() -> UndoManager.getInstance((Project)project).undo(editor));
        }
        UndoManagerImpl.ourNeverAskUser = defaultNeverAskUser;
    }

    protected void waitTillAnalysisIsDone(final PsiFile psiFile, final Project project) {
        final CountDownLatch fileAnalysisLatch = new CountDownLatch(1);
        final Disposable fileAnalysisDisposable = Disposer.newDisposable();
        project.getMessageBus().connect(fileAnalysisDisposable).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

            public void daemonFinished(@NotNull Collection<? extends FileEditor> incomingFileEditors) {
                if (incomingFileEditors == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((DaemonCodeAnalyzerEx)DaemonCodeAnalyzer.getInstance((Project)project)).isErrorAnalyzingFinished(psiFile)) {
                    fileAnalysisLatch.countDown();
                    Disposer.dispose((Disposable)fileAnalysisDisposable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incomingFileEditors", "org/jetbrains/php/performanceTesting/AbstractRefactoringTestCommand$1", "daemonFinished"));
            }
        });
        try {
            if (!fileAnalysisLatch.await(60L, TimeUnit.SECONDS)) {
                LOG.info("Await timeout occurred in file " + psiFile.getVirtualFile().getPath());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/php/performanceTesting/AbstractRefactoringTestCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPhpFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "rollBackChanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class InputArgs {
        public int numFilesToWalk;
        public int numEntriesToWalk;
        public int randomSeed;

        InputArgs(String rawInput) {
            String[] filesAndRepeat = rawInput.split(" ");
            if (filesAndRepeat.length > 1) {
                this.numFilesToWalk = Integer.parseInt(filesAndRepeat[0]);
                this.numEntriesToWalk = Integer.parseInt(filesAndRepeat[1]);
            }
            if (filesAndRepeat.length > 2) {
                this.randomSeed = Integer.parseInt(filesAndRepeat[2]);
            }
        }

        public int getNumFilesToWalk() {
            return this.numFilesToWalk;
        }

        public int getNumEntriesToWalk() {
            return this.numEntriesToWalk;
        }

        public int getRandomSeed() {
            return this.randomSeed;
        }
    }
}

