/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.messDetector;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolValidationInspection;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorAnnotator;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorOptionsConfiguration;
import com.jetbrains.php.tools.quality.messDetector.RulesetDescriptor;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class MessDetectorValidationInspection
extends QualityToolValidationInspection<MessDetectorValidationInspection> {
    public boolean CODESIZE = false;
    public boolean CONTROVERSIAL = false;
    public boolean DESIGN = false;
    public boolean UNUSEDCODE = false;
    public boolean NAMING = false;
    public final List<RulesetDescriptor> customRulesets = new ArrayList<RulesetDescriptor>();
    public static final String CODE_SIZE_RULES_OPTION = "codesize";
    public static final String CONTROVERSIAL_RULES_OPTION = "controversial";
    public static final String DESIGN_RULES_OPTION = "design";
    public static final String NAMING_RULES_OPTION = "naming";
    public static final String UNUSED_CODE_RULES_OPTION = "unusedcode";
    static final String[] RULESET_OPTIONS = new String[]{"codesize", "controversial", "design", "naming", "unusedcode"};

    @NotNull
    protected MessDetectorAnnotator getAnnotator() {
        MessDetectorAnnotator messDetectorAnnotator = MessDetectorAnnotator.INSTANCE;
        if (messDetectorAnnotator == null) {
            MessDetectorValidationInspection.$$$reportNull$$$0(0);
        }
        return messDetectorAnnotator;
    }

    @Override
    @NlsSafe
    public String getToolName() {
        return "PHP Mess Detector";
    }

    public String getRuleSetsOption(String interpreterId, Project project) {
        MessDetectorOptionsConfiguration configuration = MessDetectorOptionsConfiguration.getInstance(project);
        ArrayList<String> rulesetOptions = new ArrayList<String>();
        if (configuration.isCodeSize()) {
            rulesetOptions.add(CODE_SIZE_RULES_OPTION);
        }
        if (configuration.isDesign()) {
            rulesetOptions.add(DESIGN_RULES_OPTION);
        }
        if (configuration.isNaming()) {
            rulesetOptions.add(NAMING_RULES_OPTION);
        }
        if (configuration.isControversial()) {
            rulesetOptions.add(CONTROVERSIAL_RULES_OPTION);
        }
        if (configuration.isUnusedCode()) {
            rulesetOptions.add(UNUSED_CODE_RULES_OPTION);
        }
        PhpInterpreter id = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
        PhpRemoteInterpreterManager instance = PhpRemoteInterpreterManager.getInstance();
        PhpPathMapper mapper = instance != null && id != null && id.isRemote() ? PhpPathMapper.create(instance.createPathMappings(project, id.getPhpSdkAdditionalData()).getPathMappings()) : PhpPathMapper.createDefaultMapper();
        List<String> customPaths = configuration.getCustomRulesets().stream().map(RulesetDescriptor::getPath).map(i -> mapper.getRemoteFilePath((String)i)).toList();
        return StringUtil.join((Collection)ContainerUtil.concat(rulesetOptions, customPaths), (String)",");
    }

    void setRulesetOptionValue(String optionName, Project project) {
        MessDetectorOptionsConfiguration configuration = MessDetectorOptionsConfiguration.getInstance(project);
        switch (optionName) {
            case "codesize": {
                configuration.setCodeSize(true);
                break;
            }
            case "unusedcode": {
                configuration.setUnusedCode(true);
                break;
            }
            case "naming": {
                configuration.setNaming(true);
                break;
            }
            case "design": {
                configuration.setDesign(true);
                break;
            }
            case "controversial": {
                configuration.setControversial(true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/tools/quality/messDetector/MessDetectorValidationInspection", "getAnnotator"));
    }
}

