/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationBaseManager;
import com.jetbrains.php.tools.quality.QualityToolConfigurationProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfigurationManager<C extends QualityToolConfiguration> {
    @Nullable
    protected final Project myProject;
    protected QualityToolConfigurationBaseManager<C> myProjectManager;
    protected QualityToolConfigurationBaseManager<C> myApplicationManager;

    protected QualityToolConfigurationManager(@Nullable Project project) {
        this.myProject = project;
    }

    public List<C> getAllSettings() {
        if (this.myProjectManager == null) {
            return this.myApplicationManager.initLocalAndGetSettings();
        }
        ArrayList<C> settings = new ArrayList<C>(this.myApplicationManager.getSettings());
        settings.removeIf(QualityToolConfiguration::isLocal);
        this.myProjectManager.initDefaultInterpreterConfiguration(this.myProjectManager.getQualityToolType(), this.myProject);
        return new ArrayList(ContainerUtil.concat(settings, this.myProjectManager.initLocalAndGetSettings()));
    }

    public List<C> getConfigurations() {
        return ContainerUtil.filter(this.getAllSettings(), s -> !s.isDeletedFromTheList());
    }

    public void markAndSetNewSettings(@NotNull List<C> settings) {
        QualityToolConfiguration config;
        QualityToolConfiguration local;
        C config2;
        QualityToolConfiguration defaultInterpreter;
        if (settings == null) {
            QualityToolConfigurationManager.$$$reportNull$$$0(0);
        }
        if ((defaultInterpreter = (QualityToolConfiguration)ContainerUtil.find(settings, c -> c.isCreatedAsDefaultInterpreterConfiguration())) == null && (config2 = this.myProjectManager.getByDefaultInterpreterConfiguration()) != null) {
            ((QualityToolConfiguration)config2).setDeletedFromTheList(true);
            settings.add(config2);
        }
        if ((local = (QualityToolConfiguration)ContainerUtil.find(settings, c -> c.isLocal())) == null && (config = (QualityToolConfiguration)ContainerUtil.find(this.myProjectManager.getSettings(), it -> it.isLocal())) != null) {
            config.setDeletedFromTheList(true);
            settings.add(config);
        }
        this.setSettings(settings);
    }

    public void setSettings(@NotNull List<C> settings) {
        if (settings == null) {
            QualityToolConfigurationManager.$$$reportNull$$$0(1);
        }
        if (this.myProjectManager == null) {
            this.myApplicationManager.setSettings(settings);
            return;
        }
        ArrayList<QualityToolConfiguration> applicationLevel = new ArrayList<QualityToolConfiguration>();
        ArrayList<QualityToolConfiguration> projectLevel = new ArrayList<QualityToolConfiguration>();
        for (QualityToolConfiguration config : settings) {
            if (config.isProjectLevel()) {
                projectLevel.add(config);
                continue;
            }
            applicationLevel.add(config);
        }
        ContainerUtil.addIfNotNull(applicationLevel, (Object)((QualityToolConfiguration)ContainerUtil.find(this.myApplicationManager.getSettings(), QualityToolConfiguration::isLocal)));
        this.myApplicationManager.setSettings(applicationLevel);
        this.myProjectManager.setSettings(projectLevel);
    }

    @Nullable
    public C getLocalSettings() {
        return (C)((QualityToolConfiguration)ContainerUtil.find(this.myProjectManager.getSettings(), QualityToolConfiguration::isLocal));
    }

    @NotNull
    public C getOrCreateLocalSettings() {
        C localConfig = this.getLocalSettings();
        C c = localConfig != null ? localConfig : this.myProjectManager.initLocalSettings();
        if (c == null) {
            QualityToolConfigurationManager.$$$reportNull$$$0(2);
        }
        return c;
    }

    @NotNull
    public C getOrCreateConfigurationByInterpreter(@Nullable PhpInterpreter interpreter) {
        C c = this.getOrCreateConfigurationByInterpreter(interpreter, false);
        if (c == null) {
            QualityToolConfigurationManager.$$$reportNull$$$0(3);
        }
        return c;
    }

    @NotNull
    public C getOrCreateConfigurationByInterpreter(@Nullable PhpInterpreter interpreter, boolean onTheFly) {
        QualityToolConfigurationBaseManager<C> manager;
        C configuration = this.getConfigurationByInterpreter(interpreter);
        if (configuration != null) {
            C c = configuration;
            if (c == null) {
                QualityToolConfigurationManager.$$$reportNull$$$0(4);
            }
            return c;
        }
        QualityToolConfigurationProvider<C> provider = this.myApplicationManager.getQualityToolType().getConfigurationProvider();
        if (interpreter == null || provider == null) {
            QualityToolConfiguration c = (QualityToolConfiguration)ContainerUtil.find(this.myProjectManager.getSettings(), QualityToolConfiguration::isLocal);
            QualityToolConfiguration qualityToolConfiguration = c != null ? c : this.myProjectManager.initLocalSettings();
            if (qualityToolConfiguration == null) {
                QualityToolConfigurationManager.$$$reportNull$$$0(5);
            }
            return (C)qualityToolConfiguration;
        }
        C settings = provider.createConfigurationByInterpreter(interpreter);
        QualityToolConfigurationBaseManager<C> qualityToolConfigurationBaseManager = manager = interpreter.isProjectLevel() ? this.myProjectManager : this.myApplicationManager;
        if (!onTheFly) {
            manager.getSettings().add(settings);
        }
        if (onTheFly) {
            if (interpreter.isRemote()) {
                PhpRemoteInterpreterManager remoteInterpreterManager = PhpRemoteInterpreterManager.getInstance();
                if (remoteInterpreterManager != null) {
                    PathMappingSettings mappings = remoteInterpreterManager.createPathMappings(this.myProject, interpreter.getPhpSdkAdditionalData());
                    provider.fillSettingsByDefaultValue(settings, this.getOrCreateLocalSettings(), (NullableFunction<String, String>)((NullableFunction)localPath -> localPath == null ? null : mappings.convertToRemote(localPath)));
                }
            } else {
                provider.fillSettingsByDefaultValue(settings, this.getOrCreateLocalSettings(), (NullableFunction<String, String>)((NullableFunction)localPath -> localPath));
            }
        }
        C c = settings;
        if (c == null) {
            QualityToolConfigurationManager.$$$reportNull$$$0(6);
        }
        return c;
    }

    @Nullable
    public C getConfigurationByInterpreter(@Nullable PhpInterpreter interpreter) {
        if (interpreter == null) {
            return this.getOrCreateLocalSettings();
        }
        QualityToolConfigurationBaseManager<C> manager = interpreter.isProjectLevel() ? this.myProjectManager : this.myApplicationManager;
        return (C)((QualityToolConfiguration)ContainerUtil.find(manager.getSettings(), setting -> StringUtil.equals((CharSequence)setting.getId(), (CharSequence)interpreter.getId())));
    }

    public C getOrCreateByDefaultInterpreterConfiguration() {
        return this.myProjectManager.getOrCreateByDefaultInterpreterConfiguration(this.myProjectManager.getQualityToolType(), this.myProject);
    }

    public void onInterpretersUpdate() {
        C config = this.myProjectManager.getByDefaultInterpreterConfiguration();
        if (config != null) {
            List<C> projectSettings = this.myProjectManager.getSettings();
            projectSettings.remove(config);
            C newConfig = this.myProjectManager.getOrCreateByDefaultInterpreterConfiguration(this.myProjectManager.getQualityToolType(), this.myProject);
            if (newConfig != null) {
                ((QualityToolConfiguration)newConfig).setDeletedFromTheList(((QualityToolConfiguration)config).isDeletedFromTheList());
                ((QualityToolConfiguration)newConfig).setTimeout(((QualityToolConfiguration)config).getTimeout());
                projectSettings.add(newConfig);
            }
        }
        this.setSettings(this.getAllSettings());
    }

    public String getQualityToolName() {
        return this.myApplicationManager.getQualityToolType().getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLocalSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateConfigurationByInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "markAndSetNewSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

