/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.util.PhpConfigurationUtil;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfiguration
implements Comparable<QualityToolConfiguration> {
    private boolean myCreatedAsDefaultInterpreter = false;
    private boolean myDeletedFromTheList = false;

    @Attribute(value="asDefaultInterpreter")
    public boolean isCreatedAsDefaultInterpreterConfiguration() {
        return this.myCreatedAsDefaultInterpreter;
    }

    public void setCreatedAsDefaultInterpreterConfiguration(boolean value) {
        this.myCreatedAsDefaultInterpreter = value;
    }

    @Attribute(value="deletedFromTheList")
    public boolean isDeletedFromTheList() {
        return this.myDeletedFromTheList;
    }

    public void setDeletedFromTheList(boolean deletedFromTheList) {
        this.myDeletedFromTheList = deletedFromTheList;
    }

    public abstract String getId();

    @NlsContexts.Label
    public String getPresentableName(@Nullable Project project) {
        return PhpBundle.message("label.system.php", new Object[0]);
    }

    public abstract String getInterpreterId();

    public abstract int getTimeout();

    public abstract void setTimeout(int var1);

    @NlsSafe
    public abstract String getToolPath();

    public abstract void setToolPath(String var1);

    public abstract int getMaxMessagesPerFile();

    public boolean isLocal() {
        return StringUtil.equals((CharSequence)PhpBundle.message("local", new Object[0]), (CharSequence)this.getId());
    }

    boolean isProjectLevel() {
        return this.isLocal() || this.isCreatedAsDefaultInterpreterConfiguration() || PhpInterpretersManagerImpl.getInstance(null).findInterpreterById(this.getInterpreterId()) == null;
    }

    protected String serialize(@Nullable String path) {
        String serializedPath = PhpConfigurationUtil.serializePath(path);
        return serializedPath != null ? StringUtil.trimEnd((String)serializedPath, (String)".bat") : null;
    }

    protected String deserialize(@Nullable String path) {
        String deserializePath = PhpConfigurationUtil.deserializePath(path);
        String trimmedPath = deserializePath != null ? StringUtil.trimEnd((String)deserializePath, (String)".bat") : "";
        return trimmedPath + (SystemInfo.isWindows ? ".bat" : "");
    }

    public abstract QualityToolConfiguration clone();

    @NlsContexts.Label
    @Nullable
    String getDescription(Project project) {
        if (this.isLocal() || this.isCreatedAsDefaultInterpreterConfiguration()) {
            return null;
        }
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(this.getInterpreterId());
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter != null ? interpreter.getName() : null);
        return info != null ? info.getVersion() : null;
    }
}

