/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworkBySdkDialog
extends DialogWrapper {
    protected Project myProject;
    private final String myFrameworkName;
    protected PhpInterpreterComboBox myComboBox;

    protected PhpTestFrameworkBySdkDialog(@Nullable Project project, @NotNull String frameworkName) {
        if (frameworkName == null) {
            PhpTestFrameworkBySdkDialog.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.myProject = project;
        this.myFrameworkName = frameworkName;
        this.setTitle(PhpBundle.message("php.test.framework.by.sdk.new.settings.dialog.title", frameworkName));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.initComboBox();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myComboBox);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        JLabel label = new JLabel(this.getLabelText());
        panel.add((Component)label, gc);
        gc.weightx = 1.0;
        ++gc.gridx;
        this.myComboBox.setPreferredSize(new Dimension(200, this.myComboBox.getPreferredSize().height));
        label.setLabelFor((Component)((Object)this.myComboBox));
        panel.add((Component)((Object)this.myComboBox), gc);
        Font font = this.myComboBox.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.myComboBox.getFontMetrics(font);
            int width = fontMetrics.charWidth('a') * 60;
            panel.setPreferredSize(new Dimension(width, 50));
        }
        return panel;
    }

    protected void initComboBox() {
        this.myComboBox = new PhpInterpreterComboBox(this.myProject, (Condition<? super PhpSdkAdditionalData>)((Condition)data -> data instanceof RemoteSdkAdditionalData));
        this.myComboBox.reset();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myComboBox);
    }

    @Nls
    protected String getLabelText() {
        return PhpBundle.message("php.test.framework.by.sdk.dialog.label", new Object[0]);
    }

    @Nullable
    public String getSelectedInterpreterName() {
        return this.myComboBox.getSelectedItemName();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(this.myProject);
        PhpSdkAdditionalData data = manager.findInterpreterDataById(manager.findInterpreterId(this.myComboBox.getSelectedItemName()));
        if (!(data instanceof RemoteSdkAdditionalData)) {
            return new ValidationInfo(PhpBundle.message("php.test.framework.by.sdk.settings.select.server", this.myFrameworkName), (JComponent)((Object)this.myComboBox));
        }
        return super.doValidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkName", "com/jetbrains/php/testFramework/PhpTestFrameworkBySdkDialog", "<init>"));
    }
}

