/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.testFramework.PhpTestDescriptor;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class PhpSuffixBasedTestDescriptor
implements PhpTestDescriptor {
    @Override
    @NotNull
    public Collection<PhpClass> findTests(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(0);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)clazz.getProject());
        String className = clazz.getName();
        Collection collection = this.getNameSuffixes().stream().flatMap(suffix -> phpIndex.getClassesByName(className + suffix).stream()).collect(Collectors.toList());
        if (collection == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PhpClass> findClasses(@NotNull PhpClass test, @NotNull String testName) {
        if (test == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(2);
        }
        if (testName == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(3);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)test.getProject());
        Collection collection = this.getNameSuffixes().stream().filter(suffix -> StringUtil.endsWith((CharSequence)testName, (CharSequence)suffix)).flatMap(suffix -> phpIndex.getClassesByName(testName.substring(0, testName.length() - suffix.length())).stream()).collect(Collectors.toList());
        if (collection == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    public boolean isTestClassName(@NotNull String name) {
        if (name == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(5);
        }
        for (String suffix : this.getNameSuffixes()) {
            if (!StringUtil.endsWith((CharSequence)name, (CharSequence)suffix)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract Collection<String> getNameSuffixes();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpSuffixBasedTestDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpSuffixBasedTestDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findTests";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTests";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTestClassName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

