/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.surroundWith;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Statement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class PhpStatementSurrounder<T extends PsiElement>
implements Surrounder {
    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(0);
        }
        for (PsiElement it : elements) {
            if (!PhpLangUtil.isShortEchoTagStatement(it) && !PhpPsiUtil.isOfType(it, PhpElementTypes.CASE, PhpElementTypes.CASE_DEFAULT)) continue;
            return false;
        }
        if (elements.length > 0) {
            IElementType firstType = elements[0].getNode().getElementType();
            IElementType lastType = elements[elements.length - 1].getNode().getElementType();
            if (firstType == PhpTokenTypes.chRBRACE || lastType == PhpTokenTypes.chLBRACE) {
                return false;
            }
        }
        return true;
    }

    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) {
        if (project == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(3);
        }
        return this.surroundElementsInternal(project, editor, elements);
    }

    public TextRange surroundElements(@NotNull Project project, PsiElement @NotNull [] elements) {
        if (project == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(5);
        }
        Editor selectedTextEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        return this.surroundElementsInternal(project, selectedTextEditor, elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextRange surroundElementsInternal(@NotNull Project project, Editor editor, PsiElement @NotNull [] elements) {
        if (project == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(7);
        }
        T template = this.createStatement(project, elements);
        PsiElement lastElement = elements[elements.length - 1];
        PsiElement container = lastElement.getParent();
        PsiElement statement = container.addAfter(template, lastElement);
        PsiElement insertInto = this.getInsertInto(statement);
        PsiElement anchor = insertInto.getLastChild();
        for (PsiElement element : elements) {
            if (element instanceof PsiWhiteSpace) continue;
            PsiElement childCopy = element.copy();
            element.delete();
            insertInto.addBefore(childCopy, anchor);
        }
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(statement);
        PsiFile file = statement.getContainingFile();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = file.getViewProvider().getDocument();
        if (document != null) {
            RangeMarker marker = document.createRangeMarker(statement.getTextRange());
            try {
                PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(file.getViewProvider());
                CodeStyleManager csManager = CodeStyleManager.getInstance((Project)project);
                csManager.reformatText(file, marker.getStartOffset(), marker.getEndOffset());
                this.postProcess(editor, statement);
            }
            finally {
                marker.dispose();
            }
            if (manager.isUncommited(document)) {
                manager.commitDocument(document);
            }
        }
        return this.getSurroundSelectionRange(pointer.getElement());
    }

    @NotNull
    protected T createStatement(@NotNull Project project, PsiElement @NotNull [] elements) {
        if (project == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(9);
        }
        Statement statement = PhpPsiElementFactory.createStatement(project, this.getStatementTemplate(project, elements));
        if (statement == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(10);
        }
        return (T)statement;
    }

    @NonNls
    protected abstract String getStatementTemplate(Project var1, PsiElement[] var2);

    protected abstract PsiElement getInsertInto(T var1);

    protected void postProcess(@Nullable Editor editor, T statement) {
    }

    protected abstract TextRange getSurroundSelectionRange(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/surroundWith/PhpStatementSurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/surroundWith/PhpStatementSurrounder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "surroundElements";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "surroundElementsInternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createStatement";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

