/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpEval;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.slicer.PhpSliceDereferenceUsage;
import com.jetbrains.php.slicer.PhpSliceLeafUsage;
import com.jetbrains.php.slicer.PhpSliceUsage;
import com.jetbrains.php.slicer.PhpSliceUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSliceForwardUtil {
    public static boolean processUsagesFlownFromThe(@NotNull PsiElement element, @NotNull Processor<? super SliceUsage> processor2, @NotNull PhpSliceUsage parent) {
        PsiElement target;
        if (element == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(2);
        }
        if ((target = PhpSliceForwardUtil.getAssignmentTarget(element)) != null) {
            SliceUsage usage = PhpSliceUtil.createSliceUsage(target, parent);
            return processor2.process((Object)usage);
        }
        if (element instanceof Variable) {
            return PhpSliceForwardUtil.processAssignedFrom(element, element, parent, processor2);
        }
        if (element instanceof Parameter) {
            return PhpSliceForwardUtil.processAssignedFrom(element, element, parent, processor2);
        }
        if (element instanceof Function) {
            return PhpSliceForwardUtil.processAssignedFrom(element, element, parent, processor2);
        }
        if (element instanceof Field) {
            return PhpSliceForwardUtil.processAssignedFrom(element, element, parent, processor2);
        }
        if (element instanceof PhpTraitUseRule) {
            return PhpSliceForwardUtil.processTraitUseRule((PhpTraitUseRule)element, parent, processor2);
        }
        if (element instanceof PhpThrowExpression) {
            return PhpSliceForwardUtil.processThrow(element, processor2, parent);
        }
        return true;
    }

    private static boolean processThrow(@NotNull PsiElement element, @NotNull Processor<? super SliceUsage> processor2, @NotNull PhpSliceUsage parent) {
        Try tryElement;
        if (element == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(5);
        }
        if ((tryElement = (Try)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)element1 -> element1 instanceof Try))) == null) {
            return true;
        }
        for (Catch catchClause : tryElement.getCatchClauses()) {
            SliceUsage usage;
            Variable exception = catchClause.getException();
            if (exception == null || processor2.process((Object)(usage = PhpSliceUtil.createSliceUsage((PsiElement)exception, parent)))) continue;
            return false;
        }
        return true;
    }

    private static boolean processAssignedFrom(PsiElement from, PsiElement context, PhpSliceUsage parent, @NotNull Processor<? super SliceUsage> processor2) {
        if (processor2 == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(6);
        }
        if (from instanceof Variable) {
            return PhpSliceForwardUtil.searchReferencesAndProcessAssignmentTarget(from, context, (Ref<PsiElement>)new Ref(), parent, processor2);
        }
        if (from instanceof Field) {
            return PhpSliceForwardUtil.searchReferencesAndProcessAssignmentTarget(from, null, null, parent, processor2);
        }
        if (from instanceof Parameter) {
            Parameter parameter = (Parameter)from;
            Function function = PhpPsiUtil.getParentOfClass((PsiElement)parameter, false, Function.class);
            if (function == null) {
                return false;
            }
            HashSet<Parameter> parametersToAnalyze = new HashSet<Parameter>();
            if (function instanceof Method) {
                Method method = (Method)function;
                int n = ArrayUtilRt.find((Object[])method.getParameters(), (Object)parameter);
                HashSet<Method> superMethods = new HashSet<Method>(PhpSliceForwardUtil.findDeepestSuperMethods(method, parent.getScope()));
                superMethods.add(method);
                HashSet<Method> implementors = new HashSet<Method>(superMethods);
                for (Method superMethod : superMethods) {
                    ProgressManager.checkCanceled();
                    boolean processed = PhpClassHierarchyUtils.processOverridingMethods((Method)superMethod, (classMember, subClass, baseClass) -> {
                        ProgressManager.checkCanceled();
                        implementors.add((Method)classMember);
                        return true;
                    });
                    if (processed) continue;
                    return false;
                }
                for (Method implementor : implementors) {
                    ProgressManager.checkCanceled();
                    if (!parent.params.scope.contains((PsiElement)implementor)) continue;
                    Parameter[] parameters = implementor.getParameters();
                    if (n == -1 || n >= parameters.length) continue;
                    parametersToAnalyze.add(parameters[n]);
                }
            } else {
                parametersToAnalyze.add(parameter);
            }
            for (Parameter parameter2 : parametersToAnalyze) {
                ProgressManager.checkCanceled();
                if (PhpSliceForwardUtil.searchReferencesAndProcessAssignmentTarget((PsiElement)parameter2, null, (Ref<PsiElement>)new Ref(), parent, processor2)) continue;
                return false;
            }
            return true;
        }
        if (from instanceof Function) {
            HashSet<Object> functionsToProcess = new HashSet<Object>();
            functionsToProcess.add((Function)from);
            if (from instanceof Method) {
                Method method = (Method)from;
                functionsToProcess.addAll(PhpSliceForwardUtil.findDeepestSuperMethods(method, parent.getScope()));
                if (method.getNameCS().equals("__toString")) {
                    PhpSliceForwardUtil.handleToStringMagicMethod(method, processor2, parent);
                }
            }
            HashSet processed = new HashSet();
            Ref lowerBorder = null;
            for (Function function : functionsToProcess) {
                if (ReferencesSearch.search((PsiElement)function, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(reference -> {
                    ProgressManager.checkCanceled();
                    Set set = processed;
                    synchronized (set) {
                        if (!processed.add(reference)) {
                            return true;
                        }
                    }
                    PsiElement element = reference.getElement();
                    return PhpSliceForwardUtil.processAssignmentTarget(element, parent, (Ref<PsiElement>)lowerBorder, processor2);
                })) continue;
                return false;
            }
        }
        return true;
    }

    private static void handleToStringMagicMethod(Method method, @NotNull Processor<? super SliceUsage> processor2, PhpSliceUsage parent) {
        PhpClass containingClass;
        if (processor2 == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(7);
        }
        if ((containingClass = method.getContainingClass()) != null) {
            ReferencesSearch.search((PsiElement)containingClass, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).asIterable().forEach(reference -> {
                PsiElement par;
                if (reference instanceof ClassReference) {
                    PsiElement par2 = ((ClassReference)reference).getParent();
                    if (par2 instanceof NewExpression) {
                        PsiElement grandParent = par2.getParent();
                        if (grandParent instanceof AssignmentExpression) {
                            PhpPsiElement variable2 = ((AssignmentExpression)grandParent).getVariable();
                            if (variable2 != null) {
                                PhpSliceForwardUtil.searchReferencesAndProcessVariableToStringCasts(variable2, processor2, parent);
                            }
                        } else {
                            PhpSliceForwardUtil.tryHandleToStringCast(grandParent, processor2, parent);
                        }
                    }
                } else if (reference instanceof PhpDocType && (par = ((PhpDocType)reference).getParent()) instanceof PhpDocParamTag) {
                    PhpIndex index = PhpIndex.getInstance((Project)par.getProject());
                    index.getVariablesByName(((PhpDocParamTag)par).getVarName()).stream().filter(arg_0 -> ((AnalysisScope)parent.getScope()).contains(arg_0)).forEach(variable -> PhpSliceForwardUtil.searchReferencesAndProcessVariableToStringCasts((PhpPsiElement)variable, processor2, parent));
                }
            });
        }
    }

    private static void searchReferencesAndProcessVariableToStringCasts(PhpPsiElement variable, @NotNull Processor<? super SliceUsage> processor2, PhpSliceUsage parent) {
        if (processor2 == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(8);
        }
        ReferencesSearch.search((PsiElement)variable, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).asIterable().forEach(variableReference -> {
            if (variableReference instanceof Variable) {
                PsiElement variableParent = ((Variable)variableReference).getParent();
                PhpSliceForwardUtil.tryHandleToStringCast(variableParent, processor2, parent);
            }
        });
    }

    private static void tryHandleToStringCast(PsiElement elementParent, @NotNull Processor<? super SliceUsage> processor2, PhpSliceUsage parent) {
        if (processor2 == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(9);
        }
        if (elementParent instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)elementParent).getOperation(), PhpTokenTypes.opSTRING_CAST)) {
            SliceUsage usage = PhpSliceUtil.createSliceUsage(elementParent, parent);
            processor2.process((Object)usage);
        }
    }

    private static boolean searchReferencesAndProcessAssignmentTarget(@NotNull PsiElement element, @Nullable PsiElement context, @Nullable Ref<PsiElement> lowerBorder, PhpSliceUsage parent, Processor<? super SliceUsage> processor2) {
        if (element == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(10);
        }
        return ReferencesSearch.search((PsiElement)element).forEach(reference -> {
            PsiElement element1 = reference.getElement();
            if (context != null && element1.getTextOffset() < context.getTextOffset()) {
                return true;
            }
            return PhpSliceForwardUtil.processAssignmentTarget(element1, parent, lowerBorder, processor2);
        });
    }

    private static boolean processAssignmentTarget(PsiElement element, PhpSliceUsage parent, @Nullable Ref<PsiElement> lowerBorder, Processor<? super SliceUsage> processor2) {
        if (!parent.params.scope.contains(element)) {
            return true;
        }
        if (lowerBorder != null && !lowerBorder.isNull() && element.getTextOffset() > ((PsiElement)lowerBorder.get()).getTextOffset()) {
            return true;
        }
        PsiElement target = PhpSliceForwardUtil.getAssignmentTarget(element);
        if (target != null) {
            SliceUsage usage = PhpSliceUtil.createSliceUsage(element, parent);
            return processor2.process((Object)usage);
        }
        PsiElement psiParent = element.getParent();
        if (psiParent instanceof UnaryExpression && PhpPsiUtil.isOfType(psiParent, PhpElementTypes.POSTFIX_EXPRESSION, PhpElementTypes.INFIX_WRITE_EXPRESSION) && PhpPsiUtil.isOfType(((UnaryExpression)psiParent).getOperation(), PhpTokenTypes.opDECREMENT, PhpTokenTypes.opINCREMENT) && element.equals((Object)((UnaryExpression)psiParent).getValue())) {
            if (lowerBorder != null && (lowerBorder.isNull() || ((PsiElement)lowerBorder.get()).getTextOffset() > psiParent.getTextOffset())) {
                lowerBorder.set((Object)psiParent);
            }
            if (PhpPsiUtil.isOfType(psiParent, PhpElementTypes.POSTFIX_EXPRESSION)) {
                SliceUsage usage = PhpSliceUtil.createSliceUsage(psiParent, parent);
                return processor2.process((Object)usage);
            }
        }
        if (PhpSliceForwardUtil.isTerminalKeywordExpression(psiParent)) {
            PhpSliceLeafUsage usage = new PhpSliceLeafUsage(element, parent);
            return processor2.process((Object)usage);
        }
        if (psiParent instanceof SelfAssignmentExpression && element.equals((Object)((SelfAssignmentExpression)psiParent).getValue())) {
            PhpSliceLeafUsage usage = new PhpSliceLeafUsage(element, parent);
            return processor2.process((Object)usage);
        }
        if (psiParent instanceof BinaryExpression && (element.equals((Object)((BinaryExpression)psiParent).getLeftOperand()) || element.equals((Object)((BinaryExpression)psiParent).getRightOperand()))) {
            PhpSliceLeafUsage usage = new PhpSliceLeafUsage(psiParent, parent);
            return processor2.process((Object)usage);
        }
        if (psiParent instanceof ControlStatement && element.equals((Object)((ControlStatement)psiParent).getCondition()) && PhpPsiUtil.appliesAtLeastOne(psiParent, If.INSTANCEOF, ElseIf.INSTANCEOF, ForeachStatement.INSTANCEOF, While.INSTANCEOF, DoWhile.INSTANCEOF)) {
            PhpSliceLeafUsage usage = new PhpSliceLeafUsage(element, parent);
            return processor2.process((Object)usage);
        }
        if (psiParent instanceof PhpSwitch && element.equals((Object)((PhpSwitch)psiParent).getArgument())) {
            PhpSliceLeafUsage usage = new PhpSliceLeafUsage(element, parent);
            return processor2.process((Object)usage);
        }
        if (psiParent instanceof PhpThrowExpression) {
            SliceUsage usage = PhpSliceUtil.createSliceUsage(psiParent, parent);
            return processor2.process((Object)usage);
        }
        if (parent.params.showInstanceDereferences && PhpSliceForwardUtil.isDereferenced(element)) {
            PhpSliceDereferenceUsage usage = new PhpSliceDereferenceUsage(psiParent, parent);
            return processor2.process((Object)usage);
        }
        return true;
    }

    private static boolean isDereferenced(PsiElement element) {
        if (!(element instanceof PhpReference)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof MemberReference)) {
            return false;
        }
        return element.equals((Object)((MemberReference)parent).getClassReference());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    private static PsiElement getAssignmentTarget(PsiElement element) {
        void var1_12;
        element = PhpSliceForwardUtil.complexify(element);
        Object var1_1 = null;
        PsiElement parent = element.getParent();
        if (parent instanceof AssignmentExpression) {
            AssignmentExpression assignment = (AssignmentExpression)parent;
            if (!(parent instanceof SelfAssignmentExpression)) {
                if (!element.equals((Object)assignment.getValue())) return var1_12;
                PhpPsiElement left = assignment.getVariable();
                if (left instanceof PhpReference && !(left instanceof Variable)) {
                    PsiElement psiElement = ((PhpReference)left).resolve();
                    return var1_12;
                }
                PhpPsiElement phpPsiElement = left;
                return var1_12;
            }
        }
        if (parent instanceof ParameterList) {
            PsiElement grandParent = parent.getParent();
            PsiElement resolvePotentialFunction = null;
            if (grandParent instanceof FunctionReference) {
                FunctionReference methodCall = (FunctionReference)grandParent;
                resolvePotentialFunction = methodCall.resolve();
            } else if (grandParent instanceof NewExpression) {
                ClassReference classReference = ((NewExpression)grandParent).getClassReference();
                if (classReference != null) {
                    PsiElement referenceResolve = classReference.resolve();
                    resolvePotentialFunction = referenceResolve instanceof Method ? (Method)referenceResolve : (referenceResolve instanceof PhpClass ? ((PhpClass)referenceResolve).getConstructor() : null);
                }
            } else if (grandParent instanceof PhpClass) {
                resolvePotentialFunction = ((PhpClass)grandParent).getConstructor();
            }
            if (!(resolvePotentialFunction instanceof Function)) return var1_12;
            Function method = (Function)resolvePotentialFunction;
            Object[] expressions = ((ParameterList)parent).getParameters();
            int index = ArrayUtilRt.find((Object[])expressions, (Object)element);
            Parameter parameter = method.getParameter(index);
            if (parameter == null) return var1_12;
            Parameter parameter2 = parameter;
            return var1_12;
        }
        if (parent instanceof PhpReturn) {
            PhpReturn statement = (PhpReturn)parent;
            if (!element.equals((Object)statement.getArgument())) return var1_12;
            Function function = PhpPsiUtil.getParentOfClass((PsiElement)statement, Function.class);
            return var1_12;
        }
        if (parent instanceof PhpPsiElement && PhpPsiUtil.isOfType(parent, PhpElementTypes.PARAMETER_DEFAULT_VALUE)) {
            Parameter parameter = PhpPsiUtil.getParentOfClass(parent, Parameter.class);
            return var1_12;
        }
        if (element instanceof MethodReference && parent instanceof PhpTraitUseRule && element.equals((Object)((PhpTraitUseRule)parent).getOriginalReference())) {
            PsiElement psiElement = parent;
            return var1_12;
        }
        if (parent instanceof Field && element.equals((Object)((Field)parent).getDefaultValue())) {
            PsiElement psiElement = parent;
            return var1_12;
        }
        if (!(parent instanceof TernaryExpression)) return var1_12;
        if (!element.equals((Object)((TernaryExpression)parent).getFalseVariant())) {
            if (!element.equals((Object)((TernaryExpression)parent).getTrueVariant())) return var1_12;
        }
        PsiElement psiElement = PhpSliceForwardUtil.getAssignmentTarget(parent);
        return var1_12;
    }

    private static boolean processTraitUseRule(PhpTraitUseRule element, PhpSliceUsage parent, Processor<? super SliceUsage> processor2) {
        return true;
    }

    @NotNull
    public static PsiElement complexify(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(11);
        }
        if ((parent = element.getParent()) instanceof UnaryExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.CAST_EXPRESSION) && element.equals((Object)((UnaryExpression)parent).getValue())) {
            return PhpSliceForwardUtil.complexify(parent);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    public static Collection<Method> findDeepestSuperMethods(@NotNull Method method, AnalysisScope scope) {
        if (method == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(13);
        }
        HashMap superMethods = new HashMap();
        PhpClassHierarchyUtils.HierarchyMethodProcessor processor2 = (classMember, subClass, baseClass) -> {
            ProgressManager.checkCanceled();
            if (scope.contains((PsiElement)classMember)) {
                superMethods.put(subClass, classMember);
                superMethods.remove(baseClass);
            }
            return true;
        };
        PhpClassHierarchyUtils.processSuperMethods((Method)method, (PhpClassHierarchyUtils.HierarchyMethodProcessor)processor2);
        return superMethods.values();
    }

    private static boolean isTerminalKeywordExpression(@Nullable PsiElement element) {
        return element instanceof PhpPrintExpression || element instanceof PhpEchoStatement || element instanceof PhpEval || element instanceof PhpEmpty || element instanceof PhpIsset || element instanceof PhpExit || element instanceof PhpPsiElement && element.getParent() instanceof ArrayCreationExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/slicer/PhpSliceForwardUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/slicer/PhpSliceForwardUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "complexify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesFlownFromThe";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processThrow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processAssignedFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleToStringMagicMethod";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "searchReferencesAndProcessVariableToStringCasts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryHandleToStringCast";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "searchReferencesAndProcessAssignmentTarget";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "complexify";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestSuperMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

