/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.remoteDebug;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugProcessFactory;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.debug.listener.PhpDebugExternalConnectionsAccepter;
import com.jetbrains.php.run.PhpDebugRunner;
import com.jetbrains.php.run.remoteDebug.PhpRemoteDebugRunConfiguration;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public final class PhpRemoteDebugDebugRunner
extends PhpDebugRunner<PhpRemoteDebugRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(PhpRemoteDebugDebugRunner.class);
    private static final String ZERO_CONFIGURATION = "https://www.jetbrains.com/help/phpstorm/zero-configuration-debugging.html";

    public PhpRemoteDebugDebugRunner() {
        super(PhpRemoteDebugRunConfiguration.class);
    }

    @NotNull
    public String getRunnerId() {
        return "PhpRemoteDebugRunner";
    }

    @Override
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        PhpRemoteDebugRunConfiguration configuration;
        PhpRemoteDebugRunConfiguration.Settings settings;
        RunProfile profile;
        if (state == null) {
            PhpRemoteDebugDebugRunner.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            PhpRemoteDebugDebugRunner.$$$reportNull$$$0(1);
        }
        if ((profile = environment.getRunProfile()) instanceof PhpRemoteDebugRunConfiguration && StringUtil.isEmpty((String)(settings = (PhpRemoteDebugRunConfiguration.Settings)(configuration = (PhpRemoteDebugRunConfiguration)profile).getSettings()).getServerName())) {
            final Project project = configuration.getProject();
            NotificationListener listener = new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        String description = event.getDescription();
                        if ("zero_config".equals(description)) {
                            BrowserUtil.browse((String)PhpRemoteDebugDebugRunner.ZERO_CONFIGURATION, (Project)project);
                        } else if ("stop".equals(description)) {
                            notification.expire();
                            PhpDebugExternalConnectionsAccepter.getInstance(project).doSwitch();
                            String title = PhpBundle.message("PhpRemoteDebugRunConfigurationEditor.stop.zero.configuration.title", new Object[0]);
                            String message = PhpBundle.message("PhpRemoteDebugRunConfigurationEditor.stop.zero.configuration", new Object[0]);
                            PhpDebugUtil.showInformationBalloon(project, title, message, null);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/run/remoteDebug/PhpRemoteDebugDebugRunner$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            boolean isStarted = PhpDebugExternalConnectionsAccepter.getInstance(project).isStarted();
            if (isStarted) {
                String title = PhpBundle.message("PhpRemoteDebugRunConfigurationEditor.zero.configuration.used.title", new Object[0]);
                String message = PhpBundle.message("PhpRemoteDebugRunConfigurationEditor.zero.configuration.is.already.used", new Object[0]);
                PhpDebugUtil.showInformationBalloon(project, title, message, listener);
            } else {
                PhpDebugExternalConnectionsAccepter.getInstance(project).doSwitch();
                String title = PhpBundle.message("PhpRemoteDebugRunConfigurationEditor.zero.configuration.used.title", new Object[0]);
                String message = PhpBundle.message("PhpRemoteDebugRunConfigurationEditor.zero.configuration.used", configuration.getName());
                PhpDebugUtil.showInformationBalloon(project, title, message, listener);
            }
            return null;
        }
        return super.doExecute(state, environment);
    }

    @Override
    protected RunContentDescriptor doExecute(@NotNull PhpRemoteDebugRunConfiguration configuration, @NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (configuration == null) {
            PhpRemoteDebugDebugRunner.$$$reportNull$$$0(2);
        }
        if (state == null) {
            PhpRemoteDebugDebugRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            PhpRemoteDebugDebugRunner.$$$reportNull$$$0(4);
        }
        Project project = configuration.getProject();
        PhpRemoteDebugRunConfiguration.Settings settings = (PhpRemoteDebugRunConfiguration.Settings)configuration.getSettings();
        PhpServer server = PhpProjectConfigurationFacade.getInstance(project).findServer(settings.getServerName());
        assert (server != null);
        final String serverName = server.getName();
        assert (serverName != null);
        String debuggerId = server.getDebuggerId();
        if (!PhpDebugUtil.isXDebug(debuggerId) && !PhpDebugUtil.isZendDebugger(debuggerId)) {
            throw new ExecutionException(PhpBundle.message("unknown.debugger.type", new Object[0]));
        }
        final PhpDebugExtension debugExtension = PhpDebugUtil.getDebugExtensionByDebuggerId(debuggerId);
        final PhpDebugConnectionManager connectionsManager = debugExtension.createDebugConnectionManager();
        Ref startedSession = new Ref();
        final PhpIncomingDebugConnectionServer debugServer = debugExtension.startDebugServer(project, error -> {
            if (StringUtil.isNotEmpty((String)error)) {
                ProgramRunnerUtil.handleExecutionError((Project)project, (ExecutionEnvironment)env, (Throwable)new ExecutionException(error), (RunProfile)env.getRunProfile());
                XDebugSession session = (XDebugSession)startedSession.get();
                if (session != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Stopping debug session because connection to Xdebug Cloud failed");
                    }
                    session.stop();
                }
            }
        });
        final String sessionId = settings.getSessionId();
        debugServer.registerSessionHandler(sessionId, true, connectionsManager);
        try {
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)project).startSession(env, new XDebugProcessStarter(this){

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) {
                    if (session == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    session.addSessionListener(new XDebugSessionListener(){

                        public void sessionStopped() {
                            debugServer.unregisterSessionHandler(sessionId);
                        }
                    });
                    PhpDebugProcess phpDebugProcess = PhpDebugProcessFactory.forRemoteDebug(session, sessionId, connectionsManager, serverName, debugExtension.getDebugDriver());
                    if (phpDebugProcess == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return phpDebugProcess;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/run/remoteDebug/PhpRemoteDebugDebugRunner$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/run/remoteDebug/PhpRemoteDebugDebugRunner$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            startedSession.set((Object)debugSession);
            return debugSession.getRunContentDescriptor();
        }
        catch (ExecutionException e) {
            debugServer.unregisterSessionHandler(sessionId);
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "environment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/run/remoteDebug/PhpRemoteDebugDebugRunner";
        objectArray[2] = "doExecute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

