/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.run.PhpRunConfigurationSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpRefactoringListenerRunConfiguration<S extends PhpRunConfigurationSettings>
extends PhpRunConfiguration<S>
implements RefactoringListenerProvider {
    protected PhpRefactoringListenerRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        VirtualFile fileOrDir = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (fileOrDir == null) {
            return this.getRefactoringPsiElementListener(element);
        }
        List<PhpRefValue<String>> pathsToUpdate = this.getPathsToUpdate();
        String fileOrDirPath = new File(fileOrDir.getPath()).getAbsolutePath();
        ArrayList<RefactoringElementAdapter> listeners = new ArrayList<RefactoringElementAdapter>();
        for (PhpRefValue<String> pathRef : pathsToUpdate) {
            String string = pathRef.getValue();
            if (StringUtil.isEmpty((String)string)) continue;
            String pathToUpdateAbsolutePath = new File(string).getAbsolutePath();
            if (fileOrDir.isDirectory()) {
                String suffix;
                if (!pathToUpdateAbsolutePath.contains(fileOrDirPath) || !StringUtil.isEmpty((String)(suffix = pathToUpdateAbsolutePath.substring(fileOrDirPath.length()))) && !FileUtil.toSystemIndependentName((String)suffix).startsWith("/")) continue;
                listeners.add(PhpRefactoringListenerRunConfiguration.createRenameListener(pathRef, suffix));
                continue;
            }
            if (!Objects.equals(fileOrDirPath, pathToUpdateAbsolutePath)) continue;
            listeners.add(PhpRefactoringListenerRunConfiguration.createRenameListener(pathRef, null));
        }
        if (listeners.isEmpty()) {
            return null;
        }
        if (listeners.size() == 1) {
            return (RefactoringElementListener)listeners.get(0);
        }
        RefactoringElementListenerComposite compositeListener = new RefactoringElementListenerComposite();
        for (RefactoringElementListener refactoringElementListener : listeners) {
            compositeListener.addListener(refactoringElementListener);
        }
        return compositeListener;
    }

    @Nullable
    protected RefactoringElementListener getRefactoringPsiElementListener(@NotNull PsiElement element) {
        if (element == null) {
            PhpRefactoringListenerRunConfiguration.$$$reportNull$$$0(0);
        }
        return null;
    }

    private static RefactoringElementAdapter createRenameListener(final @NotNull PhpRefValue<String> pathRef, final @Nullable String pathSuffix) {
        if (pathRef == null) {
            PhpRefactoringListenerRunConfiguration.$$$reportNull$$$0(1);
        }
        return new RefactoringElementAdapter(){

            public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                VirtualFile virtualFile;
                if (newElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((virtualFile = ((PsiFileSystemItem)newElement).getVirtualFile()) == null) {
                    return;
                }
                String newFileOrDirName = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                pathRef.setValue(StringUtil.isEmpty((String)pathSuffix) ? newFileOrDirName : newFileOrDirName + pathSuffix);
            }

            public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                if (newElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (oldQualifiedName == null) {
                    1.$$$reportNull$$$0(2);
                }
                pathRef.setValue(StringUtil.isEmpty((String)pathSuffix) ? oldQualifiedName : oldQualifiedName + pathSuffix);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldQualifiedName";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/run/PhpRefactoringListenerRunConfiguration$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementRenamedOrMoved";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "undoElementMovedOrRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    protected List<PhpRefValue<String>> getPathsToUpdate() {
        ArrayList<PhpRefValue<String>> pathsToUpdate = new ArrayList<PhpRefValue<String>>();
        pathsToUpdate.add(new PhpRefValue<String>(){

            @Override
            public String getValue() {
                return ((PhpRunConfigurationSettings)PhpRefactoringListenerRunConfiguration.this.getSettings()).getWorkingDirectory();
            }

            @Override
            public void setValue(String newValue) {
                ((PhpRunConfigurationSettings)PhpRefactoringListenerRunConfiguration.this.getSettings()).setWorkingDirectory(newValue);
            }
        });
        ArrayList<PhpRefValue<String>> arrayList = pathsToUpdate;
        if (arrayList == null) {
            PhpRefactoringListenerRunConfiguration.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/PhpRefactoringListenerRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/PhpRefactoringListenerRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRefactoringPsiElementListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createRenameListener";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    protected static interface PhpRefValue<T> {
        @Nullable
        public T getValue();

        public void setValue(@Nullable T var1);
    }
}

