/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.util.connection.PhpProgressAwareInitCallback;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebugConnectionInitCallback
extends PhpProgressAwareInitCallback {
    private static final Logger LOG = Logger.getInstance(PhpDebugConnectionInitCallback.class);
    private static final int TIMEOUT = 30000;
    private final Semaphore mySemaphore = new Semaphore(1);
    @Nls
    private String myError = null;

    public PhpDebugConnectionInitCallback() {
        super(true);
    }

    @Nls
    public void waitForInitialization(@NotNull Project project, @NotNull ExecutionEnvironment env) {
        if (project == null) {
            PhpDebugConnectionInitCallback.$$$reportNull$$$0(0);
        }
        if (env == null) {
            PhpDebugConnectionInitCallback.$$$reportNull$$$0(1);
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initializing debug connection");
            }
            this.mySemaphore.waitFor(30000L);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initialized debug connection: " + StringUtil.notNullize((String)this.myError, (String)"Succeed"));
            }
            if (StringUtil.isNotEmpty((String)this.myError)) {
                ProgramRunnerUtil.handleExecutionError((Project)project, (ExecutionEnvironment)env, (Throwable)new ExecutionException(this.myError), (RunProfile)env.getRunProfile());
            }
        }
        catch (ProcessCanceledException e) {
            String error = PhpBundle.message("xdebug.cloud.cannot.register.cloud.id", new Object[0]);
            ProgramRunnerUtil.handleExecutionError((Project)project, (ExecutionEnvironment)env, (Throwable)new ExecutionException(error), (RunProfile)env.getRunProfile());
        }
    }

    @Override
    public void onInit(@Nullable @Nls String error) {
        this.myError = error;
        this.mySemaphore.up();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/run/PhpDebugConnectionInitCallback";
        objectArray[2] = "waitForInitialization";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

