/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.roots.PhpNamespaceProvider;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.roots.PhpSourceRootTemplate;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNamespaceByPsrProvider
implements PhpNamespaceProvider {
    public static final PhpNamespaceProvider INSTANCE = new PhpNamespaceByPsrProvider();

    private PhpNamespaceByPsrProvider() {
    }

    @Override
    @NotNull
    public List<String> suggestNamespaces(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(0);
        }
        Project project = directory.getProject();
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        SmartList namespaces = new SmartList();
        for (Module module : modules) {
            ContentEntry[] contentEntries;
            for (ContentEntry entry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                SourceFolder[] sourceFolders;
                for (SourceFolder folder : sourceFolders = entry.getSourceFolders()) {
                    String namespace = PhpNamespaceByPsrProvider.suggestNamespace(directory.getVirtualFile().getPath(), PhpDirectoryByPsrProvider.getFolderPrefix(folder), folder.getFile());
                    if (namespace == null) continue;
                    namespaces.add(namespace);
                }
            }
        }
        ContainerUtil.sort((List)namespaces);
        SmartList smartList = namespaces;
        if (smartList == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    @Nullable
    public static String suggestNamespaceWithPsrRootsDetection(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(2);
        }
        Project project = directory.getProject();
        Set<PhpSourceRootTemplate> roots = PhpPsrNamespaceRootDetector.findSourceRoots(project);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                VirtualFile file = entry.getFile();
                if (file == null) continue;
                for (PhpSourceRootTemplate root : roots) {
                    String namespace;
                    if (!FileUtil.isAncestor((String)file.getPath(), (String)root.getSourcePath(), (boolean)false) || (namespace = PhpNamespaceByPsrProvider.suggestNamespace(directory.getVirtualFile().getPath(), root.getPrefix(), VirtualFileManager.getInstance().findFileByUrl(root.getSourceUrl()))) == null) continue;
                    return namespace;
                }
            }
        }
        return null;
    }

    @Nullable
    private static String suggestNamespace(@NotNull String directory, @NotNull String prefix, @Nullable VirtualFile file) {
        if (directory == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(4);
        }
        if (file == null || !FileUtil.startsWith((String)directory, (String)file.getPath())) {
            return null;
        }
        String directoryRelative = PhpNamespaceByPsrProvider.getRelativeDirectory(file, directory);
        if (directoryRelative == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        if (StringUtil.isNotEmpty((String)prefix)) {
            path.append(prefix);
            if (StringUtil.isNotEmpty((String)directoryRelative)) {
                path.append("\\");
            }
        }
        path.append(StringUtil.replace((String)directoryRelative, (String)"/", (String)"\\"));
        return path.toString();
    }

    @Nullable
    private static String getRelativeDirectory(@NotNull VirtualFile file, @NotNull String directory) {
        String directoryRelative;
        if (file == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(5);
        }
        if (directory == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(6);
        }
        if ((directoryRelative = FileUtil.getRelativePath((String)file.getPath(), (String)directory, (char)'/')) == null || directoryRelative.startsWith("..")) {
            return null;
        }
        return directoryRelative.equals(".") ? "" : directoryRelative;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/PhpNamespaceByPsrProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/PhpNamespaceByPsrProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamespaces";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamespaceWithPsrRootsDetection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamespace";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

