/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.roots.PhpNamespaceProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNamespaceByFilesProvider
implements PhpNamespaceProvider {
    public static final PhpNamespaceProvider INSTANCE = new PhpNamespaceByFilesProvider();

    private PhpNamespaceByFilesProvider() {
    }

    @Override
    @NotNull
    public List<String> suggestNamespaces(@NotNull PsiDirectory directory) {
        PsiFile[] files;
        if (directory == null) {
            PhpNamespaceByFilesProvider.$$$reportNull$$$0(0);
        }
        for (PsiFile file : files = directory.getFiles()) {
            String namespace = PhpNamespaceByFilesProvider.extractNamespace(file);
            if (namespace == null) continue;
            return new SmartList((Object)namespace);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpNamespaceByFilesProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public static String extractNamespace(PsiFile file) {
        if (file instanceof PhpFile) {
            List<PhpNamespace> namespaces = PhpCodeInsightUtil.collectNamespaces(file);
            if (namespaces.isEmpty()) {
                return "";
            }
            PhpNamespace namespace = namespaces.get(0);
            String fqn = namespace.getFQN();
            return PhpLangUtil.toPresentableFQN(fqn);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/PhpNamespaceByFilesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/PhpNamespaceByFilesProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamespaces";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

