/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient.guzzle.extractors;

import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.restClient.guzzle.GuzzleRequestObligatoryParameters;
import com.jetbrains.php.restClient.guzzle.GuzzleRequestOptions;
import com.jetbrains.php.restClient.guzzle.extractors.GuzzleBaseRequestExtractor;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GuzzleSendMethodExtractor
extends GuzzleBaseRequestExtractor {
    private static final String REQUEST_CONSTRUCTOR_FQN = "\\GuzzleHttp\\Psr7\\Request.__construct";

    @Override
    @Nullable
    public GuzzleRequestObligatoryParameters extractObligatoryParameters(@NotNull MethodReference methodReference) {
        NewExpression requestInitialisationExpression;
        if (methodReference == null) {
            GuzzleSendMethodExtractor.$$$reportNull$$$0(0);
        }
        if ((requestInitialisationExpression = GuzzleSendMethodExtractor.findInitialisationExpression(methodReference.getParameter(0), REQUEST_CONSTRUCTOR_FQN)) == null) {
            return null;
        }
        String method = GuzzleSendMethodExtractor.extractHttpMethod(requestInitialisationExpression.getParameter(0));
        if (method == null) {
            return null;
        }
        URL url = GuzzleSendMethodExtractor.extractUrl(requestInitialisationExpression.getParameter(1), methodReference.getClassReference(), methodReference.getParameter(1));
        if (url == null) {
            return null;
        }
        return new GuzzleRequestObligatoryParameters(method, url);
    }

    @Override
    @NotNull
    GuzzleRequestOptions getRequestOptions(@NotNull MethodReference methodReference) {
        if (methodReference == null) {
            GuzzleSendMethodExtractor.$$$reportNull$$$0(1);
        }
        GuzzleRequestOptions methodOptions = GuzzleSendMethodExtractor.extractRequestOptions(methodReference.getParameter(1));
        NewExpression requestInitialisation = GuzzleSendMethodExtractor.findInitialisationExpression(methodReference.getParameter(0), REQUEST_CONSTRUCTOR_FQN);
        GuzzleRequestOptions.HeadersOptions requestHeaders = GuzzleSendMethodExtractor.extractHeadersFromRequest(requestInitialisation);
        String requestBody = GuzzleSendMethodExtractor.extractBodyFromRequest(requestInitialisation);
        if (methodOptions == null) {
            return new GuzzleRequestOptions(null, requestHeaders, Collections.emptyList(), requestBody, null);
        }
        GuzzleRequestOptions.HeadersOptions headers = GuzzleSendMethodExtractor.mergeHeaders(requestHeaders, methodOptions.getHeaders());
        String body = requestBody != null ? requestBody : methodOptions.getBody();
        return new GuzzleRequestOptions(methodOptions.getAuthOptions(), headers, methodOptions.getQuery(), body, methodOptions.getJsonBody());
    }

    @NotNull
    private static GuzzleRequestOptions.HeadersOptions mergeHeaders(@NotNull GuzzleRequestOptions.HeadersOptions requestHeaders, @NotNull GuzzleRequestOptions.HeadersOptions methodHeaders) {
        if (requestHeaders == null) {
            GuzzleSendMethodExtractor.$$$reportNull$$$0(2);
        }
        if (methodHeaders == null) {
            GuzzleSendMethodExtractor.$$$reportNull$$$0(3);
        }
        if (requestHeaders == GuzzleRequestOptions.HeadersOptions.EMPTY) {
            GuzzleRequestOptions.HeadersOptions headersOptions = methodHeaders;
            if (headersOptions == null) {
                GuzzleSendMethodExtractor.$$$reportNull$$$0(4);
            }
            return headersOptions;
        }
        if (methodHeaders == GuzzleRequestOptions.HeadersOptions.EMPTY) {
            GuzzleRequestOptions.HeadersOptions headersOptions = requestHeaders;
            if (headersOptions == null) {
                GuzzleSendMethodExtractor.$$$reportNull$$$0(5);
            }
            return headersOptions;
        }
        MultiMap headers = new MultiMap(requestHeaders.getHeaders());
        for (Map.Entry entry : methodHeaders.getHeaders().entrySet()) {
            headers.put((Object)((String)entry.getKey()), (Collection)entry.getValue());
        }
        return new GuzzleRequestOptions.HeadersOptions((MultiMap<String, String>)headers, methodHeaders.isDefaultDisabled());
    }

    @NotNull
    private static GuzzleRequestOptions.HeadersOptions extractHeadersFromRequest(@Nullable NewExpression request) {
        if (request == null) {
            GuzzleRequestOptions.HeadersOptions headersOptions = GuzzleRequestOptions.HeadersOptions.EMPTY;
            if (headersOptions == null) {
                GuzzleSendMethodExtractor.$$$reportNull$$$0(6);
            }
            return headersOptions;
        }
        GuzzleRequestOptions.HeadersOptions headersOptions = GuzzleSendMethodExtractor.extractHeaders(request.getParameter(2));
        if (headersOptions == null) {
            GuzzleSendMethodExtractor.$$$reportNull$$$0(7);
        }
        return headersOptions;
    }

    @Nullable
    private static String extractBodyFromRequest(@Nullable NewExpression request) {
        if (request == null) {
            return null;
        }
        return GuzzleSendMethodExtractor.getContent(request.getParameter(3));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestHeaders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodHeaders";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/restClient/guzzle/extractors/GuzzleSendMethodExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/restClient/guzzle/extractors/GuzzleSendMethodExtractor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeHeaders";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHeadersFromRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractObligatoryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRequestOptions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeHeaders";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

