/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.httpClient.RestClientIcons;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.debug.HttpRequestDebugger;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugStrategy;
import com.jetbrains.php.debug.common.PhpLocalDebugStrategy;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.debug.connection.PhpDebugPathExtractor;
import com.jetbrains.php.restClient.PhpHttpRequestDebugInitCallback;
import com.jetbrains.php.restClient.PhpHttpRequestDebugProcess;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import org.jetbrains.annotations.NotNull;

public final class PhpXDebugHttpRequestDebugger
implements HttpRequestDebugger {
    private RunContentDescriptor myRunContentDescriptor;
    private static final String SESSION_COOKIE_NAME = "XDEBUG_SESSION";

    public String getPresentableName() {
        return "PHP";
    }

    public void startDebugSession(@NotNull Project project, @NotNull RestClientRequest request, @NotNull String hostName, @NotNull HttpClientRequestProcessHandler executeProcessHandler) throws ExecutionException {
        if (project == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(0);
        }
        if (request == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(1);
        }
        if (hostName == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(2);
        }
        if (executeProcessHandler == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(3);
        }
        RestClientRequest.Biscuit cookies = this.startDebugSessionAndCreateCookies(project, hostName, executeProcessHandler);
        request.biscuits.add(cookies);
    }

    @NotNull
    public RestClientRequest.Biscuit startDebugSessionAndCreateCookies(@NotNull Project project, @NotNull String hostName, @NotNull HttpClientRequestProcessHandler processHandler) throws ExecutionException {
        if (project == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(4);
        }
        if (hostName == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(5);
        }
        if (processHandler == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(6);
        }
        String sessionId = this.startDebugSession(project, hostName, processHandler);
        RestClientRequest.Biscuit biscuit = new RestClientRequest.Biscuit();
        biscuit.setName(SESSION_COOKIE_NAME);
        biscuit.setValue(sessionId);
        biscuit.setPath("/");
        biscuit.setDomain(hostName);
        biscuit.setDate(-1L);
        RestClientRequest.Biscuit biscuit2 = biscuit;
        if (biscuit2 == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(7);
        }
        return biscuit2;
    }

    @NotNull
    private String startDebugSession(@NotNull Project project, @NotNull @NlsSafe String sessionName, @NotNull HttpClientRequestProcessHandler processHandler) throws ExecutionException {
        if (project == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(8);
        }
        if (sessionName == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(9);
        }
        if (processHandler == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(10);
        }
        PhpDebugExtension debugExtension = PhpDebugUtil.getDebugExtensionByDebuggerId("php.debugger.XDebug");
        PhpDebugConnectionManager connectionsManager = debugExtension.createDebugConnectionManager();
        PhpHttpRequestDebugInitCallback initCallback = new PhpHttpRequestDebugInitCallback();
        PhpIncomingDebugConnectionServer debugServer = debugExtension.startDebugServer(project, initCallback);
        String sessionId = debugServer.registerSessionHandler(false, connectionsManager).getSessionId();
        DefaultDebugProcessHandler debugProcessHandler = new DefaultDebugProcessHandler();
        ProcessTerminatedListener.attach((ProcessHandler)debugProcessHandler, (Project)project);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> initCallback.waitForInitialization(project), PhpBundle.message("http.client.request.init.debug.connection.title", new Object[0]), false, project);
        UIUtil.invokeLaterIfNeeded(() -> this.lambda$startDebugSession$1(debugServer, sessionId, (ProcessHandler)debugProcessHandler, processHandler, debugExtension, connectionsManager, project, sessionName));
        String string = sessionId;
        if (string == null) {
            PhpXDebugHttpRequestDebugger.$$$reportNull$$$0(11);
        }
        return string;
    }

    private /* synthetic */ void lambda$startDebugSession$1(final PhpIncomingDebugConnectionServer debugServer, final String sessionId, final ProcessHandler debugProcessHandler, final HttpClientRequestProcessHandler processHandler, final PhpDebugExtension debugExtension, final PhpDebugConnectionManager connectionsManager, Project project, String sessionName) {
        try {
            XDebugProcessStarter processStarter = new XDebugProcessStarter(){

                @NotNull
                public XDebugProcess start(final @NotNull XDebugSession session) {
                    if (session == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    session.addSessionListener(new XDebugSessionListener(){

                        public void sessionStopped() {
                            debugServer.unregisterSessionHandler(sessionId);
                        }
                    });
                    ProcessListener terminateListener = new ProcessListener(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            session.stop();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/restClient/PhpXDebugHttpRequestDebugger$1$2", "processTerminated"));
                        }
                    };
                    debugProcessHandler.addProcessListener(terminateListener);
                    processHandler.addProcessListener(terminateListener);
                    PhpDebugDriver driver = debugExtension.getDebugDriver();
                    PhpDebugPathExtractor pathExtractor = driver.createPathFromUrlExtractor();
                    PhpLocalDebugStrategy debugStrategy = new PhpLocalDebugStrategy(session.getProject());
                    PhpHttpRequestDebugProcess debugProcess = new PhpHttpRequestDebugProcess(session, sessionId, connectionsManager, driver, (PhpDebugStrategy)debugStrategy, pathExtractor, "php.debugger.XDebug");
                    RunContentDescriptor runContentDescriptor = debugProcess.getRunContentDescriptor();
                    if (runContentDescriptor != null) {
                        PhpXDebugHttpRequestDebugger.this.myRunContentDescriptor = runContentDescriptor;
                    }
                    PhpHttpRequestDebugProcess phpHttpRequestDebugProcess = debugProcess;
                    if (phpHttpRequestDebugProcess == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return phpHttpRequestDebugProcess;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/restClient/PhpXDebugHttpRequestDebugger$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/restClient/PhpXDebugHttpRequestDebugger$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
            XDebuggerManager.getInstance((Project)project).startSessionAndShowTab(sessionName, RestClientIcons.Http_requests_run_configuration, this.myRunContentDescriptor, false, processStarter);
            if (!processHandler.isStartNotified()) {
                processHandler.startNotify();
            }
            debugProcessHandler.startNotify();
        }
        catch (ExecutionException e) {
            debugServer.unregisterSessionHandler(sessionId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeProcessHandler";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/restClient/PhpXDebugHttpRequestDebugger";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/restClient/PhpXDebugHttpRequestDebugger";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugSessionAndCreateCookies";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startDebugSession";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startDebugSessionAndCreateCookies";
                break;
            }
            case 7: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11 -> new IllegalStateException(string);
        };
    }
}

