/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.automaticRenamers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class ParametersRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            ParametersRenamerFactory.$$$reportNull$$$0(0);
        }
        if (!(element instanceof Parameter) || ((Parameter)element).isPromotedField()) {
            return false;
        }
        Function function = PhpPsiUtil.getParentOfClass(element, Function.class);
        return function instanceof Method;
    }

    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.parameters.hierarchy");
    }

    public boolean isEnabled() {
        return PhpRefactoringSettings.getInstance().RENAME_PARAMETERS;
    }

    public void setEnabled(boolean enabled) {
        PhpRefactoringSettings.getInstance().RENAME_PARAMETERS = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new ParametersRenamer((Parameter)element, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/rename/automaticRenamers/ParametersRenamerFactory", "isApplicable"));
    }

    public static class ParametersRenamer
    extends AutomaticRenamer {
        public ParametersRenamer(@NotNull Parameter parameter, @NotNull String newName) {
            if (parameter == null) {
                ParametersRenamer.$$$reportNull$$$0(0);
            }
            if (newName == null) {
                ParametersRenamer.$$$reportNull$$$0(1);
            }
            String parameterName = parameter.getName();
            Project project = parameter.getProject();
            Method method = PhpPsiUtil.getParentOfClass((PsiElement)parameter, Method.class);
            assert (method != null);
            int parameterIndex = Arrays.asList(method.getParameters()).indexOf(parameter);
            if (parameterIndex == -1) {
                return;
            }
            ArrayList params = new ArrayList();
            ArrayList list = new ArrayList();
            PhpClassHierarchyUtils.HierarchyMethodProcessor collectParameters = (member, subClass, baseClass) -> {
                list.add(member);
                ContainerUtil.addIfNotNull((Collection)params, (Object)member.getParameter(parameterIndex));
                return true;
            };
            PhpClassHierarchyUtils.processSuperMethods((Method)method, (PhpClassHierarchyUtils.HierarchyMethodProcessor)collectParameters);
            for (Method curMethod : new ArrayList(list)) {
                PhpClassHierarchyUtils.processOverridingMethods((Method)curMethod, (PhpClassHierarchyUtils.TypedHierarchyMemberProcessor)collectParameters);
            }
            PhpClassHierarchyUtils.processOverridingMethods((Method)method, (PhpClassHierarchyUtils.TypedHierarchyMemberProcessor)collectParameters);
            this.myElements.addAll(params);
            this.suggestAllNames(parameterName, newName);
        }

        public String getDialogTitle() {
            return PhpBundle.message("rename.parameters.dialog.title", new Object[0]);
        }

        public String getDialogDescription() {
            return PhpBundle.message("rename.parameter.dialog.description", new Object[0]);
        }

        public String entityName() {
            return PhpBundle.message("column.name.parameter", new Object[0]);
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/rename/automaticRenamers/ParametersRenamerFactory$ParametersRenamer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

