/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.refactoring.move.member.instance.makeStaticThenMove.PhpMoveInstanceMethodDialog;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PhpMoveRefactoringUsageCollector
extends CounterUsagesCollector {
    static final EventLogGroup GROUP = new EventLogGroup("php.move.refactoring", 5);
    static final List<String> MOVE_INSTANCE_REFACTORINGS_IDS = ContainerUtil.map((Object[])PhpMoveInstanceMethodDialog.MoveInstanceMethodActionType.values(), t -> t.myFusActionId);
    static final List<String> MOVE_REFACTORINGS_IDS = List.of("move.instance.method", "move.class", "move.file.constant", "move.function", "move.static.members", "move.namespace");
    static final EventField<String> MOVE_ID = EventFields.String((String)"move_id", (List)ContainerUtil.concat(MOVE_REFACTORINGS_IDS, MOVE_INSTANCE_REFACTORINGS_IDS));
    static final EventField<Boolean> IS_INVOKED_EXPLICITLY = EventFields.Boolean((String)"is_invoked_explicitly");
    static final VarargEventId STARTED = GROUP.registerVarargEvent("started", new EventField[]{MOVE_ID, IS_INVOKED_EXPLICITLY});
    static final EventField<String> STATUS = EventFields.String((String)"status", Arrays.asList("succeed", "cancelled"));
    static final VarargEventId FINISHED = GROUP.registerVarargEvent("finished", new EventField[]{MOVE_ID, IS_INVOKED_EXPLICITLY, STATUS});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void triggerMoveRefactoringStarted(@NotNull Project project, @NotNull String refactoringId) {
        if (project == null) {
            PhpMoveRefactoringUsageCollector.$$$reportNull$$$0(0);
        }
        if (refactoringId == null) {
            PhpMoveRefactoringUsageCollector.$$$reportNull$$$0(1);
        }
        STARTED.log(project, Collections.singletonList(MOVE_ID.with((Object)refactoringId)));
    }

    public static void triggerMoveRefactoringFinished(@NotNull Project project, @NotNull String refactoringId) {
        if (project == null) {
            PhpMoveRefactoringUsageCollector.$$$reportNull$$$0(2);
        }
        if (refactoringId == null) {
            PhpMoveRefactoringUsageCollector.$$$reportNull$$$0(3);
        }
        FINISHED.log(project, new EventPair[]{MOVE_ID.with((Object)refactoringId), STATUS.with((Object)"succeed")});
    }

    public static void triggerMoveRefactoringCancelled(@NotNull Project project, @NotNull String refactoringId) {
        if (project == null) {
            PhpMoveRefactoringUsageCollector.$$$reportNull$$$0(4);
        }
        if (refactoringId == null) {
            PhpMoveRefactoringUsageCollector.$$$reportNull$$$0(5);
        }
        FINISHED.log(project, new EventPair[]{MOVE_ID.with((Object)refactoringId), STATUS.with((Object)"cancelled")});
    }

    public static void triggerMoveMethodToPredefinedClassStarted(@NotNull Project project, boolean isInvokedExplicitly) {
        if (project == null) {
            PhpMoveRefactoringUsageCollector.$$$reportNull$$$0(6);
        }
        STARTED.log(project, Arrays.asList(MOVE_ID.with((Object)"move.instance.method"), IS_INVOKED_EXPLICITLY.with((Object)isInvokedExplicitly)));
    }

    public static void triggerMoveMethodToPredefinedClassFinished(@NotNull Project project, boolean isInvokedExplicitly) {
        if (project == null) {
            PhpMoveRefactoringUsageCollector.$$$reportNull$$$0(7);
        }
        FINISHED.log(project, new EventPair[]{MOVE_ID.with((Object)"move.instance.method"), STATUS.with((Object)"succeed"), IS_INVOKED_EXPLICITLY.with((Object)isInvokedExplicitly)});
    }

    public static void triggerMoveMethodToPredefinedClassCancelled(@NotNull Project project, boolean isInvokedExplicitly) {
        if (project == null) {
            PhpMoveRefactoringUsageCollector.$$$reportNull$$$0(8);
        }
        FINISHED.log(project, new EventPair[]{MOVE_ID.with((Object)"move.instance.method"), STATUS.with((Object)"cancelled"), IS_INVOKED_EXPLICITLY.with((Object)isInvokedExplicitly)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringId";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/statistics/PhpMoveRefactoringUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerMoveRefactoringStarted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerMoveRefactoringFinished";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerMoveRefactoringCancelled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerMoveMethodToPredefinedClassStarted";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerMoveMethodToPredefinedClassFinished";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerMoveMethodToPredefinedClassCancelled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

