/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.function;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.PhpMoveDelegateBase;
import com.jetbrains.php.refactoring.move.function.PhpMoveFunctionProcessor;
import com.jetbrains.php.refactoring.move.function.PhpMoveFunctionToClassDialog;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMoveFunctionDelegate
extends PhpMoveDelegateBase {
    public static final String MOVE_FUNCTION_ID = "move.function";

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (PhpMoveFunctionDelegate.canMoveElement(element)) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    @Override
    public String getRefactoringName() {
        return PhpMoveFunctionDelegate.getRefactoringNameText();
    }

    public boolean isValidTarget(@Nullable PsiElement targetElement, PsiElement[] sources) {
        return targetElement instanceof PhpClass && !((PhpClass)targetElement).isAnonymous();
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (elements.length == 0 || !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)elements[0])) {
            return;
        }
        List functions = ContainerUtil.filterIsInstance((Object[])elements, Function.class);
        if (!functions.isEmpty() && functions.size() == elements.length) {
            PhpMoveRefactoringUsageCollector.triggerMoveRefactoringStarted(project, MOVE_FUNCTION_ID);
            PhpMoveFunctionToClassDialog dialog = new PhpMoveFunctionToClassDialog(functions);
            if (dialog.showAndGet()) {
                PhpClass targetClass = dialog.getTargetClass();
                if (targetClass != null) {
                    new PhpMoveFunctionProcessor(functions, targetClass).run();
                    PhpMoveRefactoringUsageCollector.triggerMoveRefactoringFinished(project, MOVE_FUNCTION_ID);
                }
            } else {
                PhpMoveRefactoringUsageCollector.triggerMoveRefactoringCancelled(project, MOVE_FUNCTION_ID);
            }
        }
    }

    private static boolean canMoveElement(@Nullable PsiElement element) {
        return element instanceof Function && !(element instanceof Method) && !((Function)element).isClosure();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PhpMoveFunctionDelegate.$$$reportNull$$$0(0);
        }
        return PhpBundle.message("refactoring.move.function.action.name", new Object[0]);
    }

    @Nls
    public static String getRefactoringNameText() {
        return PhpBundle.message("refactoring.move.function.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/php/refactoring/move/function/PhpMoveFunctionDelegate", "getActionName"));
    }
}

