/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.constant;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.PhpMoveDelegateBase;
import com.jetbrains.php.refactoring.move.constant.PhpMoveFileConstantDialog;
import com.jetbrains.php.refactoring.move.constant.PhpMoveFileConstantProcessor;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMoveFileConstantDelegate
extends PhpMoveDelegateBase {
    public static final String MOVE_FILE_CONSTANT_ID = "move.file.constant";

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (element instanceof Constant) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    @Override
    public String getRefactoringName() {
        return PhpMoveFileConstantDelegate.getRefactoringNameText();
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (elements.length == 0 || !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)elements[0])) {
            return;
        }
        List constants = ContainerUtil.filterIsInstance((Object[])elements, Constant.class);
        if (!constants.isEmpty() && constants.size() == elements.length) {
            for (Constant constant : constants) {
                if (PhpMoveFileConstantDelegate.checkHasAllowedConstantValue(project, constant, null)) continue;
                return;
            }
            PhpMoveRefactoringUsageCollector.triggerMoveRefactoringStarted(project, MOVE_FILE_CONSTANT_ID);
            PhpMoveFileConstantDialog dialog = new PhpMoveFileConstantDialog(constants);
            if (dialog.showAndGet()) {
                PhpClass targetClass = dialog.getTargetClass();
                if (targetClass != null) {
                    new PhpMoveFileConstantProcessor(constants, targetClass).run();
                    PhpMoveRefactoringUsageCollector.triggerMoveRefactoringFinished(project, MOVE_FILE_CONSTANT_ID);
                }
            } else {
                PhpMoveRefactoringUsageCollector.triggerMoveRefactoringCancelled(project, MOVE_FILE_CONSTANT_ID);
            }
        }
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        if (element instanceof Constant && !PhpMoveFileConstantDelegate.checkHasAllowedConstantValue(project, (Constant)element, editor)) {
            return true;
        }
        return super.tryToMove(element, project, dataContext, reference, editor);
    }

    public static boolean checkHasAllowedConstantValue(@NotNull Project project, @NotNull Constant constant, @Nullable Editor editor) {
        PsiElement value;
        if (project == null) {
            PhpMoveFileConstantDelegate.$$$reportNull$$$0(0);
        }
        if (constant == null) {
            PhpMoveFileConstantDelegate.$$$reportNull$$$0(1);
        }
        if ((value = constant.getValue()) != null && (!PhpCodeValidationUtil.isAllowedAsConstantValue(value) || value instanceof NewExpression)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PhpMoveFileConstantDelegate.getNotAllowedConstantValueMessage(), (String)PhpMoveFileConstantDelegate.getRefactoringNameText(), null);
            return false;
        }
        return true;
    }

    @Nls
    private static String getNotAllowedConstantValueMessage() {
        return PhpBundle.message("annotation.expression.is.not.allowed.as.class.constant.value", new Object[0]);
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PhpMoveFileConstantDelegate.$$$reportNull$$$0(2);
        }
        return PhpBundle.message("refactoring.move.constant.action.name", new Object[0]);
    }

    @Nls
    public static String getRefactoringNameText() {
        return PhpBundle.message("refactoring.move.constant.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/constant/PhpMoveFileConstantDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkHasAllowedConstantValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

