/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceConstant;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpBaseInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpConstantInClassIntroducePanel;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpFileConstantInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantHandler;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantPresenter;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantSettings;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassConstantInplaceIntroducer
extends PhpBaseInplaceIntroducer<Field, PhpIntroduceConstantSettings> {
    private static final int CLASS_CONST_ACCESS_PREFIX_LEN = "self::".length();
    private static final String LAST_SELECTED_VISIBILITY = PhpClassConstantInplaceIntroducer.class.getName() + ".lastSelectedVisibility";
    private final PhpConstantInClassIntroducePanel myPanel;
    private RangeMarker myIntroducedConstantMarker;

    public PhpClassConstantInplaceIntroducer(@NotNull PhpIntroduceConstantHandler handler, @NotNull PhpIntroduceContext context, @NotNull PhpIntroduceConstantSettings settings) {
        if (handler == null) {
            PhpClassConstantInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpClassConstantInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            PhpClassConstantInplaceIntroducer.$$$reportNull$$$0(2);
        }
        super(handler, context, settings);
        this.myPanel = new PhpConstantInClassIntroducePanel(this.myProject, ((PhpIntroduceConstantSettings)this.mySettings).getAccess());
    }

    @Nullable
    protected Field createFieldToStartTemplateOn(boolean replaceAll, String @NotNull [] names) {
        if (names == null) {
            PhpClassConstantInplaceIntroducer.$$$reportNull$$$0(3);
        }
        PhpIntroduceBaseHandler.PhpIntroduceResult introduceResult = this.runRefactoring();
        Field constant = (Field)PhpPsiUtil.getChildByCondition(introduceResult.getIntroducedElement(), (Condition<? super PsiElement>)Field.INSTANCEOF);
        assert (constant != null);
        PsiElement expressionForOriginalElement = introduceResult.getExpressionForOriginalElement();
        ClassConstantReference reference = PhpFileConstantInplaceIntroducer.findIntroducedElementReference(expressionForOriginalElement, (PsiElement)constant, ClassConstantReference.class);
        assert (reference != null) : expressionForOriginalElement;
        this.myIntroducedConstantMarker = this.myEditor.getDocument().createRangeMarker(constant.getTextRange());
        this.myExprMarker = this.myEditor.getDocument().createRangeMarker(reference.getTextRange());
        return constant;
    }

    protected int adjustHighlightsStartOffset(int offset) {
        return offset + CLASS_CONST_ACCESS_PREFIX_LEN;
    }

    protected int getCaretOffset() {
        return this.myExprMarker.getStartOffset() + CLASS_CONST_ACCESS_PREFIX_LEN;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            PhpClassConstantInplaceIntroducer.$$$reportNull$$$0(4);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(new TextRange(0, element.getTextLength()), element);
        if (textRange == null) {
            PhpClassConstantInplaceIntroducer.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpClassConstantInplaceIntroducer.$$$reportNull$$$0(6);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(reference.getRangeInElement(), reference.getElement());
        if (textRange == null) {
            PhpClassConstantInplaceIntroducer.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @Override
    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable Field variable) {
        String[] stringArray = new PhpIntroduceConstantNameSuggestionProvider(this.myContext, ContainerUtil.map2Set(PhpIntroduceConstantPresenter.collectConstDeclarations(this.myContext), PhpNamedElement::getName)).getSuggestedNames();
        if (stringArray == null) {
            PhpClassConstantInplaceIntroducer.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @Override
    @Nullable
    protected JComponent getComponent() {
        return this.myPanel != null ? this.myPanel.getRootPanel() : null;
    }

    @Override
    @Nullable
    protected Field getVariable() {
        return this.restoreElementFromMarker(this.myIntroducedConstantMarker, Field.class);
    }

    protected void moveOffsetAfter(boolean success) {
        if (!success) {
            return;
        }
        PhpReference reference = PhpClassConstantInplaceIntroducer.getConstantReferenceAtCaret(this.myContext, true);
        PhpNamedElement constant = (PhpNamedElement)ObjectUtils.tryCast((Object)(reference != null ? reference.resolve() : null), PhpNamedElement.class);
        Object constantWrapper = PhpPsiUtil.getParentByCondition((PsiElement)constant, (Condition<? super PsiElement>)((Condition)c -> PhpPsiUtil.isOfType(c, PhpElementTypes.CLASS_CONSTANTS)), (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (constantWrapper == null) {
            return;
        }
        String constantName = constant.getName();
        PhpModifier.Access access = this.myPanel.getAccess();
        if (this.myPanel.moveToAnotherClass()) {
            TextRange originalExpressionRange = PhpClassConstantInplaceIntroducer.revertIntroducingAndGetOriginalExpressionRange(reference, constant, constantWrapper, this.myContext);
            if (originalExpressionRange != null) {
                PhpClassConstantInplaceIntroducer.restartIntroducingWithDialogForMove(access, constantName, originalExpressionRange, this.isReplaceAllOccurrences(), this.myEditor, this.myContext);
            }
        } else if (access != ((PhpIntroduceConstantSettings)this.mySettings).getAccess()) {
            WriteAction.run(() -> constantWrapper.replace(new PhpIntroduceConstantHandler().createClassConstantDeclaration(this.myContext, access, constantName)));
            PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_SELECTED_VISIBILITY, access != null ? access.toString() : "");
        }
    }

    @Nullable
    public static PhpModifier.Access getLastSelectedAccess(@NotNull Project project) {
        if (project == null) {
            PhpClassConstantInplaceIntroducer.$$$reportNull$$$0(9);
        }
        String access = StringUtil.notNullize((String)PropertiesComponent.getInstance((Project)project).getValue(LAST_SELECTED_VISIBILITY));
        for (PhpModifier.Access a : PhpModifier.Access.values()) {
            if (!StringUtil.equals((CharSequence)a.toString(), (CharSequence)access)) continue;
            return a;
        }
        return null;
    }

    public static PhpReference getConstantReferenceAtCaret(PhpIntroduceContext context, boolean insideClass) {
        PhpReference reference;
        PsiElement element = PhpClassConstantInplaceIntroducer.findElementAtOffset(context);
        PhpReference phpReference = reference = insideClass ? (PhpReference)PhpPsiUtil.getParentOfClass(element, false, ClassConstantReference.class) : (PhpReference)PhpPsiUtil.getParentOfClass(element, false, ConstantReference.class);
        if (reference == null) {
            reference = (PhpReference)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)((Condition)ClassConstantReference.class::isInstance));
        }
        if (reference == null) {
            reference = (PhpReference)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)((Condition)ConstantReference.class::isInstance));
        }
        return reference;
    }

    @Nullable
    public static PsiElement findElementAtOffset(PhpIntroduceContext context) {
        int offset = context.getEditor().getCaretModel().getOffset();
        PsiFile file = context.getFile();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            element = file.findElementAt(offset - 1);
        }
        while (PhpPsiUtil.isOfType(element, TokenType.WHITE_SPACE, PhpTokenTypes.opSEMICOLON, PhpTokenTypes.chRPAREN, PhpTokenTypes.chRBRACKET)) {
            element = element.getPrevSibling();
        }
        return element;
    }

    public static void restartIntroducingWithDialogForMove(final PhpModifier.Access access, final String constantName, TextRange originalExpressionRange, final boolean occurrences, Editor editor, PhpIntroduceContext introduceContext) {
        PhpIntroduceConstantHandler handler = new PhpIntroduceConstantHandler(){

            @Override
            @NotNull
            protected PhpIntroduceConstantPresenter getPresenter(PhpIntroduceContext introduceContext) {
                PhpIntroduceConstantPresenter presenter = super.getPresenter(introduceContext);
                presenter.setSuggestedNames(constantName);
                presenter.setAccess(access);
                presenter.getSettings().setAllOccurrencesByDefault(occurrences);
                presenter.setMoveToClassByDefault(true);
                PhpIntroduceConstantPresenter phpIntroduceConstantPresenter = presenter;
                if (phpIntroduceConstantPresenter == null) {
                    1.$$$reportNull$$$0(0);
                }
                return phpIntroduceConstantPresenter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpClassConstantInplaceIntroducer$1", "getPresenter"));
            }
        };
        editor.getSelectionModel().setSelection(originalExpressionRange.getStartOffset(), originalExpressionRange.getEndOffset());
        PhpIntroduceContext context = PhpClassConstantInplaceIntroducer.findContext(handler, editor, introduceContext);
        if (context != null) {
            handler.performIntroduceWithDialog(context);
        }
    }

    private static PhpIntroduceContext findContext(PhpIntroduceConstantHandler handler, Editor editor, PhpIntroduceContext context) {
        try {
            return handler.findIntroduceContext(editor, context.getFile());
        }
        catch (PhpIntroduceBaseHandler.RefactoringErrorException e) {
            return null;
        }
    }

    @Nullable
    public static TextRange revertIntroducingAndGetOriginalExpressionRange(PhpReference referenceAtOffsetAfterIntroducing, PhpNamedElement introducedConstant, PsiElement introducedConstantWrapper, PhpIntroduceContext context) {
        Object originalElementCopy = PhpPsiElementFactory.createFromText(context.getProject(), context.getPhysicalElement().getClass(), context.getPhysicalElement().getText());
        if (originalElementCopy == null) {
            return null;
        }
        return (TextRange)WriteAction.compute(() -> {
            RangeMarker[] originalExpressionMarker = new RangeMarker[]{null};
            try {
                ReferencesSearch.search((PsiElement)introducedConstant).asIterable().forEach(r -> {
                    boolean referenceWasOriginalExpression = referenceAtOffsetAfterIntroducing.getElement() == r.getElement();
                    PsiElement revertedReference = r.getElement().replace(originalElementCopy);
                    if (originalExpressionMarker[0] == null && referenceWasOriginalExpression) {
                        originalExpressionMarker[0] = context.getEditor().getDocument().createRangeMarker(revertedReference.getTextRange());
                    }
                });
                introducedConstantWrapper.delete();
                TextRange textRange = originalExpressionMarker[0] != null ? originalExpressionMarker[0].getTextRange() : null;
                return textRange;
            }
            finally {
                if (originalExpressionMarker[0] != null) {
                    originalExpressionMarker[0].dispose();
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpClassConstantInplaceIntroducer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpClassConstantInplaceIntroducer";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFieldToStartTemplateOn";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLastSelectedAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

