/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIntroduceContext {
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    private final SmartPsiElementPointer<PsiElement> myScope;
    private final PsiElement myLogicalElement;
    private final PsiElement myPhysicalElement;
    private final boolean myReplaceSourceElement;
    private final PsiElement myInitValue;
    private final SmartPsiElementPointer<PsiElement> myContext;
    private final TextRange myLogicalElementRange;
    private Collection<PsiElement> myElementOccurrences;
    private Collection<PsiElement> myNonModifyingElementOccurrences;
    private boolean myTransformArrowFunction;

    public PhpIntroduceContext(Editor editor, PsiElement physicalElement, PsiElement logicalElement, TextRange logicalElementRange, PsiElement scope, PsiElement context, PsiFile file, boolean replaceSourceElement) {
        this.myEditor = editor;
        this.myPhysicalElement = physicalElement;
        this.myLogicalElement = logicalElement;
        AssignmentExpression assignment = PhpPsiUtil.getParentOfClass(this.myPhysicalElement, AssignmentExpression.class);
        PhpPsiElement variable = assignment == null ? null : assignment.getVariable();
        this.myReplaceSourceElement = replaceSourceElement && this.myPhysicalElement instanceof Variable && variable == this.myPhysicalElement;
        this.myInitValue = this.myReplaceSourceElement ? assignment.getValue() : this.myLogicalElement;
        this.myLogicalElementRange = logicalElementRange;
        this.myFile = file;
        this.myProject = file.getProject();
        this.myScope = SmartPointerManager.createPointer((PsiElement)scope);
        this.myContext = SmartPointerManager.createPointer((PsiElement)context);
    }

    public void setOccurrences(Collection<PsiElement> elementOccurrences) {
        this.myElementOccurrences = elementOccurrences;
    }

    public void setNonModifyingElementOccurrences(Collection<PsiElement> elementOccurrences) {
        this.myNonModifyingElementOccurrences = elementOccurrences;
    }

    public Collection<PsiElement> getNonModifyingElementOccurrences() {
        if (this.myReplaceSourceElement) {
            return this.myNonModifyingElementOccurrences;
        }
        SmartList elements = new SmartList(this.myNonModifyingElementOccurrences);
        elements.add((Object)this.myLogicalElement);
        return elements;
    }

    public PsiElement getLogicalElement() {
        return this.myLogicalElement;
    }

    public TextRange getLogicalElementRange() {
        return this.myLogicalElementRange;
    }

    public TextRange getPhysicalElementRange() {
        return this.myPhysicalElement.getTextRange();
    }

    @NotNull
    public Collection<PsiElement> getOccurrences(OccurrencesChooser.BaseReplaceChoice choice) {
        if (choice == OccurrencesChooser.ReplaceChoice.ALL) {
            Collection<PsiElement> collection = this.myElementOccurrences;
            if (collection == null) {
                PhpIntroduceContext.$$$reportNull$$$0(0);
            }
            return collection;
        }
        if (choice == PhpIntroduceBaseHandler.WITHOUT_SIDE_EFFECTS_REPLACE_CHOICE) {
            Collection<PsiElement> collection = this.myNonModifyingElementOccurrences;
            if (collection == null) {
                PhpIntroduceContext.$$$reportNull$$$0(1);
            }
            return collection;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            PhpIntroduceContext.$$$reportNull$$$0(2);
        }
        return list;
    }

    public PsiElement[] getOccurrencesWithLogicalElement() {
        if (this.myReplaceSourceElement) {
            return PsiUtilCore.toPsiElementArray(this.myElementOccurrences);
        }
        return (PsiElement[])ArrayUtil.append((Object[])PsiUtilCore.toPsiElementArray(this.myElementOccurrences), (Object)this.myLogicalElement);
    }

    public int getOccurrencesCount() {
        return this.myElementOccurrences.size() + 1;
    }

    public boolean isPhysical() {
        return PsiTreeUtil.isAncestor((PsiElement)this.myPhysicalElement, (PsiElement)this.myLogicalElement, (boolean)false);
    }

    @Nullable
    public PsiElement getScope() {
        return this.myScope.getElement();
    }

    public Project getProject() {
        return this.myProject;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public PsiElement getPhysicalElement() {
        return this.myPhysicalElement;
    }

    @Nullable
    public PsiElement getContext() {
        return this.myContext.getElement();
    }

    public String getElementDeclarationText() {
        String fqn;
        if (this.myInitValue instanceof ClassReference && (fqn = ((ClassReference)this.myLogicalElement).getFQN()) != null) {
            return "'" + fqn + "'";
        }
        return this.myInitValue == null ? "" : this.myInitValue.getText();
    }

    public PsiElement getInitializeValue() {
        return this.myInitValue;
    }

    public boolean isToReplaceSourceElement() {
        return this.myReplaceSourceElement;
    }

    public boolean isTransformArrowFunction() {
        return this.myTransformArrowFunction;
    }

    public void setTransformArrowFunction(boolean transformArrowFunction) {
        this.myTransformArrowFunction = transformArrowFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/introduce/PhpIntroduceContext", "getOccurrences"));
    }
}

